/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.lib.loader.FabricURLClassLoader;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.omf.json.utils.Primitives;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClassUtils {
    public static final Object[] NO_ARGS = new Object[0];
    public static final Class[] NO_ARGS_TYPE = new Class[0];

    public static Object createFromClassName(Object caller, String className, boolean onThread) throws UtilitiesException {
        String callerMessage;
        String string = callerMessage = caller == null ? "unspecified" : caller.getClass().getName();
        if (className.length() == 0) {
            throw new UtilitiesException("Unspecified Class Exception: Instantiating Class " + String.valueOf(caller) + ".");
        }
        if (className.length() == 0) {
            throw new UtilitiesException("Null Class Exception: Instantiating Class " + String.valueOf(caller) + ".");
        }
        try {
            return ClassUtils.createInstance(ClassUtils.loadClass(className, onThread || caller == null ? ClassUtils.getDefaultClassLoader() : caller.getClass().getClassLoader()));
        }
        catch (ClassNotFoundException ex) {
            throw new UtilitiesException("Class Not Found Exception: " + ex.getMessage() + ". Instantiating Class " + callerMessage + ".");
        }
        catch (IllegalAccessException ex) {
            throw new UtilitiesException("Illegal Access Exception: " + ex.getMessage() + ". Instantiating Class " + callerMessage + ".");
        }
        catch (InstantiationException ex) {
            throw new UtilitiesException("Instantiation Exception: " + ex.getMessage() + ". Instantiating Class " + callerMessage + ".");
        }
        catch (SecurityException ex) {
            throw new UtilitiesException("Security Exception: " + ex.getMessage() + ". Instantiating Class " + callerMessage + ".");
        }
        catch (IllegalArgumentException ex) {
            throw new UtilitiesException("Illegal Argument Exception: " + ex.getMessage() + ". Instantiating Class " + callerMessage + ".");
        }
    }

    public static Object createFromClassName(Object caller, String className, ClassLoader loader) throws UtilitiesException {
        String callerMessage;
        String string = callerMessage = caller == null ? "unspecified" : caller.getClass().getName();
        if (className.length() == 0) {
            throw new UtilitiesException("Unspecified Class Exception: Instantiating Class " + String.valueOf(caller) + ".");
        }
        if (className.length() == 0) {
            throw new UtilitiesException("Null Class Exception: Instantiating Class " + String.valueOf(caller) + ".");
        }
        try {
            return ClassUtils.createInstance(ClassUtils.loadClass(className, loader != null ? loader : ClassUtils.getDefaultClassLoader()));
        }
        catch (ClassNotFoundException ex) {
            throw new UtilitiesException("Class Not Found Exception: " + ex.getMessage() + ". Instantiating Class " + callerMessage + ".");
        }
        catch (IllegalAccessException ex) {
            throw new UtilitiesException("Illegal Access Exception: " + ex.getMessage() + ". Instantiating Class " + callerMessage + ".");
        }
        catch (InstantiationException ex) {
            throw new UtilitiesException("Instantiation Exception: " + ex.getMessage() + ". Instantiating Class " + callerMessage + ".");
        }
        catch (SecurityException ex) {
            throw new UtilitiesException("Security Exception: " + ex.getMessage() + ". Instantiating Class " + callerMessage + ".");
        }
        catch (IllegalArgumentException ex) {
            throw new UtilitiesException("Illegal Argument Exception: " + ex.getMessage() + ". Instantiating Class " + callerMessage + ".");
        }
    }

    private static Object createInstance(Class objClass) throws IllegalAccessException, InstantiationException, UtilitiesException {
        if (objClass.equals(Boolean.class)) {
            return false;
        }
        if (objClass.equals(Byte.class)) {
            return (byte)0;
        }
        if (objClass.equals(Short.class)) {
            return (short)0;
        }
        if (objClass.equals(Integer.class)) {
            return 0;
        }
        if (objClass.equals(Long.class)) {
            return 0L;
        }
        if (objClass.equals(Float.class)) {
            return Float.valueOf(0.0f);
        }
        if (objClass.equals(Double.class)) {
            return 0.0;
        }
        if (objClass.equals(BigDecimal.class)) {
            return new BigDecimal(0);
        }
        if (objClass.equals(BigInteger.class)) {
            return new BigInteger("0");
        }
        if (objClass.equals(byte[].class)) {
            return new byte[0];
        }
        try {
            Constructor constructor = objClass.getDeclaredConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException exception) {
            throw new UtilitiesException("Class has no empty constructor.");
        }
        catch (InvocationTargetException exception) {
            throw new UtilitiesException("Instantiation of object failed.", exception.getCause());
        }
    }

    public static Vector<String> getSystemClassLoaderJars() {
        URL[] urls;
        Vector<String> urlList = new Vector<String>();
        for (URL url : urls = ((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs()) {
            urlList.add(url.toString());
        }
        return urlList;
    }

    public static List<String> getClassLoaderJars(ClassLoader loader) {
        URL[] urls = null;
        if (loader instanceof URLClassLoader) {
            urls = ((URLClassLoader)loader).getURLs();
        } else if (loader instanceof FabricURLClassLoader) {
            urls = ((FabricURLClassLoader)loader).getURLs();
        }
        ArrayList<String> urlList = new ArrayList<String>();
        if (urls != null) {
            for (URL url : urls) {
                urlList.add(url.toString());
            }
        }
        return urlList;
    }

    public static Class validateFromClassName(Object parent, String className, boolean onThread) throws UtilitiesException {
        if (className.length() == 0) {
            throw new UtilitiesException("ClassNotSpecifiedException by instantiating Class " + parent.getClass().getName());
        }
        if (className == null) {
            throw new UtilitiesException("NullClassNameException by instantiating Class " + parent.getClass().getName());
        }
        try {
            return ClassUtils.loadClass(className, onThread ? ClassUtils.getDefaultClassLoader() : parent.getClass().getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new UtilitiesException("ClassNotFoundException for Class: " + ex.getMessage() + " by instantiating Class " + parent.getClass().getName());
        }
    }

    public static Method getMethod(Class clazz, String methodName, Class[] parameters) {
        return ClassUtils.getMethodAllowNulls(clazz, methodName, parameters, false);
    }

    public static Method getMethodAllowNulls(Class clazz, String methodName, Class[] parameters, boolean allowNulls) {
        Method genericMethod = null;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            if (parameters == null) {
                return method;
            }
            if (ClassUtils.compareAllowNulls(method.getParameterTypes(), parameters, false, allowNulls, false)) {
                return method;
            }
            if (!ClassUtils.compareAllowNulls(method.getParameterTypes(), parameters, true, allowNulls, false)) continue;
            genericMethod = method;
        }
        return genericMethod;
    }

    public static Method getDeclaredOrInheritedMethod(Class clazz, String methodName, Class[] parameters, boolean allowNulls) {
        while (clazz != null) {
            Method result = ClassUtils.getMethodAllowNulls(clazz, methodName, parameters, allowNulls);
            if (result != null) {
                return result;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Constructor getConstructor(Class clazz, Class[] paramTypes) {
        Constructor<?>[] ctors;
        for (Constructor<?> ctor : ctors = clazz.getDeclaredConstructors()) {
            Class<?>[] types = ctor.getParameterTypes();
            if (types.length != paramTypes.length) continue;
            boolean match = true;
            for (int x = 0; x < types.length; ++x) {
                if (paramTypes[x] == null || types[x].isAssignableFrom(paramTypes[x])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return ctor;
        }
        return null;
    }

    public static Constructor getSatisfiableConstructor(Class clazz, Class[] paramTypes) {
        Constructor<?>[] ctors = clazz.getDeclaredConstructors();
        Constructor<?> satisfiableConstructor = null;
        for (Constructor<?> ctor : ctors) {
            Class[] types = ctor.getParameterTypes();
            if (types.length != paramTypes.length) continue;
            boolean match = true;
            for (int x = 0; x < types.length; ++x) {
                if (paramTypes[x] == null || types[x].isAssignableFrom(paramTypes[x])) continue;
                match = false;
                break;
            }
            if (match) {
                return ctor;
            }
            if (!ClassUtils.compare(types, paramTypes, true)) continue;
            satisfiableConstructor = ctor;
        }
        return satisfiableConstructor;
    }

    public static List<Method> findSatisfiableMethods(Class clazz, String methodName, Class[] methodParms, boolean genericsOk, boolean allowNulls) {
        boolean NO_PARAMETERS = methodParms == null || methodParms.length == 0;
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            if (NO_PARAMETERS) {
                if (method.getParameterTypes().length == 0) {
                    result.add(0, method);
                    continue;
                }
                if (method.getParameterTypes().length != 1 || !method.isVarArgs()) continue;
                result.add(method);
                continue;
            }
            boolean added = false;
            Class[] methodParameterTypes = method.getParameterTypes();
            if (ClassUtils.compareAllowNulls(methodParameterTypes, methodParms, genericsOk, allowNulls, false)) {
                result.add(0, method);
                added = true;
            } else if (method.isVarArgs() && methodParameterTypes.length > 0) {
                if (methodParameterTypes.length == methodParms.length + 1) {
                    if (ClassUtils.compareAllowNulls(methodParameterTypes = Arrays.copyOf(methodParameterTypes, methodParameterTypes.length - 1), methodParms, genericsOk, allowNulls, false)) {
                        result.add(method);
                        added = true;
                    }
                } else if (methodParms.length >= methodParameterTypes.length) {
                    boolean assignable = true;
                    Class<?> varargParameterType = methodParameterTypes[methodParameterTypes.length - 1];
                    Class<?> varargParameterTypeComponentType = varargParameterType.getComponentType();
                    for (int i = methodParameterTypes.length - 1; i < methodParms.length; ++i) {
                        if (methodParms[i] == null || varargParameterTypeComponentType.isAssignableFrom(methodParms[i]) || TypeFactory.unwrapBoxer(varargParameterTypeComponentType).isAssignableFrom(TypeFactory.unwrapBoxer(methodParms[i]))) continue;
                        assignable = false;
                        break;
                    }
                    if (assignable) {
                        Class[] methodParamsNew = Arrays.copyOf(methodParms, methodParameterTypes.length);
                        methodParamsNew[methodParamsNew.length - 1] = varargParameterType;
                        if (ClassUtils.compare(methodParameterTypes, methodParamsNew, genericsOk)) {
                            result.add(method);
                            added = true;
                        }
                    }
                }
            }
            if (added || !ClassUtils.compareAllowNulls(methodParameterTypes, methodParms, genericsOk, allowNulls, true)) continue;
            result.add(method);
        }
        return result;
    }

    public static Field getClassField(Class<?> clazz, String fieldName) throws UtilitiesException {
        if (clazz == null) {
            throw new UtilitiesException("Field lookup exception: Class is null.");
        }
        if (fieldName == null) {
            throw new UtilitiesException("Field lookup exception: Field Name is null.");
        }
        for (Class<?> lookupClass = clazz; lookupClass != null; lookupClass = lookupClass.getSuperclass()) {
            try {
                return lookupClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new UtilitiesException("Class '" + clazz.getSimpleName() + "' does not have '" + fieldName + "' field.");
    }

    public static List<Method> findSatisfiableMethodsWithReturnType(Method[] methods, Class returnType, boolean genericsOk) throws UtilitiesException {
        if (methods == null) {
            throw new UtilitiesException("Method find exception: Method List is null.");
        }
        if (methods.length == 0) {
            throw new UtilitiesException("Method find exception: Method List is empty.");
        }
        boolean NO_RETURN_PARAMETER = false;
        if (returnType == null) {
            NO_RETURN_PARAMETER = true;
        } else if (returnType.isPrimitive()) {
            throw new UtilitiesException("Method find exception: Primitive return types unsupported.");
        }
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : methods) {
            Class<?> returns = method.getReturnType();
            if (NO_RETURN_PARAMETER) {
                if (!method.getReturnType().getName().equals("void")) continue;
                result.add(method);
                continue;
            }
            if (!ClassUtils.compare(new Class[]{returns}, new Class[]{returnType}, genericsOk)) continue;
            result.add(method);
        }
        return result;
    }

    public static boolean isClassOnPath(String className, Class currentClass, boolean onThread) {
        try {
            ClassUtils.validateFromClassName(currentClass, className, onThread);
        }
        catch (UtilitiesException ex) {
            return false;
        }
        return true;
    }

    public static boolean compare(Class[] matcherClassArray, Class[] sourceClassArray, boolean genericsOk) {
        return ClassUtils.compareAllowNulls(matcherClassArray, sourceClassArray, genericsOk, false, false);
    }

    public static boolean compareAllowNulls(Class<?>[] matcherClassArray, Class<?>[] sourceClassArray, boolean genericsOk, boolean allowNulls, boolean withNumericsCast) {
        if (genericsOk && matcherClassArray.length == 1 && matcherClassArray[0] != null && matcherClassArray[0].isArray() && sourceClassArray.length > 0 && sourceClassArray[0] != null && !sourceClassArray[0].isArray()) {
            Class<?> elementType = matcherClassArray[0].getComponentType();
            matcherClassArray = new Class[sourceClassArray.length];
            Arrays.fill(matcherClassArray, elementType);
        }
        if (matcherClassArray.length != sourceClassArray.length) {
            return false;
        }
        for (int i = 0; i < matcherClassArray.length; ++i) {
            if (matcherClassArray[i].equals(Object.class) && !genericsOk) {
                return false;
            }
            if (allowNulls && sourceClassArray[i] == null) continue;
            boolean result = true;
            Class<?> matcherClass = matcherClassArray[i];
            Class<?> sourceClass = sourceClassArray[i];
            if (!(matcherClass.isAssignableFrom(sourceClass) || matcherClass.isAssignableFrom(Primitives.wrap(sourceClass)) || matcherClass.isAssignableFrom(Primitives.unwrap(sourceClass)))) {
                result = false;
            }
            if (!result && withNumericsCast && Number.class.isAssignableFrom(Primitives.wrap(matcherClass)) && Number.class.isAssignableFrom(Primitives.wrap(sourceClass))) {
                result = true;
            }
            if (result) continue;
            return false;
        }
        return true;
    }

    public static Method getDeclaredOrInheritedMethodCastNumerics(Class<?> clazz, String methodName, Class<?>[] argumentClasses) {
        ArrayList<Method> methods = null;
        while (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.getParameterCount() != argumentClasses.length || !method.getName().equals(methodName)) continue;
                if (method.getParameterCount() == 0 && argumentClasses.length == 0) {
                    return method;
                }
                boolean matches = true;
                boolean exactMatch = true;
                Class<?>[] methodClasses = method.getParameterTypes();
                for (int i = 0; i < methodClasses.length; ++i) {
                    Class<?> methodClassWrapper;
                    Class<?> argumentClass = argumentClasses[i];
                    Class<?> methodClass = methodClasses[i];
                    if (argumentClass == null || argumentClass == methodClass) continue;
                    if (methodClass.isAssignableFrom(argumentClass)) {
                        exactMatch = false;
                        continue;
                    }
                    Class<?> argumentClassWrapper = TypeFactory.wrapPrimitive(argumentClass);
                    if (argumentClassWrapper == (methodClassWrapper = TypeFactory.wrapPrimitive(methodClass))) continue;
                    if (Number.class.isAssignableFrom(argumentClassWrapper) && Number.class.isAssignableFrom(methodClassWrapper)) {
                        exactMatch = false;
                        continue;
                    }
                    if (argumentClass == Object.class) {
                        exactMatch = false;
                        continue;
                    }
                    matches = false;
                    exactMatch = false;
                    break;
                }
                if (exactMatch) {
                    return method;
                }
                if (!matches) continue;
                if (methods == null) {
                    methods = new ArrayList<Method>();
                }
                methods.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        if (methods == null || methods.size() == 0) {
            return null;
        }
        if (methods.size() == 1) {
            return (Method)methods.get(0);
        }
        return (Method)methods.get(0);
    }

    public static Method findBestDeclaredOrInheritedMethod(Class<?> clazz, String methodName, Class<?>[] argumentClasses, boolean allowNulls) {
        Method bestMethod = null;
        while (clazz != null) {
            block1: for (Method method : clazz.getDeclaredMethods()) {
                int i;
                if (!method.getName().equals(methodName)) continue;
                Object[] methodClasses = method.getParameterTypes();
                if (methodClasses.length == 1 && methodClasses[0] != null && methodClasses[0].isArray() && argumentClasses.length > 0 && argumentClasses[0] != null && !argumentClasses[0].isArray()) {
                    Class<?> elementType = methodClasses[0].getComponentType();
                    methodClasses = new Class[argumentClasses.length];
                    Arrays.fill(methodClasses, elementType);
                }
                if (methodClasses.length != argumentClasses.length) continue;
                boolean allParamsAssigneable = true;
                boolean allParamsTheSame = true;
                for (i = 0; i < methodClasses.length; ++i) {
                    if (allowNulls && argumentClasses[i] == null) {
                        allParamsTheSame = false;
                        continue;
                    }
                    Class<?> cls = argumentClasses[i];
                    if (!(methodClasses[i].equals(cls) || methodClasses[i].equals(Primitives.wrap(cls)) || methodClasses[i].equals(Primitives.unwrap(cls)))) {
                        allParamsTheSame = false;
                    }
                    if (methodClasses[i].isAssignableFrom(cls) || ((Class)methodClasses[i]).isAssignableFrom(Primitives.wrap(cls)) || ((Class)methodClasses[i]).isAssignableFrom(Primitives.unwrap(cls))) continue;
                    allParamsAssigneable = false;
                }
                if (allParamsTheSame) {
                    return method;
                }
                if (!allParamsAssigneable) continue;
                if (bestMethod != null) {
                    for (i = 0; i < methodClasses.length; ++i) {
                        int bestDistance;
                        int currentDistance;
                        if (argumentClasses[i] == null || (currentDistance = ClassUtils.getClassesDistance(argumentClasses[i], methodClasses[i])) >= (bestDistance = ClassUtils.getClassesDistance(argumentClasses[i], bestMethod.getParameterTypes()[i]))) continue;
                        bestMethod = method;
                        continue block1;
                    }
                    continue;
                }
                bestMethod = method;
            }
            clazz = clazz.getSuperclass();
        }
        return bestMethod;
    }

    public static List<Method> findAllMethods(Class<?> clazz, String methodName, int numOfParams) {
        ArrayList<Method> result = new ArrayList<Method>();
        while (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                Class<?>[] methodParameters;
                if (!method.getName().equals(methodName) || (methodParameters = method.getParameterTypes()).length != numOfParams) continue;
                result.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private static int getClassesDistance(Class<?> upper, Class<?> parent) {
        int distance = 0;
        if (!parent.isAssignableFrom(upper)) {
            return Integer.MAX_VALUE;
        }
        while (upper != null && !upper.equals(parent)) {
            ++distance;
            if (upper == upper.getSuperclass()) {
                distance = Integer.MAX_VALUE;
                break;
            }
            upper = upper.getSuperclass();
        }
        return distance;
    }

    public static Object invokeMethod(Object methodClass, Method method) throws UtilitiesException, InvocationTargetException {
        try {
            return method.invoke(methodClass, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            throw new UtilitiesException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new UtilitiesException(ex.getMessage());
        }
    }

    public static Object invokeMethod(Object methodClass, Method method, Object[] parameters) throws UtilitiesException, InvocationTargetException {
        try {
            return method.invoke(methodClass, parameters);
        }
        catch (IllegalArgumentException ex) {
            throw new UtilitiesException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new UtilitiesException(ex.getMessage());
        }
    }

    public static Class[] getAllClassInterfaces(Class clazz) {
        Set<Class> interfaces = ClassUtils.getClassInterfacesAsSet(clazz);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static Set<Class> getClassInterfacesAsSet(Class clazz) {
        if (clazz.isInterface()) {
            return Collections.singleton(clazz);
        }
        HashSet<Class> interfaces = new HashSet<Class>();
        while (clazz != null) {
            Collections.addAll(interfaces, clazz.getInterfaces());
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    public static String getClassPackageAsResourcePath(Class clazz) {
        if (clazz == null || clazz.getPackage() == null) {
            return "";
        }
        return clazz.getPackage().getName().replace('.', '/');
    }

    public static void isInstanceOf(Class clazz, Object obj) throws UtilitiesException {
        if (clazz == null) {
            throw new UtilitiesException("The isInstanceOf() source class cannot be null.");
        }
        if (!clazz.isInstance(obj)) {
            throw new UtilitiesException("Object of class '" + (obj != null ? obj.getClass().getName() : "[null]") + "' must be an instance of '" + clazz.getName() + "'");
        }
    }

    public static void isAssignable(Class superType, Class subType) throws UtilitiesException {
        if (superType == null) {
            throw new UtilitiesException("The isAssignable() superType cannot be null.");
        }
        if (subType == null) {
            throw new UtilitiesException("The isAssignable() subType cannot be null.");
        }
        if (!superType.isAssignableFrom(subType)) {
            throw new UtilitiesException("Type [" + subType.getName() + "] is not assignable to type [" + superType.getName() + "]");
        }
    }

    public static Object[] getClassPath() {
        Object[] classPathList = new Object[]{""};
        String classPath = System.getProperty("java.class.path");
        StringTokenizer sTokenizer = new StringTokenizer(classPath, ";");
        int tokenCount = sTokenizer.countTokens();
        if (tokenCount > 0) {
            classPathList = new Object[tokenCount];
        }
        for (int i = 0; i < tokenCount; ++i) {
            classPathList[i] = sTokenizer.nextToken();
        }
        Arrays.sort(classPathList);
        return classPathList;
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassUtils.class.getClassLoader();
        }
        return cl;
    }

    public static List<Class> getLoadedClassList(ClassLoader CL) throws NoSuchFieldException, IllegalAccessException {
        Class<?> CL_class;
        for (CL_class = CL.getClass(); CL_class != ClassLoader.class; CL_class = CL_class.getSuperclass()) {
        }
        Field ClassLoader_classes_field = CL_class.getDeclaredField("classes");
        ClassLoader_classes_field.setAccessible(true);
        return new ArrayList<Class>((Vector)ClassLoader_classes_field.get(CL));
    }

    public static List<Class> getLoadedClassList() throws NoSuchFieldException, IllegalAccessException {
        return ClassUtils.getLoadedClassList(ClassUtils.getDefaultClassLoader());
    }

    public static void printLoadedClassnames() throws IllegalAccessException, NoSuchFieldException {
        for (ClassLoader myCL = ClassUtils.getDefaultClassLoader(); myCL != null; myCL = myCL.getParent()) {
            System.out.println("Default {Non Null} ClassLoader: " + String.valueOf(myCL) + "\n");
            for (Class clazz : ClassUtils.getLoadedClassList(myCL)) {
                System.out.println("\t" + clazz.getName());
            }
        }
    }

    public static Vector<String> getLoadedClassNames() throws IllegalAccessException, NoSuchFieldException {
        Vector<String> classes = new Vector<String>();
        for (ClassLoader myCL = ClassUtils.getDefaultClassLoader(); myCL != null; myCL = myCL.getParent()) {
            for (Class clazz : ClassUtils.getLoadedClassList(myCL)) {
                classes.add(clazz.getName());
            }
        }
        return classes;
    }

    public static void printLoadedClassNames(Class clazz) throws IllegalAccessException, NoSuchFieldException {
        for (ClassLoader myCL = clazz.getClass().getClassLoader(); myCL != null; myCL = myCL.getParent()) {
            System.out.println("ClassLoader: " + String.valueOf(myCL) + "\n");
            for (Class loadedClazz : ClassUtils.getLoadedClassList(myCL)) {
                System.out.println("\t" + loadedClazz.getName());
            }
        }
    }

    public static Iterator<String> getLoadedClassNames(Class clazz) throws IllegalAccessException, NoSuchFieldException {
        Vector<String> classes = new Vector<String>();
        for (ClassLoader myCL = clazz.getClass().getClassLoader(); myCL != null; myCL = myCL.getParent()) {
            for (Class loadedClazz : ClassUtils.getLoadedClassList(myCL)) {
                classes.add(loadedClazz.getName());
            }
        }
        return classes.iterator();
    }

    public static Class loadClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader != null && name.length() > 0) {
            if (name.charAt(0) != '[') {
                return classLoader.loadClass(name);
            }
            if (name.charAt(name.length() - 1) == ';') {
                return Class.forName(name, false, classLoader);
            }
        }
        return Class.forName(name);
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ClassUtils.getAllFields(clazz, fields);
        return fields;
    }

    public static void getAllFields(Class<?> clazz, List<Field> fields) {
        if (clazz == null) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            fields.add(field);
        }
        ClassUtils.getAllFields(clazz.getSuperclass(), fields);
    }

    public static List<Method> getAllMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ClassUtils.getAllMethods(clazz, methods);
        return methods;
    }

    public static void getAllMethods(Class<?> clazz, List<Method> methods) {
        if (clazz == null) {
            return;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            methods.add(method);
        }
        ClassUtils.getAllMethods(clazz.getSuperclass(), methods);
    }

    public static Object[] castMethodArguments(Method method, Object[] arguments) {
        Class<?>[] types;
        if (method.isVarArgs() && method.getParameterCount() == arguments.length + 1) {
            arguments = Arrays.copyOf(arguments, arguments.length + 1);
            arguments[arguments.length - 1] = null;
        }
        if (method.isVarArgs() && method.getParameterCount() <= arguments.length) {
            types = method.getParameterTypes();
            Class<?> varargType = types[types.length - 1];
            Class<?> varargComponentType = varargType.getComponentType();
            boolean assignable = true;
            for (int i = types.length - 1; i < arguments.length; ++i) {
                Object argument = arguments[i];
                if (argument == null) continue;
                Class<?> argumentClass = argument.getClass();
                if (TypeFactory.wrapPrimitive(varargComponentType).isAssignableFrom(TypeFactory.wrapPrimitive(argumentClass))) continue;
                assignable = false;
                break;
            }
            if (assignable) {
                try {
                    Object varargArgument = Array.newInstance(varargComponentType, arguments.length - types.length + 1);
                    for (int i = types.length - 1; i < arguments.length; ++i) {
                        Array.set(varargArgument, i - types.length + 1, arguments[i]);
                    }
                    arguments = Arrays.copyOf(arguments, types.length);
                    arguments[types.length - 1] = varargArgument;
                }
                catch (Exception varargArgument) {
                    // empty catch block
                }
            }
        }
        types = method.getParameterTypes();
        if (arguments == null || types.length != arguments.length) {
            return arguments;
        }
        for (int i = 0; i < arguments.length; ++i) {
            Class<?> type = types[i];
            Object argument = arguments[i];
            if (argument == null || TypeFactory.wrapPrimitive(type).isAssignableFrom(TypeFactory.wrapPrimitive(argument.getClass()))) continue;
            if (type.isArray() && argument.getClass().isArray()) {
                Object newArgument = Array.newInstance(type.getComponentType(), Array.getLength(argument));
                try {
                    for (int j = 0; j < Array.getLength(argument); ++j) {
                        Array.set(newArgument, j, Array.get(argument, j));
                    }
                    arguments[i] = newArgument;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!Number.class.isAssignableFrom(type = TypeFactory.wrapPrimitive(type)) || !(argument instanceof Number)) continue;
            if (type == Integer.class) {
                argument = ((Number)argument).intValue();
            } else if (type == Short.class) {
                argument = ((Number)argument).shortValue();
            } else if (type == Long.class) {
                argument = ((Number)argument).longValue();
            } else if (type == Float.class) {
                argument = Float.valueOf(((Number)argument).floatValue());
            } else if (type == Double.class) {
                argument = ((Number)argument).doubleValue();
            } else if (type == Byte.class) {
                argument = ((Number)argument).byteValue();
            } else if (type == BigDecimal.class) {
                argument = BigDecimal.valueOf(((Number)argument).doubleValue());
            } else if (type == BigInteger.class) {
                argument = BigDecimal.valueOf(((Number)argument).longValue());
            }
            arguments[i] = argument;
        }
        return arguments;
    }

    public static <T extends Annotation> T getAnnotationOnMethod(Method method, Class<T> annotationClass) {
        T annotation = method.getDeclaredAnnotation(annotationClass);
        if (annotation == null) {
            annotation = ClassUtils.doGetAnnotationOnMethod(method.getDeclaringClass(), method.getName(), method.getParameterTypes(), annotationClass);
        }
        return annotation;
    }

    public static <T extends Annotation> T doGetAnnotationOnMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Class<T> annotationClass) {
        Class<?> superclass;
        Method method = null;
        T annotation = null;
        try {
            method = clazz.getDeclaredMethod(methodName, parameterTypes);
            annotation = method.getDeclaredAnnotation(annotationClass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (annotation == null && (superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
            annotation = ClassUtils.doGetAnnotationOnMethod(superclass, methodName, parameterTypes, annotationClass);
        }
        if (annotation == null) {
            for (Class<?> i : clazz.getInterfaces()) {
                annotation = ClassUtils.doGetAnnotationOnMethod(i, methodName, parameterTypes, annotationClass);
            }
        }
        return annotation;
    }

    public static Method getStaticMethod(Class<?> clazz, String methodName, Class<?>[] parameters) {
        try {
            return clazz.getMethod(methodName, parameters);
        }
        catch (NoSuchMethodException exception) {
            Method method;
            if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class && (method = ClassUtils.getStaticMethod(clazz.getSuperclass(), methodName, parameters)) != null) {
                return method;
            }
            for (Class<?> i : clazz.getInterfaces()) {
                Method method2 = ClassUtils.getStaticMethod(i, methodName, parameters);
                if (method2 == null) continue;
                return method2;
            }
            return null;
        }
    }
}

