/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.utils;

import com.streamscape.Version;
import com.streamscape.lib.utils.JVM;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class Banner {
    public static void printStreamscapeBanner(PrintStream out) {
        out.println("\n    Service Event Fabric Runtime");
        out.println("    Release " + Version.getVersion() + (Version.isTrial() ? " (Eval)" : ""));
        out.println("    Copyright (c) 2015-2025 StreamScape Technologies");
        out.println("    All rights reserved.\n");
    }

    public static void printJvmBanner(PrintStream out) {
        JVM jvm = new JVM();
        out.print("    Runtime-" + com.streamscape.runtime.Version.getVersion());
        out.print(", SEF-" + com.streamscape.sef.Version.getVersion());
        out.print(", SDO-" + com.streamscape.sdo.Version.getVersion());
        out.print(", OMF-" + com.streamscape.omf.Version.getVersion() + "\n");
        out.print("    OSF-" + com.streamscape.service.osf.Version.getVersion());
        out.print(", CLI-" + com.streamscape.cli.Version.getVersion());
        out.print(", Utils-" + com.streamscape.lib.Version.getVersion());
        out.print(", Repo-" + com.streamscape.repository.Version.getVersion() + "\n");
        out.print("    DS-" + com.streamscape.ds.Version.getVersion());
        out.print(", HTTP-" + com.streamscape.sef.network.http.server.Version.getVersion());
        out.print(", XMPP-" + com.streamscape.sef.network.xmpp.server.Version.getVersion());
        out.print(", Lucene-" + String.valueOf(org.apache.lucene.util.Version.LATEST) + "\n\n");
        out.println("    Local host: " + JVM.getPrimaryHostName(true) + " " + JVM.getOSVersion() + "\n");
        out.println("    " + JVM.getJVMInfo());
        out.println("    " + JVM.getJVMName());
        out.println("    " + JVM.getJVMNVendorHome() + "\n");
    }

    public static void printBanner(PrintStream out) {
        Banner.printStreamscapeBanner(out);
        Banner.printJvmBanner(out);
    }

    public static String getStreamscapeBanner() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Banner.printStreamscapeBanner(new PrintStream(outputStream, true));
        return outputStream.toString();
    }

    public static String getJvmBanner() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Banner.printJvmBanner(new PrintStream(outputStream, true));
        return outputStream.toString();
    }

    public static String getBanner() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Banner.printBanner(new PrintStream(outputStream, true));
        return outputStream.toString();
    }

    public static void main(String[] args) {
        Banner.printBanner(System.out);
    }
}

