/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.txfs.utils;

import com.streamscape.lib.txfs.utils.RAFOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class RAFBufferedOutputStream
extends OutputStream {
    private BufferedOutputStream buffer;
    private RAFOutputStream rafOutputStream;

    public RAFBufferedOutputStream(RandomAccessFile raf, int bufferSize) {
        this.rafOutputStream = new RAFOutputStream(raf);
        this.buffer = new BufferedOutputStream(this.rafOutputStream, bufferSize);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.buffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }
}

