/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.txfs.utils;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.lib.utils.FileIOUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileLog
implements Logger {
    public static final SimpleDateFormat FORMATTER = new SimpleDateFormat("[yy/MM/dd HH:mm:ss.SSS] ");
    protected File logFile;
    protected BufferedOutputStream logStream;
    private boolean closed;
    protected final String logDir;

    public FileLog(String logDirectory) {
        this.logDir = logDirectory;
        this.logFile = new File(this.logDir + "/tx.log");
        FileOutputStream fileOutputStream = null;
        try {
            this.logFile.getParentFile().mkdirs();
            this.logFile.createNewFile();
            fileOutputStream = new FileOutputStream(this.logFile, true);
        }
        catch (Exception e) {
            Trace.logException(this, e, true);
            throw new RuntimeException(e);
        }
        this.logStream = new BufferedOutputStream(fileOutputStream);
    }

    @Override
    public void logDebug(String msg) {
        this.logInfo(msg);
    }

    @Override
    public void logInfo(String action) {
        if (this.isClosed()) {
            try {
                this.logStream = new BufferedOutputStream(new FileOutputStream(this.logFile, true));
                this.closed = false;
            }
            catch (FileNotFoundException e) {
                Trace.logException(this, e, false);
            }
        }
        try {
            this.logStream.write((FORMATTER.format(new Date()) + action + "\n").getBytes());
            this.logStream.flush();
        }
        catch (IOException e) {
            Trace.logException(this, e, false);
        }
    }

    @Override
    public void logError(String msg) {
        this.logInfo(msg);
    }

    public void close(boolean toDeleteLog) {
        try {
            this.logStream.flush();
            this.logStream.close();
        }
        catch (IOException e) {
            Trace.logException(this, e, false);
        }
        finally {
            this.closed = true;
        }
        if (toDeleteLog) {
            this.delete();
        }
    }

    protected void delete() {
        boolean result = this.logFile.delete();
        if (!result) {
            throw new RuntimeException(new IOException("Cannot delete log file: " + this.logFile.getPath()));
        }
        result = FileIOUtils.deleteFileDir(this.logFile.getParentFile());
        if (!result) {
            throw new RuntimeException(new IOException("Cannot delete log directroy: " + this.logFile.getPath()));
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public File getLogFile() {
        return this.logFile;
    }
}

