/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.txfs.mf.admin;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.lib.txfs.FileTransaction;
import com.streamscape.lib.txfs.IsolationLevel;
import com.streamscape.lib.txfs.exceptions.NoSuchTransaction;
import com.streamscape.lib.txfs.exceptions.ResourceException;
import com.streamscape.lib.txfs.utils.FileLog;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FileResourceManagerFactory {
    private static final Map<String, FileTransaction> transactionMap = new HashMap<String, FileTransaction>();
    private static String workDirectory = (String)DataspaceStoreManager.getRuntimeContext().getEnvironment().get("streamscape.runtime.startup.dir") + File.separator + ".txfs";

    public static void setWorkDirectory(String workDirectory) {
        FileResourceManagerFactory.workDirectory = workDirectory;
    }

    public static FileTransaction createTransaction(String name) {
        FileTransaction tx = new FileTransaction(workDirectory);
        tx.begin(name);
        transactionMap.put(tx.getGuid(), tx);
        return tx;
    }

    public static FileTransaction createTransaction(String name, boolean isSuspendable) {
        FileTransaction tx = new FileTransaction(workDirectory, isSuspendable);
        tx.begin(name);
        transactionMap.put(tx.getGuid(), tx);
        return tx;
    }

    public static FileTransaction createTransaction(String name, long recoveryPeriod, int numberOfRetries) {
        FileTransaction tx = new FileTransaction(workDirectory, recoveryPeriod, numberOfRetries);
        tx.begin(name);
        transactionMap.put(tx.getGuid(), tx);
        return tx;
    }

    public static FileResource acquireResource(File file, IsolationLevel isolationLevel) {
        return new FileResource(file, isolationLevel);
    }

    public static void releaseResource(FileResource fileResource) {
        fileResource.release();
    }

    public static FileLog getTransactionLog(String txId) {
        FileTransaction tx = FileResourceManagerFactory.getTransaction(txId);
        if (tx != null) {
            Logger logger = tx.getLog();
            return logger instanceof FileLog ? (FileLog)logger : null;
        }
        return null;
    }

    public static void commit(String txId) {
        FileResourceManagerFactory.getTransaction(txId).commit();
    }

    public static void recover(String txId) {
        FileResourceManagerFactory.getTransaction(txId).recover();
    }

    public static void rollback(String txId) {
        FileResourceManagerFactory.getTransaction(txId).rollback();
    }

    public static void abort(String txId) {
        FileResourceManagerFactory.getTransaction(txId).abort(true);
    }

    public static Collection<FileTransaction> listTransactions() {
        return transactionMap.values();
    }

    public static FileTransaction getTransaction(String txId) {
        FileTransaction tx = transactionMap.get(txId);
        if (tx == null) {
            throw new NoSuchTransaction(txId);
        }
        return tx;
    }

    public static void cleanUpCache() {
        for (Map.Entry<String, FileTransaction> entry : transactionMap.entrySet()) {
            switch (entry.getValue().getState()) {
                case COMMITED: 
                case ROLLED_BACK: 
                case CANCELED: {
                    transactionMap.remove(entry.getKey());
                    break;
                }
            }
        }
    }

    public static class FileResource {
        private File originalFile;
        private IsolationLevel isolationLevel;
        private RandomAccessFile randomAccessFile;
        private FileLock fileLock;
        private File acquiredFile;

        public FileResource(File file, IsolationLevel isolationLevel) {
            this.originalFile = file;
            this.isolationLevel = isolationLevel;
            try {
                switch (isolationLevel) {
                    case EXCLUSIVE: {
                        this.acquiredFile = File.createTempFile(file.getName(), ".xlock", file.getParentFile());
                        this.acquiredFile.delete();
                        if (!file.renameTo(this.acquiredFile)) {
                            throw new IOException("Cannot exclusively acquire file: failed to rename from original to temporary");
                        }
                        this.randomAccessFile = new RandomAccessFile(this.acquiredFile, "rw");
                        this.fileLock = this.randomAccessFile.getChannel().tryLock();
                        break;
                    }
                    case READ_WRITE: {
                        this.acquiredFile = this.originalFile;
                        this.randomAccessFile = new RandomAccessFile(this.originalFile, "rw");
                        this.fileLock = this.randomAccessFile.getChannel().tryLock();
                        break;
                    }
                    case READ_ONLY: {
                        this.acquiredFile = this.originalFile;
                        this.randomAccessFile = new RandomAccessFile(this.originalFile, "r");
                    }
                }
            }
            catch (IOException e) {
                Trace.logException(this, e, true);
                throw new ResourceException("Cannot acquire resource: " + file.getAbsolutePath(), e);
            }
        }

        public void release() {
            try {
                switch (this.isolationLevel) {
                    case EXCLUSIVE: {
                        this.randomAccessFile.close();
                        if (this.acquiredFile.renameTo(this.originalFile)) break;
                        throw new IOException("Cannot exclusively acquire file: failed to rename from temporary to original");
                    }
                    case READ_WRITE: 
                    case READ_ONLY: {
                        this.randomAccessFile.close();
                    }
                }
            }
            catch (IOException e) {
                Trace.logException(this, e, true);
                throw new ResourceException("Cannot release resource: " + this.originalFile.getAbsolutePath(), e);
            }
        }

        public File getFile() {
            return this.acquiredFile;
        }

        public RandomAccessFile getRandomAccessFile() {
            try {
                if (!this.randomAccessFile.getFD().valid()) {
                    this.randomAccessFile.close();
                    this.randomAccessFile = new RandomAccessFile(this.acquiredFile, this.isolationLevel == IsolationLevel.READ_ONLY ? "r" : "rw");
                    this.fileLock = this.randomAccessFile.getChannel().tryLock();
                }
            }
            catch (IOException e) {
                Trace.logException(this, e, true);
                throw new RuntimeException(e);
            }
            return this.randomAccessFile;
        }
    }
}

