/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.txfs.actions;

import com.streamscape.Trace;
import com.streamscape.lib.txfs.actions.AbstractFileAction;
import com.streamscape.lib.txfs.actions.FileAction;
import com.streamscape.lib.txfs.actions.FileAllocationMap;
import com.streamscape.lib.txfs.exceptions.ResourceException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class TwoFilesAction
extends AbstractFileAction
implements FileAction {
    protected File dstFile;
    protected RandomAccessFile dstFileRaf;
    protected File dstFileBackup;
    protected RandomAccessFile dstFileBackupRaf;
    protected boolean overwrite;

    public TwoFilesAction(String guid, String workDir, String filePath) {
        super(guid, workDir, filePath);
    }

    protected TwoFilesAction(String guid) {
        super(guid);
    }

    protected void checkOverwrite() {
        if (!this.overwrite && this.dstFile.exists()) {
            this.releaseLocks();
            throw new ResourceException("Cannot overwrite existent file '" + this.dstFile.getPath() + "' because overwrite is disabled.");
        }
    }

    @Override
    public void cleanUp() {
        boolean isDeleted;
        super.cleanUp();
        this.releaseLocks();
        if (this.dstFileBackup != null && !(isDeleted = this.dstFileBackup.delete())) {
            Trace.logError(this, "Cannot delete backup of destination file: " + this.dstFileBackup.getPath());
        }
    }

    @Override
    protected void releaseLocks() {
        super.releaseLocks();
        try {
            if (this.dstFileRaf != null) {
                FileAllocationMap.closeFile(this.guid, this.dstFile.getPath(), this.dstFileRaf);
            }
            if (this.dstFileBackupRaf != null) {
                FileAllocationMap.closeFile(this.guid, this.dstFileBackup.getPath(), this.dstFileBackupRaf);
            }
        }
        catch (IOException e) {
            Trace.logError(this, e.getMessage());
            throw new ResourceException("Cannot release locks for the file");
        }
    }

    @Override
    protected void releaseAndThrow(RuntimeException exc) {
        this.releaseLocks();
        throw exc;
    }
}

