/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.txfs.actions;

import com.streamscape.Trace;
import com.streamscape.lib.txfs.actions.FileAction;
import com.streamscape.lib.txfs.exceptions.ResourceException;
import java.io.File;

public class RenameFolderAction
implements FileAction {
    protected File srcFolder;
    protected File dstFolder;
    protected String guid;
    protected int id;
    protected boolean canceled;

    public RenameFolderAction(String guid, String folderPath, String newName) {
        this.srcFolder = new File(folderPath);
        if (!this.srcFolder.isDirectory()) {
            throw new ResourceException(String.valueOf(this.srcFolder) + " is not a folder");
        }
        this.dstFolder = new File(this.srcFolder.getParentFile(), newName);
        this.guid = guid;
    }

    @Override
    public void action() {
        if (!this.srcFolder.renameTo(this.dstFolder)) {
            throw new ResourceException("Folder " + String.valueOf(this.srcFolder) + " wasn't renamed.");
        }
    }

    @Override
    public void undo() {
        this.dstFolder.renameTo(this.srcFolder);
    }

    public String toString() {
        return "{id:" + this.getId() + ",action:rename,srcFolder:'" + this.srcFolder.getPath() + "'}";
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public boolean isPerformed() {
        return true;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void cancel() {
        Trace.logDebug(this, "Cancel action: " + this.getId());
        this.canceled = true;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void finish() {
    }
}

