/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.txfs.actions;

import com.streamscape.Trace;
import com.streamscape.lib.txfs.actions.FileAction;
import com.streamscape.lib.txfs.actions.FileAllocationMap;
import com.streamscape.lib.txfs.actions.MoveFileAction;
import com.streamscape.lib.txfs.exceptions.ResourceException;
import java.io.IOException;

public class RenameFileAction
extends MoveFileAction
implements FileAction {
    public RenameFileAction(String guid, String workDir, String srcFilePath, String dstFilePath) {
        this(guid, workDir, srcFilePath, dstFilePath, true);
    }

    public RenameFileAction(String guid, String workDir, String srcFilePath, String dstFilePath, boolean isOverwrite) {
        super(guid, workDir, srcFilePath, dstFilePath, isOverwrite);
        if (!this.file.getParent().equalsIgnoreCase(this.dstFile.getParent())) {
            this.releaseAndThrow(new ResourceException("The files are not in the same directory"));
        }
    }

    @Override
    public void finish() {
        if (!this.performed) {
            throw new IllegalStateException("Perform action() at first");
        }
        try {
            if (this.fileRaf != null) {
                FileAllocationMap.closeFile(this.guid, this.file.getPath(), this.fileRaf);
            }
            if (this.dstFileRaf != null) {
                FileAllocationMap.closeFile(this.guid, this.dstFile.getPath(), this.dstFileRaf);
            }
            if (!this.file.renameTo(this.dstFile)) {
                throw new IOException("Cannot rename file '" + this.file.getPath() + "' to '" + this.dstFile.getPath() + "'");
            }
        }
        catch (IOException e) {
            Trace.logError(this, "Cannot finish to rename files: " + this.file.getPath() + " to " + this.dstFile.getPath() + " :\n" + String.valueOf(e));
            this.releaseAndThrow(new ResourceException("Cannot finish to rename files: " + this.file.getPath() + " to " + this.dstFile.getPath(), e));
        }
    }

    @Override
    public String toString() {
        return "{id:" + this.getId() + ",action:rename,srcFile:'" + this.file.getPath() + "',dstFile:'" + this.dstFile.getPath() + "'}";
    }
}

