/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.txfs.actions;

import com.streamscape.Trace;
import com.streamscape.lib.txfs.actions.AbstractFileAction;
import com.streamscape.lib.txfs.actions.FileAllocationMap;
import com.streamscape.lib.txfs.exceptions.ResourceException;
import com.streamscape.lib.txfs.utils.RAFBufferedOutputStream;
import com.streamscape.lib.txfs.utils.RAFOutputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

public class OpenFileAction
extends AbstractFileAction {
    protected OutputStream backupFileOS;
    protected File dstFileBackup;
    protected RandomAccessFile dstFileBackupRaf;
    protected FileLock dstFileBackupLock;

    public OpenFileAction(String guid, String workDir, String filePath) {
        super(guid, workDir, filePath);
        try {
            this.backupFile = new File(this.file.getParentFile(), this.file.getName() + "." + guid + ".opened");
            this.performed = true;
            this.backupFileRaf = FileAllocationMap.getRandomAccessFile(guid, this.backupFile.getPath());
            if (!this.fileRaf.getFD().valid()) {
                this.fileRaf = FileAllocationMap.getRandomAccessFile(guid, this.file.getPath());
            }
            this.copy(this.file, this.backupFile, this.fileRaf, this.backupFileRaf);
        }
        catch (IOException e) {
            Trace.logError(this, e.getMessage());
            this.releaseAndThrow(new ResourceException("Cannot create backup for file: " + this.backupFile.getPath(), e));
        }
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public void action() {
        if (this.isCanceled()) {
            Trace.logDebug(this, "Create file action has been canceled: " + this.toString());
            return;
        }
        Trace.logDebug(this, "Start create file: " + this.file.getPath());
        this.checkFileState(this.file.getPath());
        try {
            if (this.dstFileBackup == null) {
                this.dstFileBackup = new File(this.file.getParentFile(), this.file.getName() + "." + this.guid + ".opened.backup");
                FileAllocationMap.closeFile(this.guid, this.file.getPath(), this.fileRaf);
                if (!this.file.renameTo(this.dstFileBackup)) {
                    this.dstFileBackup.delete();
                    this.dstFileBackup = null;
                    this.closeTempFile();
                    throw new ResourceException("Cannot delete already existent destination file before copying");
                }
                this.dstFileBackupRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.dstFileBackup.getPath());
                this.dstFileBackupLock = this.dstFileBackupRaf.getChannel().tryLock();
                this.fileRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.file.getPath());
            }
            this.copy(this.backupFile, this.file, this.backupFileRaf, this.fileRaf);
        }
        catch (IOException e) {
            Trace.logError(this, e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public void undo() {
        boolean isDeleted;
        this.closeTempFile();
        this.releaseLocks();
        this.releaseDstFile();
        if (this.dstFileBackup != null) {
            this.file.delete();
            if (!this.dstFileBackup.renameTo(this.file)) {
                throw new ResourceException("Cannot restore the initial file");
            }
        }
        if (this.backupFile != null && !(isDeleted = this.backupFile.delete())) {
            Trace.logError(this, "Cannot delete temp file: " + this.backupFile.getPath());
            throw new ResourceException("Cannot delete temp file: " + this.backupFile.getPath());
        }
    }

    @Override
    public void cleanUp() {
        boolean isDeleted;
        this.closeTempFile();
        this.releaseLocks();
        this.releaseDstFile();
        if (this.backupFile != null) {
            this.backupFile.delete();
            if (this.backupFile.exists()) {
                Trace.logError(this, "Cannot delete temp file: " + this.backupFile.getPath());
                throw new ResourceException("Cannot delete temp file: " + this.backupFile.getPath());
            }
        }
        if (this.dstFileBackup != null && !(isDeleted = this.dstFileBackup.delete())) {
            Trace.logError(this, "Cannot delete backup of destination file: " + this.dstFileBackup.getPath());
        }
    }

    private void releaseDstFile() {
        try {
            if (this.dstFileBackupRaf != null) {
                FileAllocationMap.closeFile(this.guid, this.dstFileBackup.getPath(), this.dstFileBackupRaf);
            }
        }
        catch (IOException e) {
            Trace.logError(this, e.getMessage());
            throw new ResourceException("Cannot release the backup of destination file: " + this.dstFileBackup.getPath());
        }
    }

    public InputStream getInputStream() {
        try {
            this.backupFileRaf.seek(0L);
        }
        catch (IOException e) {
            Trace.logError(this, e.getMessage());
            throw new RuntimeException(e);
        }
        return new BufferedInputStream(new InputStream(){

            @Override
            public int read() throws IOException {
                return OpenFileAction.this.backupFileRaf.read();
            }
        });
    }

    public OutputStream getOutputStream() {
        if (this.backupFileOS == null) {
            this.backupFileOS = new RAFOutputStream(this.backupFileRaf);
        }
        return this.backupFileOS;
    }

    public OutputStream getOutputStream(int bufferSize) {
        if (this.backupFileOS == null) {
            this.backupFileOS = new RAFBufferedOutputStream(this.backupFileRaf, bufferSize);
        }
        return this.backupFileOS;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.backupFileRaf;
    }

    private void closeTempFile() {
        try {
            if (this.backupFileOS != null) {
                this.backupFileOS.close();
            }
            if (this.backupFileRaf != null) {
                FileAllocationMap.closeFile(this.guid, this.backupFile.getPath(), this.backupFileRaf);
            }
        }
        catch (IOException e) {
            Trace.logError(this, e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "{id:" + this.getId() + ",action:open,srcFile:'" + this.file.getPath() + "'}";
    }
}

