/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.txfs.actions;

import com.streamscape.Trace;
import com.streamscape.lib.txfs.actions.FileAction;
import com.streamscape.lib.txfs.actions.FileAllocationMap;
import com.streamscape.lib.txfs.actions.TwoFilesAction;
import com.streamscape.lib.txfs.exceptions.ResourceException;
import java.io.File;
import java.io.IOException;

public class MoveFileAction
extends TwoFilesAction
implements FileAction {
    public MoveFileAction(String guid, String workDir, String srcFilePath, String dstFilePath) {
        this(guid, workDir, srcFilePath, dstFilePath, true);
    }

    public MoveFileAction(String guid, String workDir, String srcFilePath, String dstFilePath, boolean isOverwrite) {
        super(guid, workDir, srcFilePath);
        this.overwrite = isOverwrite;
        if (dstFilePath == null) {
            this.releaseAndThrow(new IllegalArgumentException("Destination file path cannot be null"));
        }
        this.dstFile = new File(dstFilePath);
        if (this.dstFile.exists() && this.dstFile.isDirectory()) {
            this.releaseAndThrow(new ResourceException("Destination file is a directory: " + this.dstFile.getPath()));
        }
        this.checkOverwrite();
        if (this.dstFile.exists()) {
            try {
                this.dstFileRaf = FileAllocationMap.getRandomAccessFile(guid, this.dstFile.getPath());
            }
            catch (IOException e) {
                Trace.logError(this, e.getMessage());
                this.releaseAndThrow(new ResourceException("Cannot get lock for destination file:" + this.dstFile.getPath()));
            }
        }
    }

    @Override
    public void action() {
        if (this.isCanceled()) {
            this.releaseLocks();
            Trace.logDebug(this, "Delete action has been canceled: " + this.toString());
            return;
        }
        Trace.logDebug(this, "Start rename '" + this.file.getPath() + "' to '" + this.dstFile.getPath() + "'");
        try {
            this.checkFileState(this.file.getPath());
            this.checkOverwrite();
            if (this.dstFile.exists()) {
                this.checkFileState(this.dstFile.getPath());
                this.dstFileBackup = new File(this.dstFile.getParentFile(), this.dstFile.getName() + "." + this.guid + ".moved.backup");
                this.dstFileBackup.delete();
                if (this.dstFileRaf != null) {
                    FileAllocationMap.closeFile(this.guid, this.dstFile.getPath(), this.dstFileRaf);
                }
                if (!this.dstFile.renameTo(this.dstFileBackup)) {
                    this.dstFileBackup.delete();
                    this.dstFileBackup = null;
                    this.releaseAndThrow(new ResourceException("Cannot delete destination file before copying"));
                } else {
                    this.dstFileBackupRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.dstFileBackup.getPath());
                }
                this.performed = true;
            } else if (this.dstFile.getParentFile() != null && !this.dstFile.getParentFile().exists()) {
                boolean isDirectoryCreated = this.dstFile.getParentFile().mkdirs();
                if (!isDirectoryCreated) {
                    throw new IOException("Cannot create the destination folder: " + this.dstFile.getParent());
                }
                this.performed = true;
            }
            this.performed = true;
            if (this.backupFile != null && this.backupFile.exists()) {
                this.cleanUp();
            }
            this.backupFile = new File(this.dstFile.getParentFile(), this.dstFile.getName() + "." + this.guid + ".moved");
            this.backupFileRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.backupFile.getPath());
            if (!this.fileRaf.getFD().valid()) {
                this.fileRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.file.getPath());
            }
            this.copy(this.file, this.backupFile, this.fileRaf, this.backupFileRaf);
        }
        catch (IOException e) {
            Trace.logError(this, "Cannot move files: " + this.file.getPath() + " to " + this.dstFile.getPath() + " :\n" + String.valueOf(e));
            this.releaseAndThrow(new ResourceException("Cannot move files: " + this.file.getPath() + " to " + this.dstFile.getPath(), e));
        }
        Trace.logDebug(this, "Finish action 'move' '" + this.file.getPath() + "' to '" + this.dstFile.getPath());
    }

    @Override
    public void finish() {
        if (!this.performed) {
            throw new IllegalStateException("Perform action() at first");
        }
        try {
            FileAllocationMap.closeFile(this.guid, this.backupFile.getPath(), this.backupFileRaf);
            if (!this.backupFile.renameTo(this.dstFile)) {
                throw new IOException("Cannot rename file '" + String.valueOf(this.backupFile) + "' to '" + String.valueOf(this.dstFile) + "'");
            }
            this.backupFileRaf = null;
            this.dstFileRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.dstFile.getPath());
            FileAllocationMap.closeFile(this.guid, this.file.getPath(), this.fileRaf);
            if (!this.file.delete()) {
                throw new ResourceException("Cannot delete file: " + this.file.getPath());
            }
        }
        catch (IOException e) {
            Trace.logError(this, "Cannot finish file move, source: '" + this.file.getPath() + "', target: '" + this.dstFile.getPath() + "' :\n" + String.valueOf(e));
            this.releaseAndThrow(new ResourceException("Cannot finish file move, source: '" + this.file.getPath() + "', target: '" + this.dstFile.getPath() + "'", e));
        }
    }

    @Override
    public void undo() {
        if (!this.performed) {
            this.releaseLocks();
            throw new IllegalStateException("Undo before action");
        }
        Trace.logDebug(this, "Start undo 'rename' '" + this.file.getPath() + "' to '" + this.dstFile.getPath() + "'");
        this.releaseLocks();
        if (this.dstFile != null && !this.file.exists() && !this.dstFile.renameTo(this.file)) {
            throw new ResourceException("Cannot rename destination file to source file: " + this.dstFileBackup.getPath());
        }
        if (this.dstFileBackup != null && !this.dstFileBackup.renameTo(this.dstFile)) {
            throw new ResourceException("Cannot rename backup to destination file: " + this.dstFileBackup.getPath());
        }
        if (this.backupFile != null && this.backupFileRaf != null && this.backupFile.exists()) {
            this.backupFile.delete();
            if (this.backupFile.exists()) {
                Trace.logError(this, "Cannot delete backup file: " + this.backupFile.getPath());
                throw new ResourceException("Cannot delete backup file: " + this.backupFile.getPath());
            }
        }
        this.performed = false;
        Trace.logDebug(this, "Finish undo 'rename' '" + this.file.getPath() + "' to '" + this.dstFile.getPath());
    }

    public String toString() {
        return "{id:" + this.getId() + ",action:move,srcFile:'" + this.file.getPath() + "',dstFile:'" + this.dstFile.getPath() + "'}";
    }
}

