/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.txfs.actions;

import com.streamscape.lib.txfs.exceptions.ResourceException;
import com.streamscape.lib.txfs.exceptions.TransactionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FileAllocationMap {
    private static final Map<String, Map<String, RandomAccessFile>> txToFileMap = Collections.synchronizedMap(new HashMap());
    private static final Map<String, String> filesToTx = Collections.synchronizedMap(new HashMap());

    public static RandomAccessFile getRandomAccessFile(String txId, String filePath) throws FileNotFoundException {
        RandomAccessFile raf;
        if (txId == null) {
            throw new IllegalArgumentException("Transaction id should be null");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("File is undefined");
        }
        String tx = filesToTx.get(filePath);
        if (tx == null) {
            filesToTx.put(filePath, txId);
        } else if (!tx.equals(txId)) {
            throw new ResourceException("File is locked by another transaction: " + filePath);
        }
        Map<String, RandomAccessFile> fileMap = txToFileMap.get(txId);
        if (fileMap == null) {
            fileMap = new HashMap<String, RandomAccessFile>();
            txToFileMap.put(txId, fileMap);
        }
        if ((raf = fileMap.get(filePath)) == null) {
            raf = new RandomAccessFile(filePath, "rw");
            fileMap.put(filePath, raf);
        }
        return raf;
    }

    public static void closeFile(String txId, String filePath, RandomAccessFile raf) throws IOException {
        if (txId == null) {
            throw new IllegalArgumentException("Transaction id should be null");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("File is undefined");
        }
        if (raf == null) {
            throw new IllegalArgumentException("RandomAccessFile is null");
        }
        String tx = filesToTx.get(filePath);
        if (tx == null) {
            return;
        }
        if (!tx.equals(txId)) {
            throw new ResourceException("File is locked by another transaction: " + filePath);
        }
        Map<String, RandomAccessFile> fileMap = txToFileMap.get(txId);
        if (fileMap == null) {
            throw new TransactionException("No such transaction: " + txId);
        }
        RandomAccessFile rafInMap = fileMap.get(filePath);
        if (rafInMap == null) {
            return;
        }
        if (!raf.equals(rafInMap)) {
            throw new IllegalArgumentException("Trying to close wrong file: the provided one does not belong to transaction");
        }
        raf.close();
        fileMap.remove(filePath);
        filesToTx.remove(filePath);
    }

    public static void cleanUp() throws IOException {
        for (Map<String, RandomAccessFile> fileMap : txToFileMap.values()) {
            for (RandomAccessFile raf : fileMap.values()) {
                raf.close();
            }
        }
        filesToTx.clear();
        txToFileMap.clear();
    }
}

