/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.txfs.actions;

import com.streamscape.Trace;
import com.streamscape.lib.txfs.actions.AbstractFileAction;
import com.streamscape.lib.txfs.actions.FileAction;
import com.streamscape.lib.txfs.actions.FileAllocationMap;
import com.streamscape.lib.txfs.exceptions.ResourceException;
import com.streamscape.lib.txfs.exceptions.TransactionException;
import java.io.File;
import java.io.IOException;

public class DeleteFileAction
extends AbstractFileAction
implements FileAction {
    public DeleteFileAction(String guid, String workDir, String filePath) {
        super(guid, workDir, filePath);
    }

    @Override
    public void action() {
        if (this.isCanceled()) {
            Trace.logDebug(this, "Delete action has been canceled: " + this.toString());
            return;
        }
        Trace.logDebug(this, "Start action 'delete' " + this.file.getPath());
        this.checkFileState(this.file.getPath());
        Trace.logDebug(this, "Start creating backup for " + String.valueOf(this.file));
        try {
            if (!this.fileRaf.getFD().valid()) {
                this.fileRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.file.getPath());
            }
            if (this.backupFile != null && this.backupFile.exists()) {
                this.cleanUp();
            }
            this.backupFile = new File(this.file.getParentFile(), this.file.getName() + "." + this.guid + ".deleted");
            FileAllocationMap.closeFile(this.guid, this.file.getPath(), this.fileRaf);
            boolean isRenamed = this.file.renameTo(this.backupFile);
            if (!isRenamed) {
                throw new IOException("Cannot rename resource to backup: from '" + this.file.getAbsolutePath() + "' to '" + this.backupFile.getAbsolutePath() + "'");
            }
            this.performed = true;
            this.backupFileRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.backupFile.getPath());
            Trace.logDebug(this, "The backup is created for '" + this.file.getPath() + "' as '" + this.backupFile.getPath() + "'");
        }
        catch (IOException e) {
            Trace.logError(this, "Exception while creating backup for " + this.file.getPath());
            this.releaseLocks();
            throw new ResourceException("Cannot create backup file", e);
        }
        Trace.logDebug(this, "Finish action 'delete' " + this.file.getPath());
    }

    @Override
    public void undo() {
        if (!this.performed) {
            this.releaseLocks();
            throw new IllegalStateException("Undo before action");
        }
        Trace.logDebug(this, "Start undo action 'delete' " + this.file.getPath());
        try {
            boolean isDeleted;
            this.checkFileState(this.backupFile.getPath());
            if (this.file.exists() && !(isDeleted = this.file.delete())) {
                throw new ResourceException("Cannot delete original resource to restore them from backup: " + this.file.getAbsolutePath());
            }
            FileAllocationMap.closeFile(this.guid, this.backupFile.getPath(), this.backupFileRaf);
            FileAllocationMap.closeFile(this.guid, this.file.getPath(), this.fileRaf);
            boolean isRenamed = this.backupFile.renameTo(this.file);
            if (!isRenamed) {
                throw new IOException("Cannot rename backup to original resource: from '" + this.backupFile.getAbsolutePath() + "' to '" + this.file.getAbsolutePath() + "'");
            }
        }
        catch (IOException e) {
            Trace.logError(this, "Cannot perform undo: " + this.file.getPath());
            throw new TransactionException("Cannot perform undo", e);
        }
        finally {
            this.releaseLocks();
        }
        this.performed = false;
        Trace.logDebug(this, "Finish undo action 'delete' " + this.file.getPath());
    }

    public String toString() {
        return "{id:" + this.getId() + ",action:delete,srcFile:'" + this.file.getPath() + "'}";
    }
}

