/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.txfs.actions;

import com.streamscape.Trace;
import com.streamscape.lib.txfs.actions.AbstractFileAction;
import com.streamscape.lib.txfs.actions.FileAllocationMap;
import com.streamscape.lib.txfs.exceptions.ResourceException;
import com.streamscape.lib.txfs.utils.RAFOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

public class CreateFileAction
extends AbstractFileAction {
    protected File tempFile;
    protected RandomAccessFile tempFileRaf;
    protected OutputStream tempFileOS;
    protected File dstFileBackup;
    protected RandomAccessFile dstFileBackupRaf;
    protected FileLock dstFileBackupLock;
    protected boolean overwrite;
    private boolean dstFileBackupCreated;

    public CreateFileAction(String guid, String workDirectory, String filePath) {
        this(guid, workDirectory, filePath, true);
    }

    public CreateFileAction(String guid, String workDirectory, String filePath, boolean overwrite) {
        super(guid);
        this.canceled = false;
        this.overwrite = overwrite;
        if (workDirectory == null) {
            throw new IllegalArgumentException("Working directory is null");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Path to source file is null");
        }
        this.checkFileState(filePath);
        this.file = new File(filePath);
        File upWorkDir = new File(workDirectory);
        if (!upWorkDir.isDirectory()) {
            throw new IllegalArgumentException("Working directory should be a directory");
        }
        this.workDir = workDirectory;
        this.logDirectory = new File(this.workDir);
        boolean dirsCreated = this.logDirectory.mkdirs();
        if (!dirsCreated && !this.logDirectory.isDirectory()) {
            throw new IllegalArgumentException("Working directory should be a directory");
        }
        this.performed = false;
        try {
            this.tempFile = new File(this.logDirectory, this.file.getName() + "." + guid + ".created");
            this.performed = true;
            this.tempFileRaf = FileAllocationMap.getRandomAccessFile(guid, this.tempFile.getPath());
        }
        catch (IOException e) {
            Trace.logError(this, e.getMessage());
            throw new ResourceException("Cannot create backup file");
        }
        this.checkOverwrite();
        this.dstFileBackupCreated = false;
    }

    private void checkOverwrite() {
        if (!this.overwrite && this.file.exists()) {
            this.flushTempFile();
            this.releaseDstFile();
            throw new ResourceException("Cannot overwrite existent file '" + this.file.getPath() + "' because overwrite is disabled.");
        }
    }

    @Override
    public void action() {
        if (this.isCanceled()) {
            Trace.logDebug(this, "Create file action has been canceled: " + this.toString());
            return;
        }
        Trace.logDebug(this, "Start create file: " + this.file.getPath());
        this.checkFileState(this.file.getPath());
        try {
            if (!this.file.exists()) {
                boolean dirsCreated;
                if (!this.file.getParentFile().exists() && !(dirsCreated = this.file.getParentFile().mkdirs())) {
                    throw new ResourceException("Cannot create parent directory for the file");
                }
                boolean isCreated = this.file.createNewFile();
                if (!isCreated) {
                    throw new ResourceException("Cannot create file: " + this.file.getPath());
                }
                this.fileRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.file.getPath());
                this.dstFileBackupCreated = true;
            } else if (!this.dstFileBackupCreated) {
                this.checkOverwrite();
                this.checkFileState(this.file.getPath());
                this.dstFileBackup = new File(this.file.getParentFile(), this.file.getName() + "." + this.guid + ".created.backup");
                if (!this.file.renameTo(this.dstFileBackup)) {
                    this.dstFileBackup.delete();
                    this.dstFileBackup = null;
                    this.flushTempFile();
                    throw new ResourceException("Cannot delete already existent destination file before copying");
                }
                this.dstFileBackupRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.dstFileBackup.getPath());
                this.dstFileBackupLock = this.dstFileBackupRaf.getChannel().tryLock();
                this.fileRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.file.getPath());
                this.dstFileBackupCreated = true;
            }
            if (!this.fileRaf.getFD().valid()) {
                this.fileRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.file.getPath());
            }
            this.copy(this.tempFile, this.file, this.tempFileRaf, this.fileRaf);
        }
        catch (IOException e) {
            Trace.logError(this, e.getLocalizedMessage());
            throw new ResourceException(e);
        }
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public void undo() {
        this.flushTempFile();
        if (this.file != null && this.file.exists()) {
            this.releaseLocks();
            boolean isDeleted = this.file.delete();
            if (!isDeleted) {
                throw new ResourceException("Cannot delete file: " + this.file.getPath());
            }
        }
        this.releaseDstFile();
        if (this.dstFileBackup != null && !this.dstFileBackup.renameTo(this.file)) {
            throw new ResourceException("Cannot rename backup to destination file: " + this.dstFileBackup.getPath());
        }
    }

    @Override
    public void cleanUp() {
        boolean isDeleted;
        this.flushTempFile();
        this.releaseLocks();
        this.releaseDstFile();
        if (this.tempFile != null && !(isDeleted = this.tempFile.delete())) {
            Trace.logError(this, "Cannot delete temp file: " + this.tempFile.getPath());
        }
        if (this.dstFileBackup != null && !(isDeleted = this.dstFileBackup.delete())) {
            Trace.logError(this, "Cannot delete backup of destination file: " + this.dstFileBackup.getPath());
        }
    }

    private void releaseDstFile() {
        try {
            if (this.dstFileBackupRaf != null) {
                FileAllocationMap.closeFile(this.guid, this.dstFileBackup.getPath(), this.dstFileBackupRaf);
            }
        }
        catch (IOException e) {
            Trace.logError(this, e.getMessage());
            throw new ResourceException("Cannot release the backup of destination file: " + this.dstFileBackup.getPath());
        }
    }

    private void flushTempFile() {
        try {
            if (this.tempFileRaf != null) {
                FileAllocationMap.closeFile(this.guid, this.tempFile.getPath(), this.tempFileRaf);
            }
        }
        catch (IOException e) {
            Trace.logError(this, e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public OutputStream getOutputStream() throws IllegalAccessException {
        if (this.tempFileOS == null) {
            RandomAccessFile raf = this.getRandomAccessFile();
            this.tempFileOS = new RAFOutputStream(raf);
        }
        return this.tempFileOS;
    }

    public RandomAccessFile getRandomAccessFile() throws IllegalAccessException {
        return this.tempFileRaf;
    }

    public String toString() {
        return "{id:" + this.getId() + ",action:create,file:'" + this.file.getPath() + "'}";
    }
}

