/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.txfs.actions;

import com.streamscape.Trace;
import com.streamscape.lib.txfs.actions.FileAction;
import com.streamscape.lib.txfs.actions.FileAllocationMap;
import com.streamscape.lib.txfs.actions.TwoFilesAction;
import com.streamscape.lib.txfs.exceptions.ResourceException;
import java.io.File;
import java.io.IOException;

public class CopyFileAction
extends TwoFilesAction
implements FileAction {
    public CopyFileAction(String guid, String workDir, String srcFilePath, String dstFilePath) {
        this(guid, workDir, srcFilePath, dstFilePath, true);
    }

    public CopyFileAction(String guid, String workDir, String srcFilePath, String dstFilePath, boolean isOverwrite) {
        super(guid, workDir, srcFilePath);
        this.overwrite = isOverwrite;
        if (dstFilePath == null) {
            this.releaseAndThrow(new IllegalArgumentException("File path is null"));
        }
        this.dstFile = new File(dstFilePath);
        if (this.dstFile.exists() && this.dstFile.isDirectory()) {
            this.releaseAndThrow(new ResourceException("Destination file is a directory: " + this.dstFile.getPath()));
        }
        this.checkOverwrite();
        if (this.dstFile.exists()) {
            try {
                this.dstFileRaf = FileAllocationMap.getRandomAccessFile(guid, this.dstFile.getPath());
            }
            catch (IOException e) {
                Trace.logError(this, e.getMessage());
                this.releaseAndThrow(new ResourceException("Cannot get lock for destination file:" + this.dstFile.getPath()));
            }
        }
    }

    @Override
    public void action() {
        if (this.isCanceled()) {
            this.releaseLocks();
            Trace.logDebug(this, "Copy action has been canceled: " + this.toString());
            return;
        }
        Trace.logDebug(this, "Start copy '" + this.file.getPath() + "' to '" + this.dstFile.getPath() + "'");
        try {
            this.checkFileState(this.file.getPath());
            this.checkOverwrite();
            if (this.dstFile.exists()) {
                this.checkFileState(this.dstFile.getPath());
                this.dstFileBackup = new File(this.dstFile.getParentFile(), this.dstFile.getName() + "." + this.guid + ".copied.backup");
                this.dstFileBackup.delete();
                FileAllocationMap.closeFile(this.guid, this.dstFile.getPath(), this.dstFileRaf);
                if (!this.dstFile.renameTo(this.dstFileBackup)) {
                    this.dstFileBackup.delete();
                    this.releaseAndThrow(new ResourceException("Cannot delete destination file before copying"));
                } else {
                    this.dstFileBackupRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.dstFileBackup.getPath());
                }
                this.performed = true;
            } else if (this.dstFile.getParentFile() != null && !this.dstFile.getParentFile().exists()) {
                boolean isDirectoryCreated = this.dstFile.getParentFile().mkdirs();
                if (!isDirectoryCreated) {
                    throw new IOException("Cannot create the destination folder: " + this.dstFile.getParent());
                }
                this.performed = true;
            }
            Trace.logDebug(this, "Start creating backup for " + this.file.getPath());
            try {
                if (this.backupFile != null && this.backupFile.exists()) {
                    this.cleanUp();
                }
                this.backupFile = new File(this.dstFile.getParentFile(), this.file.getName() + "." + this.guid + ".copied");
                this.backupFileRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.backupFile.getPath());
                if (!this.fileRaf.getFD().valid()) {
                    this.fileRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.file.getPath());
                }
                this.copy(this.file, this.backupFile, this.fileRaf, this.backupFileRaf);
                Trace.logDebug(this, "The backup is created for '" + this.file.getPath() + "' as '" + this.backupFile.getPath() + "'");
            }
            catch (IOException e) {
                Trace.logError(this, "Exception while creating backup for " + this.file.getPath());
                this.releaseAndThrow(new ResourceException("Cannot create backup file", e));
            }
            this.performed = true;
        }
        catch (IOException e) {
            Trace.logError(this, "Cannot copy files: " + this.file.getPath() + " to " + this.dstFile.getPath() + " :\n" + String.valueOf(e));
            this.releaseAndThrow(new ResourceException("Cannot copy files: " + this.file.getPath() + " to " + this.dstFile.getPath(), e));
        }
        Trace.logDebug(this, "Finish action 'copy' '" + this.file.getPath() + "' to '" + this.dstFile.getPath());
    }

    @Override
    public void finish() {
        if (!this.performed) {
            throw new IllegalStateException("Perform action() at first");
        }
        try {
            FileAllocationMap.closeFile(this.guid, this.backupFile.getPath(), this.backupFileRaf);
            if (this.dstFileRaf != null) {
                FileAllocationMap.closeFile(this.guid, this.dstFile.getPath(), this.dstFileRaf);
            }
            if (!this.backupFile.renameTo(this.dstFile)) {
                throw new IOException("Cannot rename file '" + String.valueOf(this.backupFile) + "' to '" + String.valueOf(this.dstFile) + "'");
            }
            this.dstFileRaf = FileAllocationMap.getRandomAccessFile(this.guid, this.dstFile.getPath());
        }
        catch (IOException e) {
            Trace.logError(this, "Cannot copy files: " + this.file.getPath() + " to " + this.dstFile.getPath() + " :\n" + String.valueOf(e));
            this.releaseAndThrow(new ResourceException("Cannot copy files: " + this.file.getPath() + " to " + this.dstFile.getPath(), e));
        }
    }

    @Override
    public void undo() {
        if (!this.performed) {
            this.releaseAndThrow(new IllegalStateException("Undo before action"));
        }
        Trace.logDebug(this, "Start undo 'copy' '" + this.file.getPath() + "' to '" + this.dstFile.getPath() + "'");
        this.releaseLocks();
        if (this.dstFile != null) {
            this.checkFileState(this.dstFile.getPath());
            this.dstFile.delete();
            if (this.dstFile.exists()) {
                Trace.logError(this, "Cannot delete backup file: " + this.dstFile.getPath());
                throw new ResourceException("Cannot delete backup file: " + this.dstFile.getPath());
            }
        }
        if (this.backupFile != null) {
            this.checkFileState(this.backupFile.getPath());
            boolean isDeleted = this.backupFile.delete();
            if (this.backupFile.exists()) {
                Trace.logError(this, "Cannot delete backup file: " + this.dstFile.getPath());
                throw new ResourceException("Cannot delete backup file: " + this.dstFile.getPath());
            }
        }
        if (this.dstFileBackup != null && !this.dstFileBackup.renameTo(this.dstFile)) {
            throw new ResourceException("Cannot rename backup to destination file: " + this.dstFileBackup.getPath());
        }
        this.performed = false;
        Trace.logDebug(this, "Finish undo 'copy' '" + this.file.getPath() + "' to '" + this.dstFile.getPath());
    }

    public String toString() {
        return "{id:" + this.getId() + ",action:copy,srcFile:'" + this.file.getPath() + "',dstFile:'" + this.dstFile.getPath() + "'}";
    }
}

