/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.txfs.actions;

import com.streamscape.Trace;
import com.streamscape.lib.txfs.actions.FileAction;
import com.streamscape.lib.txfs.actions.FileAllocationMap;
import com.streamscape.lib.txfs.exceptions.ResourceException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class AbstractFileAction
implements FileAction {
    protected int id;
    protected String guid;
    protected File file;
    protected RandomAccessFile fileRaf;
    protected File backupFile;
    protected RandomAccessFile backupFileRaf;
    protected String workDir;
    protected File logDirectory;
    protected boolean performed;
    protected boolean canceled = false;

    public AbstractFileAction(String guid, String workDir, String filePath) {
        this(guid);
        if (workDir == null) {
            throw new IllegalArgumentException("Working directory is null");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Path to source file is null");
        }
        this.checkFileState(filePath);
        this.workDir = workDir;
        this.logDirectory = new File(this.workDir);
        boolean dirsCreated = this.logDirectory.mkdirs();
        if (!dirsCreated && !this.logDirectory.isDirectory()) {
            throw new IllegalArgumentException("Working directory should be a directory");
        }
        this.file = new File(filePath);
        if (!this.file.exists()) {
            throw new IllegalArgumentException("File '" + String.valueOf(this.file) + "' doesn't exist");
        }
        try {
            this.fileRaf = FileAllocationMap.getRandomAccessFile(guid, this.file.getPath());
        }
        catch (IOException e) {
            Trace.logError(this, e.getMessage());
            this.releaseLocks();
            throw new ResourceException("Cannot lock file: " + this.file.getPath());
        }
        this.performed = false;
    }

    protected AbstractFileAction(String guid) {
        if (guid == null) {
            throw new IllegalArgumentException("GUID cannot be null");
        }
        this.guid = guid;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public void cleanUp() {
        this.releaseLocks();
        if (this.backupFile != null && this.backupFile.exists()) {
            this.backupFile.delete();
            if (this.backupFile.exists()) {
                Trace.logError(this, "Cannot delete backup file: " + this.backupFile.getPath());
            }
        }
    }

    @Override
    public boolean isPerformed() {
        return this.performed;
    }

    protected void copy(File file, File dstFile, RandomAccessFile sourceFile, RandomAccessFile destinationFile) throws IOException {
        int data;
        Trace.logDebug(this, "Start copying '" + file.getPath() + "' to '" + dstFile.getPath() + "'");
        if (!sourceFile.getFD().valid()) {
            throw new ResourceException("Source file is closed or invalid: " + String.valueOf(sourceFile));
        }
        if (!destinationFile.getFD().valid()) {
            throw new ResourceException("Destination file is closed or invalid: " + String.valueOf(sourceFile));
        }
        byte[] buffer = new byte[8096];
        sourceFile.seek(0L);
        destinationFile.seek(0L);
        while (!Thread.currentThread().isInterrupted() && (data = sourceFile.read(buffer)) != -1) {
            destinationFile.write(buffer, 0, data);
        }
        Trace.logDebug(this, "Finish copying '" + String.valueOf(sourceFile) + "' to '" + String.valueOf(destinationFile) + "'");
    }

    protected void checkFileState(String filePath) {
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void cancel() {
        Trace.logDebug(this, "Cancel action: " + this.getId());
        this.canceled = true;
        this.releaseLocks();
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    protected void releaseLocks() {
        try {
            if (this.fileRaf != null) {
                FileAllocationMap.closeFile(this.guid, this.file.getPath(), this.fileRaf);
            }
            if (this.backupFileRaf != null) {
                FileAllocationMap.closeFile(this.guid, this.backupFile.getPath(), this.backupFileRaf);
            }
        }
        catch (IOException e) {
            Trace.logError(this, e.getMessage());
            throw new ResourceException("Cannot release locks for the file");
        }
    }

    protected void releaseAndThrow(RuntimeException exc) {
        this.releaseLocks();
        throw exc;
    }

    @Override
    public void finish() {
    }
}

