/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.txfs;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.lib.txfs.FileTransactionStateAdvisoryListener;
import com.streamscape.lib.txfs.TransactionState;
import com.streamscape.lib.txfs.actions.CopyFileAction;
import com.streamscape.lib.txfs.actions.CreateFileAction;
import com.streamscape.lib.txfs.actions.DeleteFileAction;
import com.streamscape.lib.txfs.actions.FileAction;
import com.streamscape.lib.txfs.actions.MoveFileAction;
import com.streamscape.lib.txfs.actions.OpenFileAction;
import com.streamscape.lib.txfs.actions.RenameFileAction;
import com.streamscape.lib.txfs.actions.RenameFolderAction;
import com.streamscape.lib.txfs.exceptions.CommitException;
import com.streamscape.lib.txfs.exceptions.ResourceException;
import com.streamscape.lib.txfs.exceptions.RollbackException;
import com.streamscape.lib.txfs.exceptions.TransactionException;
import com.streamscape.lib.txfs.utils.FileLog;
import java.io.File;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class FileTransaction {
    private static final ScheduledExecutorService EXECUTOR_SERVICE = Executors.newScheduledThreadPool(4);
    private TransactionState state;
    private List<FileAction> actions;
    private String workDir;
    private List<FileAction> remainingActions;
    private List<FileAction> performedActions;
    private List<FileAction> remainingToFinishActions;
    private List<FileAction> finishedActions;
    private FileAction currentAction;
    private boolean suspendable;
    private boolean autoRecovery;
    private long recoveryPeriod;
    private int maxAttempts;
    private int attempt;
    private String guid;
    private Logger log;
    protected Future<Boolean> txfsExecution;
    private boolean canceled = false;
    private FileTransactionStateAdvisoryListener listener;
    private String name;
    private boolean autoDeleteLog = false;
    private String logDir;
    private Runnable afterCleanUpTrigger;
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public FileTransaction(String workDir) {
        this(workDir, false);
    }

    public FileTransaction(String workDir, boolean suspendable) {
        Trace.logDebug(this, suspendable ? "Creating suspendable transaction..." : "Creating transaction...");
        if (workDir == null) {
            throw new IllegalArgumentException("Working directory is null");
        }
        File logDirectory = new File(workDir);
        boolean dirsCreated = logDirectory.mkdirs();
        if (!dirsCreated && !logDirectory.isDirectory()) {
            throw new IllegalArgumentException("Working directory should be a directory");
        }
        this.suspendable = suspendable;
        this.workDir = logDirectory.getPath();
        this.state = TransactionState.NONE;
        this.actions = new ArrayList<FileAction>();
        Trace.logDebug(this, "Created transaction...");
    }

    public FileTransaction(String workDir, long recoveryPeriod, int maxAttempts) {
        this(workDir, true);
        Trace.logDebug(this, "Created a suspendable, auto-recoverable file transaction...");
        if (recoveryPeriod < 0L) {
            throw new IllegalArgumentException("Recovery period must be a positive number.");
        }
        if (maxAttempts < 0) {
            throw new IllegalArgumentException("Number of attempts must be greater than 0.");
        }
        this.autoRecovery = true;
        this.recoveryPeriod = recoveryPeriod;
        this.maxAttempts = maxAttempts;
        this.attempt = 0;
        Trace.logDebug(this, "Created transaction...");
    }

    public synchronized void begin() {
        this.begin(null);
    }

    public synchronized void begin(String txName) {
        this.name = txName;
        Trace.logDebug(this, "Beginning transaction...");
        if (this.state != TransactionState.NONE) {
            throw new IllegalStateException("Transaction is already started. Current transaction state is: " + this.state.toString());
        }
        this.guid = UUID.randomUUID().toString();
        this.logDir = this.workDir + "/tx_" + (String)(this.name != null ? this.name + "_" : "") + System.currentTimeMillis() + "_" + this.guid + ".log";
        this.log = new FileLog(this.logDir);
        this.log.logInfo("begin");
        this.setState(TransactionState.STARTED);
        Trace.logDebug(this, "Transaction " + this.guid + " started (began).");
    }

    public synchronized void delete(String filePath) {
        this.checkStarted();
        this.addAction(new DeleteFileAction(this.guid, this.getLogDir(), filePath));
        Trace.logDebug(this, "Transaction " + this.guid + ": delete resource: '" + filePath + "'...");
    }

    public synchronized void copy(String src, String dst) {
        this.copy(src, dst, true);
    }

    public synchronized void copy(String src, String dst, boolean isOverwrite) {
        this.checkStarted();
        this.addAction(new CopyFileAction(this.guid, this.getLogDir(), src, dst, isOverwrite));
        Trace.logDebug(this, "Transaction " + this.guid + ": copy resource from: '" + src + "' to: '" + dst + "'...");
    }

    public synchronized void moveFile(String srcFileName, String dstFileName) {
        this.moveFile(srcFileName, dstFileName, true);
    }

    public synchronized void renameFolder(String folderPath, String newName) {
        this.checkStarted();
        this.addAction(new RenameFolderAction(this.guid, folderPath, newName));
        Trace.logDebug(this, "Transaction " + this.guid + ": prepare resource rename '" + folderPath + "' to name '" + newName + "'...");
    }

    public synchronized void moveFolder(String srcFolderName, String dstPath) {
        this.checkStarted();
        File srcFile = new File(srcFolderName);
        Collection<File> files = FileUtils.listFiles(srcFile, null, true);
        for (File file : files) {
            String relPath = srcFile.toURI().relativize(file.toURI()).getPath();
            String dstFile = StringUtils.appendIfMissing((String)dstPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + srcFile.getName() + "/" + relPath;
            this.addAction(new MoveFileAction(this.guid, this.getLogDir(), file.getPath(), dstFile, true));
        }
        this.afterCleanUpTrigger = () -> {
            try {
                if (!srcFile.isDirectory()) {
                    throw new ResourceException(String.valueOf(srcFile) + " is not a folder");
                }
                if (!FileUtils.listFiles(srcFile, null, true).isEmpty()) {
                    throw new ResourceException("Folder " + String.valueOf(srcFile) + " contains files");
                }
                FileUtils.deleteDirectory(srcFile);
            }
            catch (Exception e) {
                throw new ResourceException("Cannot delete the folder", e);
            }
        };
        Trace.logDebug(this, "Transaction " + this.guid + ": prepare resource move from '" + srcFolderName + "' to '" + dstPath + "'...");
    }

    public synchronized void copyFolder(String srcFolderName, String dstPath) {
        this.checkStarted();
        File srcFile = new File(srcFolderName);
        Collection<File> files = FileUtils.listFiles(srcFile, null, true);
        for (File file : files) {
            String relPath = srcFile.toURI().relativize(file.toURI()).getPath();
            String dstFile = StringUtils.appendIfMissing((String)dstPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + srcFile.getName() + "/" + relPath;
            this.addAction(new CopyFileAction(this.guid, this.getLogDir(), file.getPath(), dstFile, true));
        }
        Trace.logDebug(this, "Transaction " + this.guid + ": prepare resource copy from '" + srcFolderName + "' to '" + dstPath + "'...");
    }

    public synchronized void moveFile(String srcFileName, String dstFileName, boolean isOverwrite) {
        this.checkStarted();
        this.addAction(new MoveFileAction(this.guid, this.getLogDir(), srcFileName, dstFileName, isOverwrite));
        Trace.logDebug(this, "Transaction " + this.guid + ": prepare resource move from '" + srcFileName + "' to '" + dstFileName + "'...");
    }

    public synchronized void rename(String srcFileName, String dstFileName) {
        this.rename(srcFileName, dstFileName, true);
    }

    public synchronized void rename(String srcFileName, String dstFileName, boolean isOverwrite) {
        this.checkStarted();
        this.addAction(new RenameFileAction(this.guid, this.getLogDir(), srcFileName, dstFileName, isOverwrite));
        Trace.logDebug(this, "Transaction " + this.guid + ": prepare resource rename from '" + srcFileName + "' to '" + dstFileName + "'...");
    }

    private CreateFileAction createFile(String fileName, boolean overwrite) {
        this.checkStarted();
        CreateFileAction createFileAction = new CreateFileAction(this.guid, this.getLogDir(), fileName, overwrite);
        this.addAction(createFileAction);
        Trace.logDebug(this, "Transaction " + this.guid + ": create resource '" + fileName + "'...");
        return createFileAction;
    }

    public synchronized OutputStream createFileStream(String fileName, boolean overwrite) {
        CreateFileAction createFileAction = this.createFile(fileName, overwrite);
        try {
            return createFileAction.getOutputStream();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void abort(boolean withCleanup) {
        if (this.txfsExecution != null) {
            this.txfsExecution.cancel(true);
        }
        if (withCleanup) {
            this.cleanUpTransaction();
        }
        this.setState(TransactionState.DIRTY);
    }

    public void cancel(boolean withCleanup) {
        this.setState(TransactionState.CANCELED);
        this.log.logInfo("Cancel file transaction. All remaining actions won't be performed.");
        Trace.logDebug(this, "Cancel file transaction. All remaining actions won't be performed.");
        this.canceled = true;
        if (this.remainingActions != null) {
            for (FileAction remainingAction : this.remainingActions) {
                remainingAction.cancel();
            }
        }
        if (withCleanup) {
            this.cleanUpTransaction();
        }
        boolean b = false;
        this.closeLog(false);
    }

    void closeLog(boolean toDelete) {
        if (this.log instanceof FileLog) {
            ((FileLog)this.log).close(toDelete);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public synchronized RandomAccessFile create(String fileName, boolean overwrite) {
        CreateFileAction createFileAction = this.createFile(fileName, overwrite);
        try {
            return createFileAction.getRandomAccessFile();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public synchronized RandomAccessFile open(String fileName) {
        this.checkStarted();
        OpenFileAction fileAction = new OpenFileAction(this.guid, this.getLogDir(), fileName);
        this.addAction(fileAction);
        return fileAction.getRandomAccessFile();
    }

    public synchronized OutputStream openStream(String fileName, int bufferSize) {
        this.checkStarted();
        OpenFileAction fileAction = new OpenFileAction(this.guid, this.getLogDir(), fileName);
        this.addAction(fileAction);
        return fileAction.getOutputStream(bufferSize);
    }

    public synchronized void checkpoint() {
        if (this.isCanceled()) {
            this.log.logInfo("Won't commit, the transaction has been canceled.");
            Trace.logDebug(this, "Won't commit, the transaction has been canceled.");
            this.closeLog(false);
            return;
        }
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Trace.logDebug(this, "Transaction " + FileTransaction.this.guid + " initiated commit.");
                FileTransaction.this.checkStarted();
                FileTransaction.this.log.logInfo("checkpoint");
                FileTransaction.this.setState(TransactionState.COMMITING);
                if (FileTransaction.this.remainingActions == null || FileTransaction.this.performedActions == null) {
                    FileTransaction.this.remainingActions = new ArrayList<FileAction>(FileTransaction.this.actions);
                    FileTransaction.this.performedActions = new ArrayList<FileAction>();
                }
                FileTransaction.this.innerCommit(FileTransaction.this.actions, FileTransaction.this.performedActions, FileTransaction.this.remainingActions, true);
                FileTransaction.this.setState(TransactionState.STARTED);
                FileTransaction.this.log.logInfo("end checkpoint");
                Trace.logDebug(this, "Transaction " + FileTransaction.this.guid + " committed.");
                return true;
            }
        };
        this.txfsExecution = EXECUTOR_SERVICE.schedule(callable, 0L, TimeUnit.MILLISECONDS);
    }

    public void checkpoint(boolean wait) {
        this.checkpoint();
        if (wait) {
            try {
                this.txfsExecution.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private synchronized void addAction(FileAction fileAction) {
        fileAction.setId(this.actions.size() + 1);
        this.actions.add(fileAction);
        if (this.remainingActions != null) {
            this.remainingActions.add(fileAction);
        }
        this.log.logInfo("prepare operation: " + String.valueOf(fileAction));
    }

    private void checkStarted() {
        if (this.state != TransactionState.STARTED) {
            Trace.logError(this, "Transaction " + this.guid + " is not in STARTED state. Current transaction state is " + String.valueOf((Object)this.state));
            throw new IllegalStateException("Transaction start failure. Current transaction state is: " + this.state.toString());
        }
    }

    public synchronized void commit() {
        if (this.isCanceled()) {
            this.log.logInfo("Won't commit, the transaction has been canceled.");
            Trace.logDebug(this, "Won't commit, the transaction has been canceled.");
            this.closeLog(false);
            return;
        }
        if (this.getState() == TransactionState.COMMITED) {
            return;
        }
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Trace.logDebug(this, "Transaction " + FileTransaction.this.guid + " initiated commit.");
                FileTransaction.this.checkStarted();
                FileTransaction.this.log.logInfo("commit");
                FileTransaction.this.setState(TransactionState.COMMITING);
                if (FileTransaction.this.remainingActions == null || FileTransaction.this.performedActions == null) {
                    FileTransaction.this.remainingActions = new ArrayList<FileAction>(FileTransaction.this.actions);
                    FileTransaction.this.performedActions = new ArrayList<FileAction>();
                }
                FileTransaction.this.innerCommit(FileTransaction.this.actions, FileTransaction.this.performedActions, FileTransaction.this.remainingActions, false);
                if (FileTransaction.this.finishedActions == null || FileTransaction.this.remainingToFinishActions == null) {
                    FileTransaction.this.remainingToFinishActions = new ArrayList<FileAction>(FileTransaction.this.performedActions);
                    FileTransaction.this.finishedActions = new ArrayList<FileAction>();
                }
                FileTransaction.this.innerFinish(FileTransaction.this.performedActions, FileTransaction.this.finishedActions, FileTransaction.this.remainingToFinishActions);
                FileTransaction.this.cleanUpTransaction();
                FileTransaction.this.setState(TransactionState.COMMITED);
                FileTransaction.this.log.logInfo("end");
                FileTransaction.this.closeLog(FileTransaction.this.autoDeleteLog);
                Trace.logDebug(this, "Transaction " + FileTransaction.this.guid + " committed.");
                return true;
            }
        };
        this.txfsExecution = EXECUTOR_SERVICE.submit(callable);
    }

    public synchronized void commit(boolean wait) {
        this.commit();
        Trace.logDebug(this, "Wait for commit finishes.");
        if (wait && this.txfsExecution != null) {
            try {
                this.txfsExecution.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof TransactionException) {
                    throw (TransactionException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }
        Trace.logDebug(this, "Commit finishes.");
    }

    public synchronized void recover() {
        this.log.logInfo("start recover");
        Trace.logDebug(this, "Transaction " + this.guid + " initiated recovery.");
        if (this.state != TransactionState.SUSPEND) {
            this.log.logInfo("cannot recover for " + String.valueOf((Object)TransactionState.SUSPEND) + " state");
            Trace.logError(this, "Transaction " + this.guid + " is not in suspend state.");
            throw new IllegalStateException("Transaction is not suspend. Current transaction state is: " + this.state.toString());
        }
        this.setState(TransactionState.RECOVERING);
        ArrayList<FileAction> toAction = new ArrayList<FileAction>(this.remainingActions);
        this.innerCommit(toAction, this.performedActions, this.remainingActions, false);
        if (this.finishedActions == null || this.remainingToFinishActions == null) {
            this.remainingToFinishActions = new ArrayList<FileAction>(this.performedActions);
            this.finishedActions = new ArrayList<FileAction>();
        }
        this.innerFinish(new ArrayList<FileAction>(this.remainingToFinishActions), this.finishedActions, this.remainingToFinishActions);
        this.cleanUpTransaction();
        this.setState(TransactionState.COMMITED);
        this.closeLog(false);
        Trace.logDebug(this, "Transaction " + this.guid + " recovered.");
    }

    public synchronized void rollback() {
        Trace.logDebug(this, "Transaction " + this.guid + " initiated rollback.");
        if (this.state != TransactionState.SUSPEND_ROLLBACK) {
            Collections.reverse(this.performedActions);
        }
        this.setState(TransactionState.ROLLING_BACK);
        ArrayList<FileAction> reverseActions = new ArrayList<FileAction>(this.performedActions);
        try {
            if (this.currentAction != null && this.currentAction.isPerformed()) {
                this.currentAction.undo();
                this.currentAction = null;
            }
            for (FileAction action : reverseActions) {
                action.undo();
                this.performedActions.remove(action);
            }
        }
        catch (Exception e) {
            this.setState(TransactionState.SUSPEND_ROLLBACK);
            if (this.autoRecovery) {
                this.scheduleRecovery(false);
                Trace.logError(this, "Transaction " + this.guid + ": exception during rollback: " + e.getLocalizedMessage() + ", auto-recovery initiated.");
                throw new RollbackException("Exception during rollback, auto-recovery initiated.", e);
            }
            Trace.logError(this, "Transaction " + this.guid + ": exception during rollback: " + e.getLocalizedMessage());
            throw new RollbackException("Exception occurred during rollback.", e);
        }
        this.setState(TransactionState.ROLLED_BACK);
        Trace.logDebug(this, "Transaction " + this.guid + " rolled back.");
        this.closeLog(false);
    }

    public synchronized void stop() {
        if (this.autoRecovery && (this.state == TransactionState.ROLLING_BACK || this.state == TransactionState.SUSPEND_ROLLBACK)) {
            this.setState(TransactionState.DIRTY);
            Trace.logError(this, "Transaction " + this.guid + " auto-recovery aborted as DIRTY. Manually recovery is required.");
        }
    }

    private void innerCommit(List<FileAction> actionsToPerform, List<FileAction> performedActionList, List<FileAction> remainingActionList, boolean isCheckpoint) {
        try {
            Iterator<FileAction> iterator = actionsToPerform.iterator();
            while (iterator.hasNext()) {
                FileAction action;
                this.currentAction = action = iterator.next();
                this.log.logInfo("begin action: " + action.getId());
                action.action();
                this.currentAction = null;
                if (!performedActionList.contains(action)) {
                    performedActionList.add(action);
                }
                if (!action.isRepeatable()) {
                    remainingActionList.remove(action);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
        }
        catch (Exception e) {
            this.log.logInfo("exception: " + e.getLocalizedMessage());
            if (this.suspendable) {
                this.setState(TransactionState.SUSPEND);
                if (this.autoRecovery) {
                    if (this.attempt < this.maxAttempts) {
                        Trace.logError(this, "Transaction " + this.guid + ": commit exception. Auto-recovery (roll forward) initiated.");
                        this.log.logInfo("schedule auto-recovery");
                        this.scheduleRecovery(true);
                        throw new CommitException("Exception on transaction commit. Auto-recovery (roll forward) initiated.", e);
                    }
                    Trace.logError(this, "Transaction " + this.guid + ": commit exception. Rollback initiated.");
                    this.scheduleRecovery(false);
                    throw new CommitException("Exception on transaction commit, rollback initiated.", e);
                }
            } else {
                this.setState(TransactionState.ONLY_ROLLBACK);
            }
            Trace.logError(this, "Transaction " + this.guid + ": commit exception: " + e.getLocalizedMessage() + ", Manually recovery required.");
            throw new CommitException("Exception on transaction commit, manual recovery required.", e);
        }
    }

    private void innerFinish(List<FileAction> actionsToPerform, List<FileAction> performedActionList, List<FileAction> remainingActionList) {
        try {
            Iterator<FileAction> iterator = actionsToPerform.iterator();
            while (iterator.hasNext()) {
                FileAction action;
                this.currentAction = action = iterator.next();
                this.log.logInfo("begin action: " + action.getId());
                action.finish();
                this.currentAction = null;
                performedActionList.add(action);
                remainingActionList.remove(action);
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
        }
        catch (Exception e) {
            this.log.logInfo("exception: " + e.getLocalizedMessage());
            if (this.suspendable) {
                this.setState(TransactionState.SUSPEND);
                if (this.autoRecovery) {
                    if (this.attempt < this.maxAttempts) {
                        Trace.logError(this, "Transaction " + this.guid + ": commit exception. Auto-recovery (roll forward) initiated.");
                        this.log.logInfo("schedule auto-recovery");
                        this.scheduleRecovery(true);
                        throw new CommitException("Exception on transaction commit. Auto-recovery (roll forward) initiated.", e);
                    }
                    Trace.logError(this, "Transaction " + this.guid + ": commit exception. Rollback initiated.");
                    this.scheduleRecovery(false);
                    throw new CommitException("Exception on transaction commit, rollback initiated.", e);
                }
            } else {
                this.setState(TransactionState.ONLY_ROLLBACK);
            }
            Trace.logError(this, "Transaction " + this.guid + ": commit exception: " + e.getLocalizedMessage() + ", Manually recovery required.");
            throw new CommitException("Exception on transaction commit, manual recovery required.", e);
        }
    }

    private void scheduleRecovery(final boolean toRecover) {
        if (this.state == TransactionState.DIRTY) {
            this.log.logInfo("cannot schedule recovery in " + String.valueOf((Object)TransactionState.DIRTY) + " state");
            return;
        }
        final FileTransaction pointer = this;
        executor.schedule(new Runnable(){

            @Override
            public void run() {
                if (pointer.state == TransactionState.DIRTY) {
                    FileTransaction.this.log.logInfo("cannot schedule recovery in " + String.valueOf((Object)TransactionState.DIRTY) + " state");
                    return;
                }
                if (toRecover) {
                    pointer.incAttempt();
                    pointer.recover();
                } else {
                    pointer.rollback();
                }
            }
        }, this.recoveryPeriod, TimeUnit.MILLISECONDS);
        Trace.logDebug(this, "Transaction " + this.guid + " initiated " + (toRecover ? "recovery." : "rollback."));
    }

    private synchronized void incAttempt() {
        ++this.attempt;
        this.log.logInfo("attempt " + this.attempt);
        Trace.logDebug(this, "Transaction " + this.guid + " recovery attempt " + this.attempt);
    }

    protected void cleanUpTransaction() {
        Trace.logDebug(this, "Transaction " + this.guid + " initiated clean-up.");
        this.log.logInfo("start cleanup");
        for (FileAction action : this.actions) {
            action.cleanUp();
            this.log.logInfo("cleaned up: " + action.getId());
        }
        this.log.logInfo("finish cleanup");
        if (this.afterCleanUpTrigger != null) {
            this.afterCleanUpTrigger.run();
        }
        Trace.logDebug(this, "Transaction " + this.guid + " purged.");
    }

    public synchronized TransactionState getState() {
        return this.state;
    }

    public String toString() {
        return "FileTransaction{ guid='" + this.guid + "', actions=" + String.valueOf(this.actions) + ", state=" + String.valueOf((Object)this.state) + ", workDir='" + this.workDir + "', leftActions=" + String.valueOf(this.remainingActions) + ", performedActions=" + String.valueOf(this.performedActions) + ", finishedActions=" + String.valueOf(this.finishedActions) + ", currentAction=" + String.valueOf(this.currentAction) + ", suspendable=" + this.suspendable + ", autoRecovery=" + this.autoRecovery + ", recoveryPeriod=" + this.recoveryPeriod + ", maxAttempts=" + this.maxAttempts + ", attempt=" + this.attempt + "}";
    }

    private void setState(TransactionState state) {
        this.state = state;
        this.log.logInfo("set transaction state: " + String.valueOf((Object)state));
        if (this.listener != null) {
            this.listener.onStateChange(state);
        }
    }

    public void setListener(FileTransactionStateAdvisoryListener listener) {
        this.listener = listener;
    }

    public FileTransactionStateAdvisoryListener getListener() {
        return this.listener;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public String getGuid() {
        return this.guid;
    }

    public boolean isSuspendable() {
        return this.suspendable;
    }

    public boolean isAutoRecovery() {
        return this.autoRecovery;
    }

    public boolean isDone() {
        return this.txfsExecution == null || this.txfsExecution.isDone();
    }

    public String getName() {
        return this.name;
    }

    public Boolean getResult() throws ExecutionException, InterruptedException {
        return this.txfsExecution != null ? this.txfsExecution.get() : null;
    }

    public void deleteLog() {
        this.closeLog(true);
    }

    public void setAutoDeleteLog(boolean isAutoDelete) {
        this.autoDeleteLog = isAutoDelete;
    }

    public String getLogDir() {
        return this.logDir;
    }
}

