/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.tlp.client;

import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.service.osf.clients.AbstractClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;

public class TLPClientConnection
extends AbstractClientConnection {
    private String host;
    private int port;
    private String user;
    private String password;
    private FabricConnection fabricConnection;

    protected TLPClientConnection() {
    }

    public FabricConnection getFabricConnection() {
        return this.fabricConnection;
    }

    @Override
    public void init(ClientFactory factory) throws ClientException {
        this.factory = factory;
        if (factory.getProperty("Name") == null) {
            this.setName(factory.getFactoryType() + "." + factory.getFactoryName());
        } else {
            this.setName(factory.getProperty("Name"));
        }
        this.user = factory.getDefaultUser();
        this.password = factory.getDefaultPassword();
        this.host = this.getUrlHost(factory.getUrl());
        this.port = this.getUrlPort(factory.getUrl());
    }

    @Override
    public int ping() throws ClientException {
        return 0;
    }

    @Override
    public void connect() throws ClientException {
        try {
            this.setState(ConnectionState.OPENING);
            this.fabricConnection = new FabricConnectionFactory(this.getUrl()).createConnection(this.user, this.password);
            this.fabricConnection.open();
            this.setState(ConnectionState.OPEN);
        }
        catch (Exception exception) {
            this.disconnect();
            throw new ClientException(1029, (Throwable)exception);
        }
    }

    @Override
    public void disconnect() throws ClientException {
        this.setState(ConnectionState.CLOSING);
        if (this.fabricConnection != null && this.fabricConnection.isOpened()) {
            try {
                this.fabricConnection.close();
            }
            catch (FabricConnectionException fabricConnectionException) {
                // empty catch block
            }
        }
        this.setState(ConnectionState.CLOSED);
    }

    @Override
    public void raiseException(Exception ex) {
        if (this.getExceptionEventListener() != null) {
            this.getExceptionEventListener().onEvent(new ClientException(1029, (Throwable)ex));
        }
    }

    @Override
    public String getUrl() {
        return "tlp://" + this.host + ":" + this.port;
    }
}

