/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.timer;

import com.streamscape.lib.timer.FabricTimer;
import com.streamscape.lib.timer.FabricTimerException;
import com.streamscape.lib.timer.FabricTimerState;
import com.streamscape.lib.timer.FabricTimerTask;
import com.streamscape.lib.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;

public class FabricTimerManager {
    private static FabricTimerManager instance = null;
    private Map<String, Pair<Timer, Map<String, FabricTimer>>> timerGroups = new HashMap<String, Pair<Timer, Map<String, FabricTimer>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FabricTimerManager getInstance() {
        if (instance != null) return instance;
        Class<FabricTimerManager> clazz = FabricTimerManager.class;
        synchronized (FabricTimerManager.class) {
            if (instance != null) return instance;
            instance = new FabricTimerManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized FabricTimer createTimer(String group, String name, FabricTimerTask task, long interval, int repeatCount) throws FabricTimerException {
        Pair<Timer, Map<String, FabricTimer>> timerGroup = this.getTimerGroup(group);
        if (((Map)timerGroup.second).containsKey(name)) {
            throw new FabricTimerException("Timer '" + name + "' already exists in group '" + group + "'.");
        }
        FabricTimer result = new FabricTimer(group, name, task, interval, repeatCount, this, (Timer)timerGroup.first);
        ((Map)timerGroup.second).put(name, result);
        return result;
    }

    synchronized Pair<Timer, Map<String, FabricTimer>> getTimerGroup(String group) {
        Pair<Timer, Map<String, FabricTimer>> result = this.timerGroups.get(group);
        if (result == null) {
            result = new Pair(new Timer("FSYS:Timers." + group), new HashMap());
            this.timerGroups.put(group, result);
        }
        return result;
    }

    public void dropTimer(String group, String name) {
        FabricTimer timer = this.doDropTimer(group, name);
        if (timer != null) {
            timer.doStop(FabricTimerState.STOPPED, true);
        }
    }

    synchronized FabricTimer doDropTimer(String group, String name) {
        FabricTimer result = null;
        Pair<Timer, Map<String, FabricTimer>> timerGroup = this.timerGroups.get(group);
        if (timerGroup != null) {
            result = (FabricTimer)((Map)timerGroup.second).remove(name);
            if (((Map)timerGroup.second).isEmpty()) {
                this.timerGroups.remove(group);
                ((Timer)timerGroup.first).cancel();
            }
        }
        return result;
    }

    public boolean existsTimerGroup(String group) {
        return this.timerGroups.containsKey(group);
    }

    public List<String> listTimerGroups() {
        return new ArrayList<String>(this.timerGroups.keySet());
    }

    public boolean existsTimer(String group, String name) {
        Pair<Timer, Map<String, FabricTimer>> timerGroup = this.timerGroups.get(group);
        return timerGroup != null && ((Map)timerGroup.second).containsKey(name);
    }

    public FabricTimer getTimer(String group, String name) {
        Pair<Timer, Map<String, FabricTimer>> timerGroup = this.timerGroups.get(group);
        return timerGroup != null ? (FabricTimer)((Map)timerGroup.second).get(name) : null;
    }

    public List<String> listTimers(String group) {
        ArrayList<String> result = new ArrayList<String>();
        Pair<Timer, Map<String, FabricTimer>> timerGroup = this.timerGroups.get(group);
        if (timerGroup != null) {
            result.addAll(((Map)timerGroup.second).keySet());
        }
        return result;
    }
}

