/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.timer;

import com.streamscape.lib.timer.FabricTimerException;
import com.streamscape.lib.timer.FabricTimerManager;
import com.streamscape.lib.timer.FabricTimerState;
import com.streamscape.lib.timer.FabricTimerTask;
import com.streamscape.sdo.AbstractNamedObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class FabricTimer
extends AbstractNamedObject {
    private String group;
    private FabricTimerTask task;
    private long interval;
    private int repeatCount;
    private Map<String, Object> values = new HashMap<String, Object>();
    private transient FabricTimerManager manager;
    private transient Timer underlyingTimer;
    private transient UnderlyingTask underlyingTask;
    private transient FabricTimerState state = FabricTimerState.CREATED;
    private transient long startTime = -1L;
    private transient long stopTime = -1L;
    private transient long nextExecutionTime = -1L;
    private transient int remainingRepeatCount;
    private transient long remainingInterval;

    FabricTimer(String group, String name, FabricTimerTask task, long interval, int repeatCount, FabricTimerManager manager, Timer underlyingTimer) throws FabricTimerException {
        super(name);
        if (interval <= 0L) {
            throw new FabricTimerException("Interval must be positive.");
        }
        this.group = group;
        this.task = task;
        this.interval = interval;
        this.repeatCount = repeatCount <= 0 ? -1 : repeatCount;
        this.manager = manager;
        this.underlyingTimer = underlyingTimer;
        this.remainingRepeatCount = this.repeatCount;
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public long getInterval() {
        return this.interval;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public FabricTimerState getState() {
        return this.state;
    }

    public void start() throws FabricTimerException {
        this.doStart(-1L);
    }

    public void start(Date startTime) throws FabricTimerException {
        this.doStart(startTime != null ? startTime.getTime() - System.currentTimeMillis() : 0L);
    }

    public void start(long delay) throws FabricTimerException {
        if (delay < 0L) {
            throw new FabricTimerException("Delay is negative.");
        }
        this.doStart(delay);
    }

    synchronized void doStart(long delay) throws FabricTimerException {
        this.checkState();
        if (this.state == FabricTimerState.CREATED || this.state == FabricTimerState.CANCELLED) {
            this.doStartWithoutCheck(delay);
            this.task.onStart(this);
        }
    }

    public void stop() {
        this.stopAndDrop(true);
    }

    private synchronized void stopAndDrop(boolean forced) {
        if (this.state != FabricTimerState.STOPPED) {
            this.doStop(FabricTimerState.STOPPED, forced);
            this.manager.doDropTimer(this.group, this.name);
        }
    }

    private synchronized void doStop(FabricTimerState newState) {
        this.cancelUnderlyingTask();
        this.state = newState;
        this.stopTime = System.currentTimeMillis();
    }

    synchronized void doStop(FabricTimerState newState, boolean forced) {
        this.doStop(FabricTimerState.STOPPED);
        this.task.onStop(this);
        if (!forced) {
            this.nextExecutionTime = -1L;
        }
    }

    public void cancel() throws FabricTimerException {
        this.checkState();
        if (this.state != FabricTimerState.CANCELLED) {
            if (this.remainingRepeatCount == 1) {
                this.doCancel();
            } else {
                this.doCancel();
                this.doStartWithoutCheck(-1L);
            }
        }
    }

    private void doCancel() {
        this.doStop(FabricTimerState.CANCELLED);
        this.decrementRemainingRepeatCount();
        this.task.onCancel(this);
    }

    public void reset() throws FabricTimerException {
        this.checkState();
        this.doStop(FabricTimerState.RESET);
        this.remainingRepeatCount = this.repeatCount;
        this.doStartWithoutCheck(-1L);
        this.task.onReset(this);
    }

    public void suspend() throws FabricTimerException {
        this.checkState();
        if (this.state == FabricTimerState.STARTED && this.state != FabricTimerState.SUSPENDED) {
            this.cancelUnderlyingTask();
            this.remainingInterval = this.getRemainingTime();
            this.nextExecutionTime = -1L;
            this.state = FabricTimerState.SUSPENDED;
            this.task.onSuspend(this);
        }
    }

    public void resume() throws FabricTimerException {
        this.checkState();
        if (this.state == FabricTimerState.SUSPENDED) {
            this.doStartWithoutCheck(this.remainingInterval);
            this.task.onResume(this);
        }
    }

    public synchronized long getRemainingTime() {
        if (this.state == FabricTimerState.SUSPENDED) {
            return this.remainingInterval;
        }
        return this.nextExecutionTime != -1L ? this.nextExecutionTime - (this.stopTime != -1L ? this.stopTime : System.currentTimeMillis()) : -1L;
    }

    public int getRemainingRepeatCount() {
        return this.remainingRepeatCount;
    }

    public synchronized long getDuration() {
        return this.startTime != -1L ? (this.stopTime != -1L ? this.stopTime : System.currentTimeMillis()) - this.startTime : -1L;
    }

    private void checkState() throws FabricTimerException {
        if (this.state == FabricTimerState.STOPPED) {
            throw new FabricTimerException("Timer is " + this.state.name().toLowerCase() + ".");
        }
    }

    synchronized void doStartWithoutCheck(long delay) throws FabricTimerException {
        if (delay < 0L) {
            delay = this.interval;
        }
        this.underlyingTask = new UnderlyingTask();
        try {
            this.underlyingTimer.schedule((TimerTask)this.underlyingTask, delay, this.interval);
        }
        catch (Exception exception) {
            throw new FabricTimerException("Scheduling of timer's task failed.", exception);
        }
        if (this.state == FabricTimerState.CANCELLED && this.remainingRepeatCount == 0) {
            this.remainingRepeatCount = this.repeatCount;
        }
        if (this.state != FabricTimerState.SUSPENDED) {
            this.startTime = System.currentTimeMillis();
            this.nextExecutionTime = this.startTime + delay;
        } else {
            this.nextExecutionTime = System.currentTimeMillis() + delay;
        }
        this.stopTime = -1L;
        this.state = FabricTimerState.STARTED;
    }

    private void cancelUnderlyingTask() {
        if (this.underlyingTask != null) {
            this.underlyingTask.cancel();
            this.underlyingTask = null;
        }
    }

    public synchronized void addValue(String key, Object value) {
        this.values.put(key, value);
    }

    public synchronized void removeValue(String key) {
        this.values.remove(key);
    }

    public synchronized void clearValues() {
        this.values.clear();
    }

    public synchronized Object existsValue(String key) {
        return this.values.containsKey(key);
    }

    public synchronized Object getValue(String key) {
        return this.values.get(key);
    }

    public synchronized List<Map.Entry<String, Object>> getValues() {
        return new ArrayList<Map.Entry<String, Object>>(this.values.entrySet());
    }

    private synchronized void decrementRemainingRepeatCount() {
        if (this.remainingRepeatCount > 0) {
            --this.remainingRepeatCount;
        }
    }

    private class UnderlyingTask
    extends TimerTask {
        private UnderlyingTask() {
        }

        @Override
        public void run() {
            FabricTimer.this.task.execute(FabricTimer.this);
            FabricTimer.this.decrementRemainingRepeatCount();
            FabricTimer.this.nextExecutionTime = System.currentTimeMillis() + FabricTimer.this.interval;
            if (FabricTimer.this.remainingRepeatCount == 0) {
                FabricTimer.this.stopAndDrop(false);
            }
        }
    }
}

