/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.selector.parser;

import com.streamscape.lib.selector.ArithmeticalSelectorExpression;
import com.streamscape.lib.selector.ComparisonSelectorExpression;
import com.streamscape.lib.selector.ConstantSelectorExpression;
import com.streamscape.lib.selector.LogicalSelectorExpression;
import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.lib.selector.SelectorExternalDataSource;
import com.streamscape.lib.selector.SelectorFormatException;
import com.streamscape.lib.selector.SelectorUtils;
import com.streamscape.lib.selector.UnarySelectorExpression;
import com.streamscape.lib.selector.VariableSelectorExpression;
import com.streamscape.lib.selector.parser.ParseException;
import com.streamscape.lib.selector.parser.SelectorParserConstants;
import com.streamscape.lib.selector.parser.SelectorParserTokenManager;
import com.streamscape.lib.selector.parser.SimpleCharStream;
import com.streamscape.lib.selector.parser.Token;
import com.streamscape.lib.selector.parser.TokenMgrError;
import com.streamscape.lib.utils.StringUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SelectorParser
implements SelectorParserConstants {
    private static final SelectorExternalDataSource DEFAULT_EXTERNAL_DATA_SOURCE = new SelectorExternalDataSource(){};
    private String expressionString;
    private SelectorExternalDataSource externalDataSource;
    public SelectorParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[22];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[12];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static SelectorExpression parse(String expression) throws SelectorFormatException {
        return !StringUtils.isEmpty(expression) ? new SelectorParser(expression, DEFAULT_EXTERNAL_DATA_SOURCE).parse() : null;
    }

    public static SelectorExpression parse(String expression, SelectorExternalDataSource externalDataSource) throws SelectorFormatException {
        return !StringUtils.isEmpty(expression) ? new SelectorParser(expression, externalDataSource).parse() : null;
    }

    private SelectorParser(String expressionString, SelectorExternalDataSource externalDataSource) {
        this(new StringReader(expressionString));
        this.expressionString = expressionString;
        this.externalDataSource = externalDataSource;
    }

    private SelectorExpression parse() throws SelectorFormatException {
        try {
            if (this.expressionString.isEmpty()) {
                throw new SelectorFormatException("Empty selector.");
            }
            SelectorExpression result = this.doParse();
            if (!this.token.next.image.isEmpty()) {
                throw new SelectorFormatException("Invalid token '" + String.valueOf(this.token.next) + "'.");
            }
            return result;
        }
        catch (Throwable exception2) {
            ParseException exception2;
            if (exception2 instanceof TokenMgrError) {
                ParseException parseException = new ParseException(exception2.getMessage());
                parseException.setStackTrace(exception2.getStackTrace());
                exception2 = parseException;
            }
            throw new SelectorFormatException("Parsing of selector '" + this.expressionString + "' failed.", exception2);
        }
    }

    private SelectorExpression convertToBoolean(SelectorExpression expression) throws ParseException {
        if (expression instanceof VariableSelectorExpression) {
            return UnarySelectorExpression.createExpression_ConversionToBoolean(expression);
        }
        return expression;
    }

    public final SelectorExpression doParse() throws ParseException {
        return this.convertToBoolean(this.or_expression());
    }

    public final SelectorExpression or_expression() throws ParseException {
        SelectorExpression leftOperand = this.and_expression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(13);
            SelectorExpression rightOperand = this.and_expression();
            leftOperand = LogicalSelectorExpression.createExpression_OR(this.convertToBoolean(leftOperand), this.convertToBoolean(rightOperand));
        }
        return leftOperand;
    }

    public final SelectorExpression and_expression() throws ParseException {
        SelectorExpression leftOperand = this.equality_expression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(12);
            SelectorExpression rightOperand = this.equality_expression();
            leftOperand = LogicalSelectorExpression.createExpression_AND(this.convertToBoolean(leftOperand), this.convertToBoolean(rightOperand));
        }
        return leftOperand;
    }

    public final SelectorExpression equality_expression() throws ParseException {
        SelectorExpression leftOperand;
        block11: {
            leftOperand = this.relational_expression();
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: {
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 36: {
                        this.jj_consume_token(36);
                        SelectorExpression rightOperand = this.relational_expression();
                        leftOperand = ComparisonSelectorExpression.createExpression_Equal(leftOperand, rightOperand);
                        continue block9;
                    }
                    case 37: {
                        this.jj_consume_token(37);
                        SelectorExpression rightOperand = this.relational_expression();
                        leftOperand = ComparisonSelectorExpression.createExpression_Equal(leftOperand, rightOperand);
                        continue block9;
                    }
                    case 38: {
                        this.jj_consume_token(38);
                        SelectorExpression rightOperand = this.relational_expression();
                        leftOperand = ComparisonSelectorExpression.createExpression_NotEqual(leftOperand, rightOperand);
                        continue block9;
                    }
                    case 39: {
                        this.jj_consume_token(39);
                        SelectorExpression rightOperand = this.relational_expression();
                        leftOperand = ComparisonSelectorExpression.createExpression_NotEqual(leftOperand, rightOperand);
                        continue block9;
                    }
                }
                this.jj_la1[3] = this.jj_gen;
                if (this.jj_2_1(2)) {
                    this.jj_consume_token(18);
                    this.jj_consume_token(8);
                    leftOperand = ComparisonSelectorExpression.createExpression_IsNull(leftOperand);
                    continue;
                }
                if (!this.jj_2_2(3)) break;
                this.jj_consume_token(18);
                this.jj_consume_token(11);
                this.jj_consume_token(8);
                leftOperand = ComparisonSelectorExpression.createExpression_IsNotNull(leftOperand);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return leftOperand;
    }

    public final SelectorExpression relational_expression() throws ParseException {
        SelectorExpression leftOperand;
        block39: {
            leftOperand = this.additive_expression();
            block28: while (true) {
                String likeLiteral;
                String escapeLiteral;
                HashSet<Object> objects;
                String literal;
                SelectorExpression maxBoundary;
                SelectorExpression minBoundary;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 19: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: {
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        break block39;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 40: {
                        this.jj_consume_token(40);
                        SelectorExpression rightOperand = this.additive_expression();
                        leftOperand = ComparisonSelectorExpression.createExpression_GreaterThan(leftOperand, rightOperand);
                        continue block28;
                    }
                    case 41: {
                        this.jj_consume_token(41);
                        SelectorExpression rightOperand = this.additive_expression();
                        leftOperand = ComparisonSelectorExpression.createExpression_GreaterThanEqual(leftOperand, rightOperand);
                        continue block28;
                    }
                    case 42: {
                        this.jj_consume_token(42);
                        SelectorExpression rightOperand = this.additive_expression();
                        leftOperand = ComparisonSelectorExpression.createExpression_LessThan(leftOperand, rightOperand);
                        continue block28;
                    }
                    case 43: {
                        this.jj_consume_token(43);
                        SelectorExpression rightOperand = this.additive_expression();
                        leftOperand = ComparisonSelectorExpression.createExpression_LessThanEqual(leftOperand, rightOperand);
                        continue block28;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        minBoundary = this.additive_expression();
                        this.jj_consume_token(12);
                        maxBoundary = this.additive_expression();
                        leftOperand = ComparisonSelectorExpression.createExpression_Between(leftOperand, minBoundary, maxBoundary);
                        continue block28;
                    }
                }
                this.jj_la1[9] = this.jj_gen;
                if (this.jj_2_3(2)) {
                    this.jj_consume_token(11);
                    this.jj_consume_token(14);
                    minBoundary = this.additive_expression();
                    this.jj_consume_token(12);
                    maxBoundary = this.additive_expression();
                    leftOperand = ComparisonSelectorExpression.createExpression_NotBetween(leftOperand, minBoundary, maxBoundary);
                    continue;
                }
                if (this.jj_2_4(3)) {
                    this.jj_consume_token(17);
                    this.jj_consume_token(44);
                    literal = this.stringLiteral();
                    objects = new HashSet<Object>();
                    objects.add(literal);
                    block29: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 45: {
                                break;
                            }
                            default: {
                                this.jj_la1[5] = this.jj_gen;
                                break block29;
                            }
                        }
                        this.jj_consume_token(45);
                        literal = this.stringLiteral();
                        objects.add(literal);
                    }
                    this.jj_consume_token(46);
                    leftOperand = UnarySelectorExpression.createExpression_IN(leftOperand, false, objects);
                    continue;
                }
                if (this.jj_2_5(3)) {
                    this.jj_consume_token(17);
                    this.jj_consume_token(21);
                    this.jj_consume_token(44);
                    literal = this.constraintName();
                    this.jj_consume_token(46);
                    leftOperand = UnarySelectorExpression.createExpression_IN(leftOperand, false, this.externalDataSource.getInValues(), literal, true);
                    continue;
                }
                if (this.jj_2_6(3)) {
                    this.jj_consume_token(17);
                    this.jj_consume_token(22);
                    this.jj_consume_token(44);
                    literal = this.constraintName();
                    this.jj_consume_token(46);
                    leftOperand = UnarySelectorExpression.createExpression_IN(leftOperand, false, this.externalDataSource.getInValues(), literal, false);
                    continue;
                }
                if (this.jj_2_7(4)) {
                    this.jj_consume_token(11);
                    this.jj_consume_token(17);
                    this.jj_consume_token(44);
                    literal = this.stringLiteral();
                    objects = new HashSet();
                    objects.add(literal);
                    block30: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 45: {
                                break;
                            }
                            default: {
                                this.jj_la1[6] = this.jj_gen;
                                break block30;
                            }
                        }
                        this.jj_consume_token(45);
                        literal = this.stringLiteral();
                        objects.add(literal);
                    }
                    this.jj_consume_token(46);
                    leftOperand = UnarySelectorExpression.createExpression_IN(leftOperand, true, objects);
                    continue;
                }
                if (this.jj_2_8(4)) {
                    this.jj_consume_token(11);
                    this.jj_consume_token(17);
                    this.jj_consume_token(21);
                    this.jj_consume_token(44);
                    literal = this.constraintName();
                    this.jj_consume_token(46);
                    leftOperand = UnarySelectorExpression.createExpression_IN(leftOperand, true, this.externalDataSource.getInValues(), literal, true);
                    continue;
                }
                if (this.jj_2_9(4)) {
                    this.jj_consume_token(11);
                    this.jj_consume_token(17);
                    this.jj_consume_token(22);
                    this.jj_consume_token(44);
                    literal = this.constraintName();
                    this.jj_consume_token(46);
                    leftOperand = UnarySelectorExpression.createExpression_IN(leftOperand, true, this.externalDataSource.getInValues(), literal, false);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        escapeLiteral = null;
                        this.jj_consume_token(15);
                        likeLiteral = this.stringLiteral();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 16: {
                                this.jj_consume_token(16);
                                escapeLiteral = this.stringLiteral();
                                break;
                            }
                            default: {
                                this.jj_la1[7] = this.jj_gen;
                            }
                        }
                        leftOperand = UnarySelectorExpression.createExpression_LIKE(leftOperand, likeLiteral, escapeLiteral);
                        continue block28;
                    }
                }
                this.jj_la1[10] = this.jj_gen;
                if (this.jj_2_10(2)) {
                    escapeLiteral = null;
                    this.jj_consume_token(11);
                    this.jj_consume_token(15);
                    likeLiteral = this.stringLiteral();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 16: {
                            this.jj_consume_token(16);
                            escapeLiteral = this.stringLiteral();
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                        }
                    }
                    leftOperand = UnarySelectorExpression.createExpression_NOT_LIKE(leftOperand, likeLiteral, escapeLiteral);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: {
                        this.jj_consume_token(19);
                        literal = this.stringLiteral();
                        leftOperand = UnarySelectorExpression.createExpression_MATCHES(leftOperand, literal);
                        continue block28;
                    }
                }
                this.jj_la1[11] = this.jj_gen;
                if (!this.jj_2_11(2)) break;
                this.jj_consume_token(11);
                this.jj_consume_token(19);
                literal = this.stringLiteral();
                leftOperand = UnarySelectorExpression.createExpression_NOT_MATCHES(leftOperand, literal);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return leftOperand;
    }

    public final SelectorExpression additive_expression() throws ParseException {
        SelectorExpression leftOperand;
        block8: {
            leftOperand = this.multiplicative_expression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 47: 
                    case 48: {
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 47: {
                        this.jj_consume_token(47);
                        SelectorExpression rightOperand = this.multiplicative_expression();
                        leftOperand = ArithmeticalSelectorExpression.createExpression_Addition(leftOperand, rightOperand);
                        continue block7;
                    }
                    case 48: {
                        this.jj_consume_token(48);
                        SelectorExpression rightOperand = this.multiplicative_expression();
                        leftOperand = ArithmeticalSelectorExpression.createExpression_Subtraction(leftOperand, rightOperand);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[13] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return leftOperand;
    }

    public final SelectorExpression multiplicative_expression() throws ParseException {
        SelectorExpression leftOperand;
        block9: {
            leftOperand = this.unary_expression();
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 25: 
                    case 49: 
                    case 50: {
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 49: {
                        this.jj_consume_token(49);
                        SelectorExpression rightOperand = this.unary_expression();
                        leftOperand = ArithmeticalSelectorExpression.createExpression_Multiplication(leftOperand, rightOperand);
                        continue block8;
                    }
                    case 50: {
                        this.jj_consume_token(50);
                        SelectorExpression rightOperand = this.unary_expression();
                        leftOperand = ArithmeticalSelectorExpression.createExpression_Division(leftOperand, rightOperand);
                        continue block8;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        SelectorExpression rightOperand = this.unary_expression();
                        leftOperand = ArithmeticalSelectorExpression.createExpression_Modulo(leftOperand, rightOperand);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[15] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return leftOperand;
    }

    public final SelectorExpression unary_expression() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 47 -> {
                this.jj_consume_token(47);
                yield this.unary_expression();
            }
            case 48 -> {
                this.jj_consume_token(48);
                yield UnarySelectorExpression.createExpression_Minus(this.unary_expression());
            }
            case 11 -> {
                this.jj_consume_token(11);
                yield UnarySelectorExpression.createExpression_NOT(this.convertToBoolean(this.unary_expression()));
            }
            case 8, 9, 10, 20, 23, 24, 26, 27, 28, 29, 30, 31, 32, 44 -> this.primary_expression();
            default -> {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final SelectorExpression primary_expression() throws ParseException {
        SelectorExpression operand;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                operand = this.exists_expression();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                operand = this.literal();
                break;
            }
            case 24: 
            case 26: 
            case 32: {
                operand = this.variable();
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                operand = this.or_expression();
                this.jj_consume_token(46);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return operand;
    }

    public final SelectorExpression exists_expression() throws ParseException {
        this.jj_consume_token(23);
        VariableSelectorExpression var = this.variable();
        return UnarySelectorExpression.createExpression_Exists(var);
    }

    public final ConstantSelectorExpression literal() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                String stringLiteral = this.stringLiteral();
                return ConstantSelectorExpression.createExpression_String(stringLiteral);
            }
            case 28: {
                Token token = this.jj_consume_token(28);
                return ConstantSelectorExpression.createExpression_Decimal(token.image);
            }
            case 29: {
                Token token = this.jj_consume_token(29);
                return ConstantSelectorExpression.createExpression_Hex(token.image);
            }
            case 30: {
                Token token = this.jj_consume_token(30);
                return ConstantSelectorExpression.createExpression_Octal(token.image);
            }
            case 31: {
                Token token = this.jj_consume_token(31);
                return ConstantSelectorExpression.createExpression_FloatingPoint(token.image);
            }
            case 20: {
                this.jj_consume_token(20);
                this.jj_consume_token(44);
                String stringLiteral = this.stringLiteral();
                this.jj_consume_token(46);
                return ConstantSelectorExpression.createExpression_DateTime(stringLiteral);
            }
            case 8: {
                this.jj_consume_token(8);
                return ConstantSelectorExpression.NULL;
            }
            case 9: {
                this.jj_consume_token(9);
                return ConstantSelectorExpression.TRUE;
            }
            case 10: {
                this.jj_consume_token(10);
                return ConstantSelectorExpression.FALSE;
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String stringLiteral() throws ParseException {
        Token token = this.jj_consume_token(27);
        return SelectorUtils.getStringLiteral(token.image.substring(1, token.image.length() - 1));
    }

    public final String constraintName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: {
                this.jj_consume_token(49);
                return "*";
            }
            case 51: {
                this.jj_consume_token(51);
                return "*.*";
            }
            case 52: {
                this.jj_consume_token(52);
                Token token = this.jj_consume_token(32);
                return "*." + token.image;
            }
        }
        this.jj_la1[19] = this.jj_gen;
        if (this.jj_2_12(2)) {
            Token token = this.jj_consume_token(32);
            this.jj_consume_token(53);
            return token.image + ".*";
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                Token token = this.jj_consume_token(32);
                return token.image;
            }
            case 33: {
                Token token = this.jj_consume_token(33);
                return token.image;
            }
            case 34: {
                Token token = this.jj_consume_token(34);
                return token.image;
            }
            case 35: {
                Token token = this.jj_consume_token(35);
                return token.image;
            }
        }
        this.jj_la1[20] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final VariableSelectorExpression variable() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                Token token = this.jj_consume_token(32);
                return new VariableSelectorExpression(token.image, this.externalDataSource);
            }
            case 24: {
                this.jj_consume_token(24);
                Token token = this.jj_consume_token(32);
                this.jj_consume_token(54);
                return new VariableSelectorExpression(token.image, this.externalDataSource, true, false);
            }
            case 26: {
                this.jj_consume_token(26);
                Token token = this.jj_consume_token(32);
                this.jj_consume_token(54);
                return new VariableSelectorExpression(token.image, this.externalDataSource, false, true);
            }
        }
        this.jj_la1[21] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    private boolean jj_3_11() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(19);
    }

    private boolean jj_3_9() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_scan_token(44);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_scan_token(8);
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_scan_token(44)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private boolean jj_3_8() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        return this.jj_scan_token(44);
    }

    private boolean jj_3_12() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        return this.jj_scan_token(53);
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_scan_token(44);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_scan_token(44)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private boolean jj_3R_9() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3_10() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        return this.jj_scan_token(44);
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(14);
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(8);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{8192, 4096, 262144, 0, 706560, 0, 0, 65536, 65536, 16384, 32768, 524288, 0, 0, 0x2000000, 0x2000000, -40890624, -40892672, -133167360, 0, 0, 0x5000000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 240, 240, 3840, 8192, 8192, 0, 0, 3840, 0, 0, 98304, 98304, 393216, 393216, 102401, 4097, 0, 0x1A0000, 15, 1};
    }

    public SelectorParser(InputStream stream) {
        this(stream, null);
    }

    public SelectorParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SelectorParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SelectorParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SelectorParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SelectorParser(SelectorParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SelectorParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[55];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 22; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 55; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 12; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SelectorParser.jj_la1_init_0();
        SelectorParser.jj_la1_init_1();
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

