/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.selector;

import com.streamscape.lib.selector.EventSelectorValueSource;
import com.streamscape.lib.selector.SelectorEvaluationException;
import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.lib.selector.SelectorExternalDataSource;
import com.streamscape.lib.selector.SelectorValueSource;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.scheduler.Metaset;

public class VariableSelectorExpression
extends SelectorExpression {
    private String variableName;
    private SelectorExternalDataSource dataSource;
    private boolean isMetaset = false;
    private boolean isCompletion = false;
    private boolean forExists = false;

    public VariableSelectorExpression(String variableName, SelectorExternalDataSource dataSource) {
        this.variableName = variableName;
        this.dataSource = dataSource;
    }

    public VariableSelectorExpression(String variableName, SelectorExternalDataSource dataSource, boolean isMetaset, boolean isCompletion) {
        this(variableName, dataSource);
        this.isMetaset = isMetaset;
        this.isCompletion = isCompletion;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public SelectorExternalDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean forExists() {
        return this.forExists;
    }

    void setForExists() {
        this.forExists = true;
    }

    public boolean isCompletion() {
        return this.isCompletion;
    }

    @Override
    protected Object evaluate(Object object) throws SelectorEvaluationException {
        if (this.isMetaset) {
            Metaset metaset = this.dataSource.getMetaset();
            return metaset != null ? metaset.getValue(this) : null;
        }
        if (object instanceof ImmutableEventDatagram) {
            return new EventSelectorValueSource((ImmutableEventDatagram)object).getValue(this);
        }
        if (object instanceof SelectorValueSource) {
            return ((SelectorValueSource)object).getValue(this);
        }
        return null;
    }
}

