/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.selector;

import com.streamscape.lib.selector.SelectorEvaluationException;
import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.lib.selector.SelectorInValues;
import com.streamscape.lib.selector.UnarySelectorExpression;
import java.util.Set;

class UnarySelectorExpression_IN
extends UnarySelectorExpression {
    private boolean isNegate;
    private Set<Object> values;
    private SelectorInValues inValues;
    private String constraintName;
    private boolean isDomain;

    private UnarySelectorExpression_IN(SelectorExpression operand, boolean isNegate) {
        super(operand);
        this.isNegate = isNegate;
    }

    UnarySelectorExpression_IN(SelectorExpression operand, boolean isNegate, Set<Object> values) {
        this(operand, isNegate);
        this.values = values;
    }

    UnarySelectorExpression_IN(SelectorExpression operand, boolean isNegate, SelectorInValues inValues, String constraintName, boolean isDomain) {
        this(operand, isNegate);
        this.inValues = inValues;
        this.constraintName = constraintName;
        this.isDomain = isDomain;
    }

    @Override
    protected Object evaluate(Object object) throws SelectorEvaluationException {
        Object value = this.operand.evaluate(object);
        if (value == null) {
            return false;
        }
        boolean contains = false;
        if (this.inValues != null) {
            contains = this.isDomain ? this.inValues.matchesDomain(this.constraintName, value) : this.inValues.matchesRange(this.constraintName, value);
        } else if (value instanceof String && this.values != null) {
            contains = this.values.contains(value);
        }
        return this.isNegate != contains;
    }

    @Override
    protected String getOperator() {
        return this.isNegate ? "NOT IN" : "IN";
    }
}

