/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.selector;

import com.streamscape.lib.selector.SelectorEvaluationException;
import com.streamscape.lib.selector.SelectorValueSource;
import com.streamscape.lib.selector.VariableSelectorExpression;
import com.streamscape.lib.utils.CIString;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.advisory.AbstractReplicationAdvisory;
import com.streamscape.sdo.advisory.ComponentStateChangeAdvisory;
import com.streamscape.sdo.advisory.DaemonServiceBlockedAdvisory;
import com.streamscape.sdo.advisory.MetricAdvisory;
import com.streamscape.sdo.advisory.ReplicaMetricAdvisory;
import com.streamscape.sdo.advisory.ReplicaStateChangeAdvisory;
import com.streamscape.sdo.advisory.ReplicaTimeoutAdvisory;
import com.streamscape.sdo.advisory.ReplicationExceptionAdvisory;
import com.streamscape.sdo.advisory.ReplicationFailAdvisory;
import com.streamscape.sdo.advisory.ReplicationSourceMetricAdvisory;
import com.streamscape.sdo.advisory.StateAdvisory;
import com.streamscape.sdo.advisory.VirtualServerStateChangeAdvisory;
import com.streamscape.sdo.enums.ReadAccess;
import com.streamscape.sdo.enums.TransmitAccess;
import com.streamscape.sdo.enums.WriteAccess;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.jms.Message;
import com.streamscape.sef.accessor.FabricComponentAccessorAdvisory;
import com.streamscape.sef.coherence.CoherenceAgentAdvisory;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.exchange.FabricExchangeAdvisory;
import com.streamscape.sef.moderator.FabricModeratorAdvisory;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.scheduler.SchedulerAdvisory;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;

class EventSelectorValueSource
implements SelectorValueSource {
    private static Map<CIString, ImmutableEventDatagramFieldGetter> immutableEventGetters = new HashMap<CIString, ImmutableEventDatagramFieldGetter>();
    private static Map<CIString, OpaqueDatagramFieldGetter> opaqueGetters = new HashMap<CIString, OpaqueDatagramFieldGetter>();
    private static Map<CIString, EventDatagramFieldGetter> eventGetters = new HashMap<CIString, EventDatagramFieldGetter>();
    private static Map<CIString, AdvisoryEventDatagramFieldGetter> advisoryGetters = new HashMap<CIString, AdvisoryEventDatagramFieldGetter>();
    private static Map<CIString, ModeratorAdvisoryFieldGetter> moderatorAdvisoryGetters = new HashMap<CIString, ModeratorAdvisoryFieldGetter>();
    private static Map<CIString, ExchangeAdvisoryFieldGetter> exchangeAdvisoryGetters = new HashMap<CIString, ExchangeAdvisoryFieldGetter>();
    private static Map<CIString, SchedulerAdvisoryFieldGetter> schedulerAdvisoryGetters = new HashMap<CIString, SchedulerAdvisoryFieldGetter>();
    private static Map<CIString, CoherenceAdvisoryFieldGetter> coherenceAdvisoryGetters = new HashMap<CIString, CoherenceAdvisoryFieldGetter>();
    private static Map<CIString, ComponentAdvisoryFieldGetter> componentAdvisoryGetters = new HashMap<CIString, ComponentAdvisoryFieldGetter>();
    private static Map<CIString, AccessorAdvisoryFieldGetter> accessorAdvisoryGetters = new HashMap<CIString, AccessorAdvisoryFieldGetter>();
    private static Map<CIString, StateAdvisoryFieldGetter> stateAdvisoryGetters = new HashMap<CIString, StateAdvisoryFieldGetter>();
    private static Map<CIString, MetricAdvisoryFieldGetter> metricAdvisoryGetters = new HashMap<CIString, MetricAdvisoryFieldGetter>();
    private static Map<CIString, ReplicaAdvisoryFieldGetter> replicaAdvisoryGetters = new HashMap<CIString, ReplicaAdvisoryFieldGetter>();
    private static Map<CIString, ReplicaStateAdvisoryFieldGetter> replicaStateAdvisoryGetters = new HashMap<CIString, ReplicaStateAdvisoryFieldGetter>();
    private static Map<CIString, ReplicaTimeoutAdvisoryFieldGetter> replicaTimeoutAdvisoryGetters = new HashMap<CIString, ReplicaTimeoutAdvisoryFieldGetter>();
    private static Map<CIString, ReplicationSourceMetricAdvisoryFieldGetter> replicationSourceMetricAdvisoryGetters = new HashMap<CIString, ReplicationSourceMetricAdvisoryFieldGetter>();
    private static Map<CIString, ReplicaMetricAdvisoryFieldGetter> replicaMetricAdvisoryGetters = new HashMap<CIString, ReplicaMetricAdvisoryFieldGetter>();
    private static Map<CIString, VirtualServerAdvisoryFieldGetter> virtualServerAdvisoryGetters = new HashMap<CIString, VirtualServerAdvisoryFieldGetter>();
    private static Map<CIString, ExceptionEventDatagramFieldGetter> exceptionGetters = new HashMap<CIString, ExceptionEventDatagramFieldGetter>();
    private static Map<CIString, ReplicationExceptionAdvisoryFieldGetter> replicationExceptionAdvisoryGetters = new HashMap<CIString, ReplicationExceptionAdvisoryFieldGetter>();
    private static Map<CIString, DaemonServiceBlockedAdvisoryFieldGetter> daemonServiceBlockedAdvisoryGetters = new HashMap<CIString, DaemonServiceBlockedAdvisoryFieldGetter>();
    private static Map<CIString, MessageFieldGetter> messageGetters = new HashMap<CIString, MessageFieldGetter>();
    private VariableSelectorExpression expression;
    private CIString propertyName;
    private ImmutableEventDatagram event;

    private static <TEvent, TGetter extends FieldGetter<TEvent>> void addGetter(Map<CIString, TGetter> getters, String fieldName, TGetter getter) {
        getters.put(new CIString(fieldName), getter);
    }

    EventSelectorValueSource(ImmutableEventDatagram event) {
        this.event = event;
    }

    @Override
    public Object getValue(VariableSelectorExpression expression) throws SelectorEvaluationException {
        this.expression = expression;
        this.propertyName = new CIString(expression.getVariableName());
        if (this.event instanceof MapEvent) {
            return this.doEvaluate((MapEvent)this.event);
        }
        if (this.event instanceof EventDatagram) {
            return this.doEvaluate((EventDatagram)this.event);
        }
        if (this.event instanceof OpaqueDatagram) {
            return this.doEvaluate((OpaqueDatagram)this.event);
        }
        if (this.event instanceof FabricModeratorAdvisory) {
            return this.doEvaluate((FabricModeratorAdvisory)this.event);
        }
        if (this.event instanceof FabricExchangeAdvisory) {
            return this.doEvaluate((FabricExchangeAdvisory)this.event);
        }
        if (this.event instanceof SchedulerAdvisory) {
            return this.doEvaluate((SchedulerAdvisory)this.event);
        }
        if (this.event instanceof CoherenceAgentAdvisory) {
            return this.doEvaluate((CoherenceAgentAdvisory)this.event);
        }
        if (this.event instanceof ComponentStateChangeAdvisory) {
            return this.doEvaluate((ComponentStateChangeAdvisory)this.event);
        }
        if (this.event instanceof FabricComponentAccessorAdvisory) {
            return this.doEvaluate((FabricComponentAccessorAdvisory)this.event);
        }
        if (this.event instanceof StateAdvisory) {
            return this.doEvaluate((StateAdvisory)this.event);
        }
        if (this.event instanceof MetricAdvisory) {
            return this.doEvaluate((MetricAdvisory)this.event);
        }
        if (this.event instanceof ReplicaStateChangeAdvisory) {
            return this.doEvaluate((ReplicaStateChangeAdvisory)this.event);
        }
        if (this.event instanceof ReplicaTimeoutAdvisory) {
            return this.doEvaluate((ReplicaTimeoutAdvisory)this.event);
        }
        if (this.event instanceof ReplicationFailAdvisory) {
            return this.doEvaluate((ReplicationFailAdvisory)this.event);
        }
        if (this.event instanceof ReplicationExceptionAdvisory) {
            return this.doEvaluate((ReplicationExceptionAdvisory)this.event);
        }
        if (this.event instanceof ReplicationSourceMetricAdvisory) {
            return this.doEvaluate((ReplicationSourceMetricAdvisory)this.event);
        }
        if (this.event instanceof ReplicaMetricAdvisory) {
            return this.doEvaluate((ReplicaMetricAdvisory)this.event);
        }
        if (this.event instanceof VirtualServerStateChangeAdvisory) {
            return this.doEvaluate((VirtualServerStateChangeAdvisory)this.event);
        }
        if (this.event instanceof AdvisoryEventDatagram) {
            return this.doEvaluate((AdvisoryEventDatagram)this.event);
        }
        if (this.event instanceof ExceptionEventDatagram) {
            return this.doEvaluate((ExceptionEventDatagram)this.event);
        }
        if (this.event instanceof DaemonServiceBlockedAdvisory) {
            return this.doEvaluate((DaemonServiceBlockedAdvisory)this.event);
        }
        if (this.event instanceof Message) {
            return this.doEvaluate((Message)this.event);
        }
        return this.doEvaluate(this.event);
    }

    private Object doEvaluate(ImmutableEventDatagram event) throws SelectorEvaluationException {
        ImmutableEventDatagramFieldGetter getter = immutableEventGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : null;
    }

    private Object doEvaluate(OpaqueDatagram event) throws SelectorEvaluationException {
        OpaqueDatagramFieldGetter getter = opaqueGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((ImmutableEventDatagram)event);
    }

    private Object doEvaluate(EventDatagram event) throws SelectorEvaluationException {
        try {
            EventDatagramFieldGetter getter = eventGetters.get(this.propertyName);
            if (getter == null) {
                ImmutableEventDatagramFieldGetter parentGetter = immutableEventGetters.get(this.propertyName);
                if (parentGetter != null) {
                    return this.doEvaluate(parentGetter, event);
                }
                if (this.expression.forExists()) {
                    return event.existsEventProperty(this.propertyName.toString());
                }
                Object propertyValue = event.getEventObjectProperty(this.propertyName.toString());
                return propertyValue instanceof Enum ? ((Enum)propertyValue).name() : propertyValue;
            }
            return this.doEvaluate(getter, event);
        }
        catch (SDOException exception) {
            throw new SelectorEvaluationException(exception);
        }
    }

    private Object doEvaluate(MapEvent event) throws SelectorEvaluationException {
        try {
            if (this.expression.forExists()) {
                return event.itemExists(this.propertyName.toString()) ? Boolean.valueOf(true) : this.doEvaluate((EventDatagram)event);
            }
            Object propertyValue = event.getObject(this.propertyName.toString());
            return propertyValue != null ? propertyValue : this.doEvaluate((EventDatagram)event);
        }
        catch (SDOException exception) {
            throw new SelectorEvaluationException(exception);
        }
        catch (SecurityViolationException exception) {
            throw new SelectorEvaluationException(exception);
        }
    }

    private Object doEvaluate(AdvisoryEventDatagram event) throws SelectorEvaluationException {
        AdvisoryEventDatagramFieldGetter getter = advisoryGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((ImmutableEventDatagram)event);
    }

    private Object doEvaluate(FabricModeratorAdvisory event) throws SelectorEvaluationException {
        ModeratorAdvisoryFieldGetter getter = moderatorAdvisoryGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((AdvisoryEventDatagram)event);
    }

    private Object doEvaluate(FabricExchangeAdvisory event) throws SelectorEvaluationException {
        ExchangeAdvisoryFieldGetter getter = exchangeAdvisoryGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((AdvisoryEventDatagram)event);
    }

    private Object doEvaluate(SchedulerAdvisory event) throws SelectorEvaluationException {
        SchedulerAdvisoryFieldGetter getter = schedulerAdvisoryGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((AdvisoryEventDatagram)event);
    }

    private Object doEvaluate(CoherenceAgentAdvisory event) throws SelectorEvaluationException {
        CoherenceAdvisoryFieldGetter getter = coherenceAdvisoryGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((AdvisoryEventDatagram)event);
    }

    private Object doEvaluate(ComponentStateChangeAdvisory event) throws SelectorEvaluationException {
        ComponentAdvisoryFieldGetter getter = componentAdvisoryGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((AdvisoryEventDatagram)event);
    }

    private Object doEvaluate(FabricComponentAccessorAdvisory event) throws SelectorEvaluationException {
        AccessorAdvisoryFieldGetter getter = accessorAdvisoryGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((AdvisoryEventDatagram)event);
    }

    private Object doEvaluate(StateAdvisory event) throws SelectorEvaluationException {
        StateAdvisoryFieldGetter getter = stateAdvisoryGetters.get(this.propertyName);
        if (getter == null) {
            AdvisoryEventDatagramFieldGetter advisoryGetter = advisoryGetters.get(this.propertyName);
            if (advisoryGetter == null) {
                ImmutableEventDatagramFieldGetter parentGetter = immutableEventGetters.get(this.propertyName);
                return parentGetter != null ? this.doEvaluate(parentGetter, event) : (this.expression.forExists() ? Boolean.valueOf(event.existsProperty(this.propertyName.toString())) : event.getProperty(this.propertyName.toString()));
            }
            return this.doEvaluate(advisoryGetter, event);
        }
        return this.doEvaluate(getter, event);
    }

    private Object doEvaluate(AbstractReplicationAdvisory event) throws SelectorEvaluationException {
        ReplicaAdvisoryFieldGetter getter = replicaAdvisoryGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((AdvisoryEventDatagram)event);
    }

    private Object doEvaluate(ReplicaStateChangeAdvisory event) throws SelectorEvaluationException {
        ReplicaStateAdvisoryFieldGetter getter = replicaStateAdvisoryGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((AbstractReplicationAdvisory)event);
    }

    private Object doEvaluate(ReplicationExceptionAdvisory event) throws SelectorEvaluationException {
        ReplicationExceptionAdvisoryFieldGetter getter = replicationExceptionAdvisoryGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((AbstractReplicationAdvisory)event);
    }

    private Object doEvaluate(ReplicaTimeoutAdvisory event) throws SelectorEvaluationException {
        ReplicaTimeoutAdvisoryFieldGetter getter = replicaTimeoutAdvisoryGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((AbstractReplicationAdvisory)event);
    }

    private Object doEvaluate(ReplicationFailAdvisory event) throws SelectorEvaluationException {
        return this.doEvaluate((AbstractReplicationAdvisory)event);
    }

    private Object doEvaluate(ReplicationSourceMetricAdvisory event) throws SelectorEvaluationException {
        ReplicationSourceMetricAdvisoryFieldGetter getter = replicationSourceMetricAdvisoryGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((AdvisoryEventDatagram)event);
    }

    private Object doEvaluate(ReplicaMetricAdvisory event) throws SelectorEvaluationException {
        ReplicaMetricAdvisoryFieldGetter getter = replicaMetricAdvisoryGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((AdvisoryEventDatagram)event);
    }

    private Object doEvaluate(VirtualServerStateChangeAdvisory event) throws SelectorEvaluationException {
        VirtualServerAdvisoryFieldGetter getter = virtualServerAdvisoryGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((AdvisoryEventDatagram)event);
    }

    private Object doEvaluate(DaemonServiceBlockedAdvisory event) throws SelectorEvaluationException {
        DaemonServiceBlockedAdvisoryFieldGetter getter = daemonServiceBlockedAdvisoryGetters.get(this.propertyName);
        return getter != null ? this.doEvaluate(getter, event) : this.doEvaluate((AdvisoryEventDatagram)event);
    }

    private Object doEvaluate(ExceptionEventDatagram event) throws SelectorEvaluationException {
        try {
            ExceptionEventDatagramFieldGetter getter = exceptionGetters.get(this.propertyName);
            if (getter == null) {
                ImmutableEventDatagramFieldGetter parentGetter = immutableEventGetters.get(this.propertyName);
                if (parentGetter != null) {
                    return this.doEvaluate(parentGetter, event);
                }
                if (this.expression.forExists()) {
                    return event.existsEventProperty(this.propertyName.toString());
                }
                Object propertyValue = event.getEventObjectProperty(this.propertyName.toString());
                return propertyValue instanceof Enum ? ((Enum)propertyValue).name() : propertyValue;
            }
            return this.doEvaluate(getter, event);
        }
        catch (SDOException exception) {
            throw new SelectorEvaluationException(exception);
        }
    }

    private Object doEvaluate(Message message) throws SelectorEvaluationException {
        try {
            MessageFieldGetter getter = messageGetters.get(this.propertyName);
            if (getter == null) {
                ImmutableEventDatagramFieldGetter parentGetter = immutableEventGetters.get(this.propertyName);
                return parentGetter != null ? this.doEvaluate(parentGetter, message) : (this.expression.forExists() ? Boolean.valueOf(message.propertyExists(this.propertyName.toString())) : message.getObjectProperty(this.propertyName.toString()));
            }
            return this.expression.forExists() ? Boolean.valueOf(true) : getter.get(message, this);
        }
        catch (JMSException exception) {
            throw new SelectorEvaluationException(exception);
        }
    }

    private <T> Object doEvaluate(FieldGetter<T> getter, T event) {
        return this.expression.forExists() ? Boolean.valueOf(true) : getter.get(event, this);
    }

    public String toString() {
        return this.propertyName.toString();
    }

    private String getComponentName(byte[] eventSource) {
        Moderator moderator = this.expression.getDataSource().getModerator();
        if (moderator != null && eventSource != null) {
            FabricAddress sourceAddress = new FabricAddress(eventSource);
            NamedObject result = sourceAddress.getComponentNumber() == 0 ? moderator.lookupFabricNode(sourceAddress) : moderator.lookupComponent(sourceAddress);
            return result != null ? result.getName() : null;
        }
        return null;
    }

    static {
        EventSelectorValueSource.addGetter(immutableEventGetters, "eventId", (event, expression) -> event.getEventId());
        EventSelectorValueSource.addGetter(immutableEventGetters, "timestamp", (event, expression) -> event.getTimestamp().getTime());
        EventSelectorValueSource.addGetter(immutableEventGetters, "transmitAccess", (event, expression) -> TransmitAccess.toString(event.getTransmitAccess()));
        EventSelectorValueSource.addGetter(immutableEventGetters, "eventSource", (event, expression) -> expression.getComponentName(event.getEventSource()));
        EventSelectorValueSource.addGetter(immutableEventGetters, "durable", (event, expression) -> event.getDurable());
        EventSelectorValueSource.addGetter(opaqueGetters, "eventKey", (event, expression) -> event.getEventKey());
        EventSelectorValueSource.addGetter(opaqueGetters, "eventGroupId", (event, expression) -> event.getEventGroupId());
        EventSelectorValueSource.addGetter(eventGetters, "eventKey", (event, expression) -> event.getEventKey());
        EventSelectorValueSource.addGetter(eventGetters, "eventGroupId", (event, expression) -> event.getEventGroupId());
        EventSelectorValueSource.addGetter(eventGetters, "correlationId", (event, expression) -> event.getCorrelationId());
        EventSelectorValueSource.addGetter(eventGetters, "replyTo", (event, expression) -> event.getReplyTo());
        EventSelectorValueSource.addGetter(eventGetters, "forwardTo", (event, expression) -> event.getForwardTo());
        EventSelectorValueSource.addGetter(eventGetters, "readAccess", (event, expression) -> ReadAccess.toString(event.getReadAccess()));
        EventSelectorValueSource.addGetter(eventGetters, "writeAccess", (event, expression) -> WriteAccess.toString(event.getWriteAccess()));
        EventSelectorValueSource.addGetter(advisoryGetters, "eventKey", (event, expression) -> event.getEventKey());
        EventSelectorValueSource.addGetter(advisoryGetters, "eventGroupId", (event, expression) -> event.getEventGroupId());
        EventSelectorValueSource.addGetter(advisoryGetters, "correlationId", (event, expression) -> event.getCorrelationId());
        EventSelectorValueSource.addGetter(moderatorAdvisoryGetters, "type", (event, expression) -> event.getType().name());
        EventSelectorValueSource.addGetter(moderatorAdvisoryGetters, "entity", (event, expression) -> event.getEntity());
        EventSelectorValueSource.addGetter(moderatorAdvisoryGetters, "info", (event, expression) -> event.getInfo());
        EventSelectorValueSource.addGetter(exchangeAdvisoryGetters, "nodeName", (event, expression) -> event.getNodeName());
        EventSelectorValueSource.addGetter(exchangeAdvisoryGetters, "state", (event, expression) -> event.getState().name());
        EventSelectorValueSource.addGetter(schedulerAdvisoryGetters, "type", (event, expression) -> event.getType().name());
        EventSelectorValueSource.addGetter(schedulerAdvisoryGetters, "jobName", (event, expression) -> event.getJobName());
        EventSelectorValueSource.addGetter(schedulerAdvisoryGetters, "listName", (event, expression) -> event.getListName());
        EventSelectorValueSource.addGetter(schedulerAdvisoryGetters, "taskName", (event, expression) -> event.getTaskName());
        EventSelectorValueSource.addGetter(coherenceAdvisoryGetters, "type", (event, expression) -> event.getType().name());
        EventSelectorValueSource.addGetter(coherenceAdvisoryGetters, "entity", (event, expression) -> event.getEntity());
        EventSelectorValueSource.addGetter(componentAdvisoryGetters, "state", (event, expression) -> event.getState().name());
        EventSelectorValueSource.addGetter(componentAdvisoryGetters, "message", (event, expression) -> event.getMessage());
        EventSelectorValueSource.addGetter(accessorAdvisoryGetters, "accessorName", (event, expression) -> event.getAccessorName());
        EventSelectorValueSource.addGetter(accessorAdvisoryGetters, "resourceName", (event, expression) -> event.getResourceName());
        EventSelectorValueSource.addGetter(accessorAdvisoryGetters, "userName", (event, expression) -> event.getUserName());
        EventSelectorValueSource.addGetter(accessorAdvisoryGetters, "state", (event, expression) -> event.getState().name());
        EventSelectorValueSource.addGetter(stateAdvisoryGetters, "name", (event, expression) -> event.getName());
        EventSelectorValueSource.addGetter(stateAdvisoryGetters, "type", (event, expression) -> event.getType().name());
        EventSelectorValueSource.addGetter(stateAdvisoryGetters, "message", (event, expression) -> event.getMessage());
        EventSelectorValueSource.addGetter(metricAdvisoryGetters, "name", (event, expression) -> event.getName());
        EventSelectorValueSource.addGetter(metricAdvisoryGetters, "description", (event, expression) -> event.getDescription());
        EventSelectorValueSource.addGetter(metricAdvisoryGetters, "minThreshold", (event, expression) -> event.getMinThreshold());
        EventSelectorValueSource.addGetter(metricAdvisoryGetters, "maxThreshold", (event, expression) -> event.getMaxThreshold());
        EventSelectorValueSource.addGetter(metricAdvisoryGetters, "units", (event, expression) -> event.getUnits().name());
        EventSelectorValueSource.addGetter(metricAdvisoryGetters, "metricTimestamp", (event, expression) -> event.getMetricTimestamp().getTime());
        EventSelectorValueSource.addGetter(metricAdvisoryGetters, "value", (event, expression) -> event.getValue());
        EventSelectorValueSource.addGetter(metricAdvisoryGetters, "advisoryMessage", (event, expression) -> event.getAdvisoryMessage());
        EventSelectorValueSource.addGetter(metricAdvisoryGetters, "resetInterval", (event, expression) -> event.getResetInterval());
        EventSelectorValueSource.addGetter(replicaAdvisoryGetters, "originator", (event, expression) -> event.getOriginator());
        EventSelectorValueSource.addGetter(replicaAdvisoryGetters, "sourceNodeName", (event, expression) -> event.getSourceNodeName());
        EventSelectorValueSource.addGetter(replicaAdvisoryGetters, "sourceDataspaceType", (event, expression) -> event.getSourceDataspaceType());
        EventSelectorValueSource.addGetter(replicaAdvisoryGetters, "sourceDataspaceName", (event, expression) -> event.getSourceDataspaceName());
        EventSelectorValueSource.addGetter(replicaAdvisoryGetters, "replicaNodeName", (event, expression) -> event.getReplicaNodeName());
        EventSelectorValueSource.addGetter(replicaAdvisoryGetters, "replicaDataspaceType", (event, expression) -> event.getReplicaDataspaceType());
        EventSelectorValueSource.addGetter(replicaAdvisoryGetters, "replicaDataspaceName", (event, expression) -> event.getReplicaDataspaceName());
        EventSelectorValueSource.addGetter(replicaAdvisoryGetters, "sourceName", (event, expression) -> event.getSourceName());
        EventSelectorValueSource.addGetter(replicaAdvisoryGetters, "replicaName", (event, expression) -> event.getReplicaName());
        EventSelectorValueSource.addGetter(replicaStateAdvisoryGetters, "isSuspended", (event, expression) -> event.isSuspended());
        EventSelectorValueSource.addGetter(replicaStateAdvisoryGetters, "replicaState", (event, expression) -> event.getReplicaState().name());
        EventSelectorValueSource.addGetter(replicationExceptionAdvisoryGetters, "exception", (event, expression) -> event.getException());
        EventSelectorValueSource.addGetter(replicaTimeoutAdvisoryGetters, "timeout", (event, expression) -> event.getTimeout());
        EventSelectorValueSource.addGetter(replicaTimeoutAdvisoryGetters, "batchSize", (event, expression) -> event.getBatchSize());
        EventSelectorValueSource.addGetter(replicaTimeoutAdvisoryGetters, "batchSizeInBytes", (event, expression) -> event.getBatchSizeInBytes());
        EventSelectorValueSource.addGetter(replicationSourceMetricAdvisoryGetters, "sourceDataspaceType", (event, expression) -> event.getSourceDataspaceType());
        EventSelectorValueSource.addGetter(replicationSourceMetricAdvisoryGetters, "sourceDataspaceName", (event, expression) -> event.getSourceDataspaceName());
        EventSelectorValueSource.addGetter(replicationSourceMetricAdvisoryGetters, "sourceName", (event, expression) -> event.getSourceName());
        EventSelectorValueSource.addGetter(replicaMetricAdvisoryGetters, "sourceDataspaceType", (event, expression) -> event.getSourceDataspaceType());
        EventSelectorValueSource.addGetter(replicaMetricAdvisoryGetters, "sourceDataspaceName", (event, expression) -> event.getSourceDataspaceName());
        EventSelectorValueSource.addGetter(replicaMetricAdvisoryGetters, "sourceName", (event, expression) -> event.getSourceName());
        EventSelectorValueSource.addGetter(replicaMetricAdvisoryGetters, "targetDataspaceType", (event, expression) -> event.getTargetDataspaceType());
        EventSelectorValueSource.addGetter(replicaMetricAdvisoryGetters, "targetDataspaceName", (event, expression) -> event.getTargetDataspaceName());
        EventSelectorValueSource.addGetter(replicaMetricAdvisoryGetters, "replicaName", (event, expression) -> event.getReplicaName());
        EventSelectorValueSource.addGetter(virtualServerAdvisoryGetters, "isStarted", (event, expression) -> event.isStarted());
        EventSelectorValueSource.addGetter(virtualServerAdvisoryGetters, "serverName", (event, expression) -> event.getServerName());
        EventSelectorValueSource.addGetter(virtualServerAdvisoryGetters, "factoryType", (event, expression) -> event.getFactoryType());
        EventSelectorValueSource.addGetter(virtualServerAdvisoryGetters, "factoryName", (event, expression) -> event.getFactoryName());
        EventSelectorValueSource.addGetter(virtualServerAdvisoryGetters, "componentName", (event, expression) -> event.getComponentName());
        EventSelectorValueSource.addGetter(virtualServerAdvisoryGetters, "connectionState", (event, expression) -> event.getConnectionState().name());
        EventSelectorValueSource.addGetter(exceptionGetters, "errorMessage", (event, expression) -> event.getErrorMessage());
        EventSelectorValueSource.addGetter(exceptionGetters, "errorCode", (event, expression) -> event.getErrorCode());
        EventSelectorValueSource.addGetter(exceptionGetters, "eventKey", (event, expression) -> event.getEventKey());
        EventSelectorValueSource.addGetter(exceptionGetters, "eventGroupId", (event, expression) -> event.getEventGroupId());
        EventSelectorValueSource.addGetter(exceptionGetters, "correlationId", (event, expression) -> event.getCorrelationId());
        EventSelectorValueSource.addGetter(exceptionGetters, "severity", (event, expression) -> event.getSeverity().name());
        EventSelectorValueSource.addGetter(exceptionGetters, "eventSink", (event, expression) -> expression.getComponentName(event.getEventSink()));
        EventSelectorValueSource.addGetter(daemonServiceBlockedAdvisoryGetters, "nodeName", (event, expression) -> event.getNodeName());
        EventSelectorValueSource.addGetter(daemonServiceBlockedAdvisoryGetters, "serviceType", (event, expression) -> event.getServiceType());
        EventSelectorValueSource.addGetter(daemonServiceBlockedAdvisoryGetters, "serviceName", (event, expression) -> event.getServiceName());
        EventSelectorValueSource.addGetter(daemonServiceBlockedAdvisoryGetters, "iterationStartTime", (event, expression) -> event.getIterationStartTime());
        EventSelectorValueSource.addGetter(daemonServiceBlockedAdvisoryGetters, "checkTime", (event, expression) -> event.getCheckTime());
        EventSelectorValueSource.addGetter(messageGetters, "eventKey", (message, expression) -> message.getEventKey());
        EventSelectorValueSource.addGetter(messageGetters, "eventGroupId", (message, expression) -> message.getEventGroupId());
        EventSelectorValueSource.addGetter(messageGetters, "correlationId", (message, expression) -> message.getCorrelationId());
        EventSelectorValueSource.addGetter(messageGetters, "replyTo", (message, expression) -> message.getReplyTo());
        EventSelectorValueSource.addGetter(messageGetters, "forwardTo", (message, expression) -> message.getForwardTo());
        EventSelectorValueSource.addGetter(messageGetters, "readAccess", (message, expression) -> ReadAccess.toString(message.getReadAccess()));
        EventSelectorValueSource.addGetter(messageGetters, "writeAccess", (message, expression) -> WriteAccess.toString(message.getWriteAccess()));
        EventSelectorValueSource.addGetter(messageGetters, "JMSMessageID", (message, expression) -> message.getJMSMessageID());
        EventSelectorValueSource.addGetter(messageGetters, "JMSDeliveryMode", (message, expression) -> message.getJMSDeliveryMode());
        EventSelectorValueSource.addGetter(messageGetters, "JMSRedelivered", (message, expression) -> message.getJMSRedelivered());
        EventSelectorValueSource.addGetter(messageGetters, "JMSType", (message, expression) -> message.getJMSType());
        EventSelectorValueSource.addGetter(messageGetters, "JMSExpiration", (message, expression) -> message.getJMSExpiration());
        EventSelectorValueSource.addGetter(messageGetters, "JMSPriority", (message, expression) -> message.getJMSPriority());
        EventSelectorValueSource.addGetter(messageGetters, "JMSCorrelationID", (message, expression) -> message.getCorrelationId());
        EventSelectorValueSource.addGetter(messageGetters, "JMSTimestamp", (message, expression) -> message.getTimestamp().getTime());
    }

    private static interface ImmutableEventDatagramFieldGetter
    extends FieldGetter<ImmutableEventDatagram> {
        @Override
        public Object get(ImmutableEventDatagram var1, EventSelectorValueSource var2);
    }

    private static interface FieldGetter<T> {
        public Object get(T var1, EventSelectorValueSource var2);
    }

    private static interface OpaqueDatagramFieldGetter
    extends FieldGetter<OpaqueDatagram> {
        @Override
        public Object get(OpaqueDatagram var1, EventSelectorValueSource var2);
    }

    private static interface EventDatagramFieldGetter
    extends FieldGetter<EventDatagram> {
        @Override
        public Object get(EventDatagram var1, EventSelectorValueSource var2);
    }

    private static interface AdvisoryEventDatagramFieldGetter
    extends FieldGetter<AdvisoryEventDatagram> {
        @Override
        public Object get(AdvisoryEventDatagram var1, EventSelectorValueSource var2);
    }

    private static interface ModeratorAdvisoryFieldGetter
    extends FieldGetter<FabricModeratorAdvisory> {
        @Override
        public Object get(FabricModeratorAdvisory var1, EventSelectorValueSource var2);
    }

    private static interface ExchangeAdvisoryFieldGetter
    extends FieldGetter<FabricExchangeAdvisory> {
        @Override
        public Object get(FabricExchangeAdvisory var1, EventSelectorValueSource var2);
    }

    private static interface SchedulerAdvisoryFieldGetter
    extends FieldGetter<SchedulerAdvisory> {
        @Override
        public Object get(SchedulerAdvisory var1, EventSelectorValueSource var2);
    }

    private static interface CoherenceAdvisoryFieldGetter
    extends FieldGetter<CoherenceAgentAdvisory> {
        @Override
        public Object get(CoherenceAgentAdvisory var1, EventSelectorValueSource var2);
    }

    private static interface ComponentAdvisoryFieldGetter
    extends FieldGetter<ComponentStateChangeAdvisory> {
        @Override
        public Object get(ComponentStateChangeAdvisory var1, EventSelectorValueSource var2);
    }

    private static interface AccessorAdvisoryFieldGetter
    extends FieldGetter<FabricComponentAccessorAdvisory> {
        @Override
        public Object get(FabricComponentAccessorAdvisory var1, EventSelectorValueSource var2);
    }

    private static interface StateAdvisoryFieldGetter
    extends FieldGetter<StateAdvisory> {
        @Override
        public Object get(StateAdvisory var1, EventSelectorValueSource var2);
    }

    private static interface ReplicaAdvisoryFieldGetter
    extends FieldGetter<AbstractReplicationAdvisory> {
        @Override
        public Object get(AbstractReplicationAdvisory var1, EventSelectorValueSource var2);
    }

    private static interface ReplicaStateAdvisoryFieldGetter
    extends FieldGetter<ReplicaStateChangeAdvisory> {
        @Override
        public Object get(ReplicaStateChangeAdvisory var1, EventSelectorValueSource var2);
    }

    private static interface ReplicationExceptionAdvisoryFieldGetter
    extends FieldGetter<ReplicationExceptionAdvisory> {
        @Override
        public Object get(ReplicationExceptionAdvisory var1, EventSelectorValueSource var2);
    }

    private static interface ReplicaTimeoutAdvisoryFieldGetter
    extends FieldGetter<ReplicaTimeoutAdvisory> {
        @Override
        public Object get(ReplicaTimeoutAdvisory var1, EventSelectorValueSource var2);
    }

    private static interface ReplicationSourceMetricAdvisoryFieldGetter
    extends FieldGetter<ReplicationSourceMetricAdvisory> {
        @Override
        public Object get(ReplicationSourceMetricAdvisory var1, EventSelectorValueSource var2);
    }

    private static interface ReplicaMetricAdvisoryFieldGetter
    extends FieldGetter<ReplicaMetricAdvisory> {
        @Override
        public Object get(ReplicaMetricAdvisory var1, EventSelectorValueSource var2);
    }

    private static interface VirtualServerAdvisoryFieldGetter
    extends FieldGetter<VirtualServerStateChangeAdvisory> {
        @Override
        public Object get(VirtualServerStateChangeAdvisory var1, EventSelectorValueSource var2);
    }

    private static interface DaemonServiceBlockedAdvisoryFieldGetter
    extends FieldGetter<DaemonServiceBlockedAdvisory> {
        @Override
        public Object get(DaemonServiceBlockedAdvisory var1, EventSelectorValueSource var2);
    }

    private static interface ExceptionEventDatagramFieldGetter
    extends FieldGetter<ExceptionEventDatagram> {
        @Override
        public Object get(ExceptionEventDatagram var1, EventSelectorValueSource var2);
    }

    private static interface MessageFieldGetter
    extends FieldGetter<Message> {
        @Override
        public Object get(Message var1, EventSelectorValueSource var2);
    }

    private static interface MetricAdvisoryFieldGetter
    extends FieldGetter<MetricAdvisory> {
        @Override
        public Object get(MetricAdvisory var1, EventSelectorValueSource var2);
    }
}

