/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.selector;

import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.lib.selector.parser.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ConstantSelectorExpression
extends SelectorExpression {
    public static final ConstantSelectorExpression NULL = new ConstantSelectorExpression(null);
    public static final ConstantSelectorExpression TRUE = new ConstantSelectorExpression(true);
    public static final ConstantSelectorExpression FALSE = new ConstantSelectorExpression(false);
    static SimpleDateFormat[] dateFormats = new SimpleDateFormat[]{new SimpleDateFormat("MM/dd/yy hh:mm:ss.SSS"), new SimpleDateFormat("dd.MM.yy hh:mm:ss.SSS"), new SimpleDateFormat("MM/dd/yyyy hh:mm:ss.SSS"), new SimpleDateFormat("dd.MM.yyyy hh:mm:ss.SSS")};
    private Object value = null;

    public static ConstantSelectorExpression createExpression_String(String literal) {
        return new ConstantSelectorExpression(literal);
    }

    public static ConstantSelectorExpression createExpression_Decimal(String literal) {
        if (literal.endsWith("l") || literal.endsWith("L")) {
            literal = literal.substring(0, literal.length() - 1);
        }
        return new ConstantSelectorExpression(Long.parseLong(literal, 10));
    }

    public static ConstantSelectorExpression createExpression_Hex(String literal) {
        return new ConstantSelectorExpression(Long.parseLong(literal.substring(2), 16));
    }

    public static ConstantSelectorExpression createExpression_Octal(String literal) {
        return new ConstantSelectorExpression(Long.parseLong(literal, 8));
    }

    public static ConstantSelectorExpression createExpression_FloatingPoint(String literal) {
        if (literal.endsWith("f") || literal.endsWith("F")) {
            return new ConstantSelectorExpression(Float.valueOf(Float.parseFloat(literal)));
        }
        return new ConstantSelectorExpression(Double.parseDouble(literal));
    }

    public static ConstantSelectorExpression createExpression_DateTime(String literal) throws ParseException {
        for (SimpleDateFormat format : dateFormats) {
            try {
                Date date = format.parse(literal);
                return new ConstantSelectorExpression(date.getTime());
            }
            catch (java.text.ParseException parseException) {
            }
        }
        throw new ParseException("Invalid date format: '" + literal + "'.");
    }

    ConstantSelectorExpression(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    protected Object evaluate(Object object) {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return "NULL";
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? "TRUE" : "FALSE";
        }
        if (this.value instanceof String) {
            return (String)this.value;
        }
        return this.value.toString();
    }
}

