/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.selector;

import com.streamscape.lib.selector.SelectorExpression;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public abstract class BinarySelectorExpression
extends SelectorExpression {
    protected SelectorExpression leftOperand;
    protected SelectorExpression rightOperand;
    private static final MathContext ROUND = new MathContext(MathContext.DECIMAL64.getPrecision(), RoundingMode.DOWN);
    private static final String[] NULLS = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000", "00000000000", "000000000000", "0000000000000", "00000000000000", "000000000000000", "0000000000000000"};

    public BinarySelectorExpression(SelectorExpression leftOperand, SelectorExpression rightOperand) {
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
    }

    protected abstract String getOperator();

    protected static BigDecimal convert(Number value) {
        if (value instanceof BigDecimal) {
            return BinarySelectorExpression.addNulls(((BigDecimal)value).round(ROUND));
        }
        if (value instanceof Double) {
            return BinarySelectorExpression.addNulls(BigDecimal.valueOf((Double)value).round(ROUND));
        }
        if (value instanceof Float) {
            return BinarySelectorExpression.addNulls(BigDecimal.valueOf(((Float)value).floatValue()).round(ROUND));
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return BinarySelectorExpression.addNulls(new BigDecimal(value.longValue()).round(ROUND));
        }
        return null;
    }

    private static BigDecimal addNulls(BigDecimal result) {
        if (result.precision() >= ROUND.getPrecision()) {
            return result;
        }
        return new BigDecimal(result.toPlainString() + NULLS[ROUND.getPrecision() - result.precision()]);
    }

    public String toString() {
        return String.valueOf(this.leftOperand) + " " + this.getOperator() + " " + String.valueOf(this.rightOperand);
    }
}

