/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.selector;

import com.streamscape.lib.selector.ArithmeticalSelectorExpression;
import com.streamscape.lib.selector.SelectorExpression;
import java.math.BigDecimal;

class ArithmeticalSelectorExpression_Division
extends ArithmeticalSelectorExpression {
    ArithmeticalSelectorExpression_Division(SelectorExpression leftOperand, SelectorExpression rightOperand) {
        super(leftOperand, rightOperand);
    }

    @Override
    protected Object evaluate(Object leftValue, Object rightValue) {
        return leftValue instanceof Number && rightValue instanceof Number ? (Number)ArithmeticalSelectorExpression_Division.doDivision((Number)leftValue, (Number)rightValue) : (Number)null;
    }

    @Override
    protected String getOperator() {
        return "/";
    }

    private static Number doDivision(Number leftValue, Number rightValue) {
        if (leftValue instanceof BigDecimal || rightValue instanceof BigDecimal) {
            BigDecimal convertedRightValue = ArithmeticalSelectorExpression_Division.convert(rightValue);
            return convertedRightValue.doubleValue() != 0.0 ? ArithmeticalSelectorExpression_Division.convert(leftValue).divide(convertedRightValue) : null;
        }
        if (leftValue instanceof Float || rightValue instanceof Float) {
            return rightValue.floatValue() != 0.0f ? Float.valueOf(leftValue.floatValue() / rightValue.floatValue()) : null;
        }
        if (leftValue instanceof Double || rightValue instanceof Double) {
            return rightValue.doubleValue() != 0.0 ? Double.valueOf(leftValue.doubleValue() / rightValue.doubleValue()) : null;
        }
        return rightValue.longValue() != 0L ? Long.valueOf(leftValue.longValue() / rightValue.longValue()) : null;
    }
}

