/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.selector;

import com.streamscape.lib.selector.ArithmeticalSelectorExpression;
import com.streamscape.lib.selector.SelectorExpression;
import java.math.BigDecimal;

class ArithmeticalSelectorExpression_Addition
extends ArithmeticalSelectorExpression {
    ArithmeticalSelectorExpression_Addition(SelectorExpression leftOperand, SelectorExpression rightOperand) {
        super(leftOperand, rightOperand);
    }

    @Override
    protected Object evaluate(Object leftValue, Object rightValue) {
        if (leftValue instanceof Number && rightValue instanceof Number) {
            return ArithmeticalSelectorExpression_Addition.doAddition((Number)leftValue, (Number)rightValue);
        }
        if (leftValue instanceof String && rightValue instanceof String) {
            return (String)leftValue + String.valueOf(rightValue);
        }
        return null;
    }

    @Override
    protected String getOperator() {
        return "+";
    }

    private static Number doAddition(Number leftValue, Number rightValue) {
        if (leftValue instanceof BigDecimal || rightValue instanceof BigDecimal) {
            return ArithmeticalSelectorExpression_Addition.convert(leftValue).add(ArithmeticalSelectorExpression_Addition.convert(rightValue));
        }
        if (leftValue instanceof Float || rightValue instanceof Float) {
            return Float.valueOf(leftValue.floatValue() + rightValue.floatValue());
        }
        if (leftValue instanceof Double || rightValue instanceof Double) {
            return leftValue.doubleValue() + rightValue.doubleValue();
        }
        return leftValue.longValue() + rightValue.longValue();
    }
}

