/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.reflection.creator;

import com.streamscape.lib.reflection.ObjectAccessException;
import com.streamscape.lib.reflection.ReflectionProvider;
import com.streamscape.lib.reflection.SunReflectionProvider;
import com.streamscape.lib.reflection.creator.ObjectCreatorException;
import com.streamscape.lib.utils.SemanticTypeResolver;
import com.streamscape.omf.json.utils.MemoryRefStack;
import com.streamscape.omf.json.utils.TypeUtils;
import com.streamscape.runtime.mf.operation.edl.annotations.Default;
import com.streamscape.runtime.mf.operation.edl.annotations.SemanticType;
import com.streamscape.runtime.mf.operation.edl.annotations.SemanticType1;
import com.streamscape.runtime.mf.operation.edl.annotations.SemanticType2;
import com.streamscape.sef.evtrigger.function.types.EnumType;
import com.streamscape.slex.lang.parameter.BinaryParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectCreator {
    protected static Map<Class<?>, DefaultPrimitiveCreator> primitiveDefaults = new ConcurrentHashMap();
    private MemoryRefStack<Class<?>> parentsStack;
    protected SemanticTypeResolver semanticTypeResolver;
    protected ReflectionProvider reflectionProvider;

    protected ObjectCreator(SemanticTypeResolver semanticTypeResolver) {
        this(semanticTypeResolver, new SunReflectionProvider());
    }

    protected ObjectCreator(SemanticTypeResolver semanticTypeResolver, ReflectionProvider reflectionProvider) {
        this.semanticTypeResolver = semanticTypeResolver;
        this.reflectionProvider = reflectionProvider;
    }

    public synchronized Object createDefaultObject(String semanticType) throws ObjectCreatorException {
        return this.createDefaultObject(this.resolveSemanticType(semanticType));
    }

    public synchronized Object createDefaultObject(Type type) throws ObjectCreatorException {
        this.parentsStack = new MemoryRefStack();
        return this.createObject(type);
    }

    private Object createObject(Type type) throws ObjectCreatorException {
        return this.createObject(type, null);
    }

    private Object createObject(Type type, Field field) throws ObjectCreatorException {
        try {
            Class<Object> clazz = TypeUtils.toRawClass(type);
            if (this.parentsStack.contains(clazz)) {
                return null;
            }
            Object instance = this.createBasicObject(type, field);
            if (instance != null) {
                return instance;
            }
            if (clazz.isAssignableFrom(Object.class) || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                return null;
            }
            instance = this.createInstance(clazz);
            if (instance == null) {
                return null;
            }
            this.parentsStack.push(clazz);
            try {
                for (Field classField : this.getClassFields(clazz)) {
                    if (Modifier.isStatic(classField.getModifiers()) || Modifier.isTransient(classField.getModifiers())) continue;
                    classField.setAccessible(true);
                    Type fieldType = classField.getGenericType();
                    Object value = classField.get(instance);
                    if (value == null) {
                        value = this.createObject(fieldType, classField);
                        if (value == null) continue;
                        classField.set(instance, value);
                        continue;
                    }
                    if (ObjectCreator.isCollection(type)) {
                        this.fillCollection(value, fieldType, classField, 0);
                        classField.set(instance, value);
                    }
                    if (!ObjectCreator.isArray(type)) continue;
                    this.fillArray(value, type, field);
                    classField.set(instance, value);
                }
            }
            catch (NoClassDefFoundError exception) {
                throw new ObjectCreatorException(type, "Class not found: " + exception.getMessage());
            }
            catch (IllegalArgumentException exception) {
                throw new ObjectCreatorException(type, "Illegal argument exception: " + exception.getMessage());
            }
            catch (IllegalAccessException exception) {
                throw new ObjectCreatorException(type, "Illegal access exception: " + exception.getMessage());
            }
            finally {
                this.parentsStack.pop();
            }
            return instance;
        }
        catch (IllegalArgumentException exception) {
            throw new ObjectCreatorException(type, "Illegal argument exception: " + exception.getMessage());
        }
        catch (IllegalAccessException exception) {
            throw new ObjectCreatorException(type, "Illegal access exception: " + exception.getMessage());
        }
        catch (InstantiationException exception) {
            throw new ObjectCreatorException(type, "Instantiation exception: " + exception.getMessage());
        }
        catch (ObjectAccessException exception) {
            throw new ObjectCreatorException(type, "Object access exception: " + exception.getMessage());
        }
    }

    public static boolean isBasic(Type type) {
        return ObjectCreator.isPrimitive(type) || ObjectCreator.isCollection(type) || TypeUtils.toRawClass(type).isEnum() || ObjectCreator.isArray(type);
    }

    private Object createBasicObject(Type type, Field field) throws InstantiationException, IllegalAccessException, ObjectCreatorException {
        Class clazz;
        if (type instanceof Class && (clazz = (Class)type).getAnnotation(com.streamscape.runtime.mf.operation.edl.annotations.Enum.class) != null) {
            for (Field dfield : clazz.getDeclaredFields()) {
                if (!Modifier.isStatic(dfield.getModifiers())) continue;
                return dfield.getName();
            }
            return "";
        }
        Object object = ObjectCreator.createPrimitive(type, field);
        if (object == null) {
            object = this.createCollection(type, field);
        }
        if (object == null) {
            object = ObjectCreator.createEnum(type, field);
        }
        if (object == null) {
            object = this.createArray(type, field);
        }
        return object;
    }

    public static boolean isPrimitive(Type type) {
        return primitiveDefaults.containsKey(TypeUtils.toRawClass(type));
    }

    private static Object createPrimitive(Type type, Field field) {
        DefaultPrimitiveCreator primitive = primitiveDefaults.get(TypeUtils.toRawClass(type));
        if (primitive != null) {
            return primitive.create(ObjectCreator.getDefaultValueAnnotation(field));
        }
        return null;
    }

    private static Object createEnum(Type type, Field field) {
        Class<?> rawClass = TypeUtils.toRawClass(type);
        if (rawClass.isEnum()) {
            String defaultValue = ObjectCreator.getDefaultValueAnnotation(field);
            if (defaultValue != null) {
                try {
                    return Enum.valueOf(rawClass, defaultValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return rawClass.getEnumConstants()[0];
        }
        return null;
    }

    private static String getDefaultValueAnnotation(Field field) {
        if (field == null) {
            return null;
        }
        Default annotation = field.getAnnotation(Default.class);
        if (annotation != null) {
            return annotation.value();
        }
        return null;
    }

    private static String[] getDefaultValuesAnnotation(Field field) {
        if (field == null) {
            return null;
        }
        Default annotation = field.getAnnotation(Default.class);
        if (annotation != null) {
            return annotation.values();
        }
        return null;
    }

    public static boolean isCollection(Type type) {
        Class<?> rawClass = TypeUtils.toRawClass(type);
        return Collection.class.isAssignableFrom(rawClass) || Map.class.isAssignableFrom(rawClass);
    }

    private Object createCollection(Type type, Field field) throws InstantiationException, IllegalAccessException, ObjectCreatorException {
        Class<?> rawClass = TypeUtils.toRawClass(type);
        if (Collection.class.isAssignableFrom(rawClass) || Map.class.isAssignableFrom(rawClass)) {
            Cloneable object = null;
            if (!rawClass.isInterface()) {
                object = (Cloneable)rawClass.newInstance();
            } else if (Map.class.isAssignableFrom(rawClass)) {
                object = new HashMap();
            } else if (List.class.isAssignableFrom(rawClass)) {
                object = new ArrayList();
            } else if (Queue.class.isAssignableFrom(rawClass)) {
                object = new LinkedList();
            } else if (Set.class.isAssignableFrom(rawClass)) {
                object = new HashSet();
            }
            if (object != null) {
                this.fillCollection(object, type, field, 0);
            }
            return object;
        }
        return null;
    }

    private void fillCollection(Object object, Type type, Field field, int level) throws ObjectCreatorException {
        Class<?> rawClass = TypeUtils.toRawClass(type);
        if (Collection.class.isAssignableFrom(rawClass) || Map.class.isAssignableFrom(rawClass)) {
            Object type2;
            Type[] arguments = null;
            if (type instanceof ParameterizedType) {
                arguments = ((ParameterizedType)type).getActualTypeArguments();
            }
            if (field != null) {
                Annotation annotation;
                String type1 = null;
                type2 = null;
                if (level == 0) {
                    annotation = field.getAnnotation(SemanticType.class);
                    if (annotation != null) {
                        type1 = annotation.type();
                        type2 = annotation.type1();
                    }
                } else if (level == 1) {
                    annotation = field.getAnnotation(SemanticType1.class);
                    if (annotation != null) {
                        type1 = ((SemanticType1)annotation).type();
                        type2 = ((SemanticType1)annotation).type1();
                    }
                } else if (level == 2 && (annotation = field.getAnnotation(SemanticType2.class)) != null) {
                    type1 = ((SemanticType2)annotation).type();
                    type2 = ((SemanticType2)annotation).type1();
                }
                if (type1 != null && type1.length() > 0) {
                    if (type2 != null && ((String)type2).length() > 0) {
                        arguments = new Type[2];
                        arguments[1] = this.resolveSemanticType((String)type2);
                    } else {
                        arguments = new Type[]{this.resolveSemanticType(type1)};
                    }
                }
            }
            if (arguments == null) {
                Object genericSuperType = null;
                if (this.isGenericSuperclassIsTheSameAsMainClass(rawClass, rawClass.getGenericSuperclass())) {
                    genericSuperType = rawClass.getGenericSuperclass();
                }
                if (genericSuperType == null) {
                    type2 = rawClass.getGenericInterfaces();
                    int n = ((Type[])type2).length;
                    for (int i = 0; i < n; ++i) {
                        Object t = type2[i];
                        if (!this.isGenericSuperclassIsTheSameAsMainClass(rawClass, (Type)t)) continue;
                        genericSuperType = t;
                        break;
                    }
                }
                if (genericSuperType instanceof ParameterizedType) {
                    arguments = ((ParameterizedType)genericSuperType).getActualTypeArguments();
                }
            }
            if (arguments == null) {
                return;
            }
            if (TypeUtils.toRawClass(arguments[0]).isAssignableFrom(Object.class)) {
                return;
            }
            if (Map.class.isAssignableFrom(rawClass)) {
                Object key = this.createObject(arguments[0]);
                value = this.createObject(arguments[1]);
                if (key instanceof String) {
                    key = "key";
                }
                if (value instanceof String) {
                    value = "value";
                }
                ((Map)object).put(key, value);
                if (value != null) {
                    this.fillCollection(value, value.getClass(), field, level + 1);
                }
            } else if (List.class.isAssignableFrom(rawClass)) {
                String[] defaultValues = ObjectCreator.getDefaultValuesAnnotation(field);
                if (defaultValues != null && defaultValues.length > 0 && (ObjectCreator.isPrimitive(arguments[0]) || arguments[0] == byte[].class || arguments[0] == Byte[].class)) {
                    for (String defaultValue : defaultValues) {
                        if (arguments[0] == byte[].class || arguments[0] == Byte[].class) {
                            ((List)object).add(this.createByteArrayWithDefaults(defaultValue));
                            continue;
                        }
                        DefaultPrimitiveCreator primitive = primitiveDefaults.get(TypeUtils.toRawClass(arguments[0]));
                        if (primitive == null) continue;
                        ((List)object).add(primitive.create(defaultValue));
                    }
                } else {
                    value = this.createObject(arguments[0]);
                    ((List)object).add(value);
                    if (value != null) {
                        this.fillCollection(value, value.getClass(), field, level + 1);
                    }
                }
            } else if (Queue.class.isAssignableFrom(rawClass)) {
                ((Queue)object).add(this.createObject(arguments[0]));
            } else if (Set.class.isAssignableFrom(rawClass)) {
                ((Set)object).add(this.createObject(arguments[0]));
            }
        }
    }

    boolean isGenericSuperclassIsTheSameAsMainClass(Class<?> mainClass, Type genericSuperclass) {
        return genericSuperclass != null && genericSuperclass instanceof ParameterizedType && (Collection.class.isAssignableFrom(mainClass) && Collection.class.isAssignableFrom(TypeUtils.toRawClass(genericSuperclass)) || Map.class.isAssignableFrom(mainClass) && Map.class.isAssignableFrom(TypeUtils.toRawClass(genericSuperclass)));
    }

    public static boolean isArray(Type type) {
        return TypeUtils.isArray(type);
    }

    private Object createArray(Type type, Field field) throws ObjectCreatorException {
        Class<?> rawClass = TypeUtils.toRawClass(type);
        Object array = null;
        if (rawClass.isArray()) {
            if (rawClass.getComponentType() == Byte.TYPE) {
                String defaultValue = ObjectCreator.getDefaultValueAnnotation(field);
                if (defaultValue != null && defaultValue.length() > 0) {
                    array = this.createByteArrayWithDefaults(defaultValue);
                }
            } else {
                String[] defaultValues = ObjectCreator.getDefaultValuesAnnotation(field);
                if (defaultValues != null && defaultValues.length > 0) {
                    array = Array.newInstance(rawClass.getComponentType(), defaultValues.length);
                    DefaultPrimitiveCreator primitive = primitiveDefaults.get(TypeUtils.toRawClass(rawClass.getComponentType()));
                    for (int index = 0; index < defaultValues.length; ++index) {
                        if (rawClass.getComponentType() == byte[].class) {
                            Array.set(array, index, this.createByteArrayWithDefaults(defaultValues[index]));
                            continue;
                        }
                        if (primitive != null) {
                            Array.set(array, index, primitive.create(defaultValues[index]));
                            continue;
                        }
                        if (!rawClass.getComponentType().isEnum() || defaultValues[index] == null) continue;
                        try {
                            defaultValues[index] = EnumType.getEnumWithoutType(defaultValues[index]);
                            Array.set(array, index, Enum.valueOf(rawClass.getComponentType(), defaultValues[index]));
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if (array == null) {
                array = Array.newInstance(rawClass.getComponentType(), 1);
                this.fillArray(array, type, field);
            }
        }
        return array;
    }

    private Object createByteArrayWithDefaults(String defaultValue) {
        byte[] bytes;
        Object array = null;
        if (defaultValue != null && defaultValue.length() > 0 && (bytes = BinaryParameter.convertStringToByteArray(defaultValue)) != null && bytes.length > 0) {
            array = Array.newInstance(Byte.TYPE, bytes.length);
            for (int index = 0; index < bytes.length; ++index) {
                Array.set(array, index, bytes[index]);
            }
        }
        return array;
    }

    private void fillArray(Object object, Type type, Field field) throws ObjectCreatorException {
        Class<?> rawClass = TypeUtils.toRawClass(type);
        Class<?> arrayElementType = rawClass.getComponentType();
        Object arrayElementValue = this.createObject(arrayElementType);
        Array.set(object, 0, arrayElementValue);
    }

    private List<Field> getClassFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        return this.getClassFields(clazz, fields);
    }

    private Class<?> resolveSemanticType(String semanticType) throws ObjectCreatorException {
        try {
            if (semanticType.endsWith("[]")) {
                return Array.newInstance(this.resolveSemanticType(semanticType.substring(0, semanticType.length() - 2)), 1).getClass();
            }
            return this.semanticTypeResolver.resolveSemanticType(semanticType);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectCreatorException(semanticType, "Class not found: " + e.getMessage());
        }
    }

    private List<Field> getClassFields(Class<?> clazz, List<Field> fields) {
        Collections.addAll(fields, clazz.getDeclaredFields());
        if (clazz.getSuperclass() != null) {
            fields = this.getClassFields(clazz.getSuperclass(), fields);
        }
        return fields;
    }

    private Object createInstance(Class<?> clazz) throws ObjectAccessException {
        return this.reflectionProvider.newInstance(clazz);
    }

    static {
        primitiveDefaults.put(Boolean.TYPE, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Boolean(false);
            }

            @Override
            public Object onCreate(String value) {
                return Boolean.valueOf(value);
            }
        });
        primitiveDefaults.put(Byte.TYPE, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Byte(0);
            }

            @Override
            public Object onCreate(String value) {
                return Byte.valueOf(value);
            }
        });
        primitiveDefaults.put(Character.TYPE, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Character('\u0000');
            }

            @Override
            public Object onCreate(String value) {
                if (value.length() > 0) {
                    return Character.valueOf(value.charAt(0));
                }
                return this.create();
            }
        });
        primitiveDefaults.put(Integer.TYPE, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Integer(0);
            }

            @Override
            public Object onCreate(String value) {
                return Integer.valueOf(value);
            }
        });
        primitiveDefaults.put(Short.TYPE, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Short(0);
            }

            @Override
            public Object onCreate(String value) {
                return Short.valueOf(value);
            }
        });
        primitiveDefaults.put(Long.TYPE, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Long(0L);
            }

            @Override
            public Object onCreate(String value) {
                value = value.endsWith("l") || value.endsWith("L") ? value.substring(0, value.length() - 1) : value;
                return Long.valueOf(value);
            }
        });
        primitiveDefaults.put(Double.TYPE, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Double(0.0);
            }

            @Override
            public Object onCreate(String value) {
                value = value.endsWith("d") || value.endsWith("D") ? value.substring(0, value.length() - 1) : value;
                return Double.valueOf(value);
            }
        });
        primitiveDefaults.put(Float.TYPE, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Float(0.0f);
            }

            @Override
            public Object onCreate(String value) {
                value = value.endsWith("f") || value.endsWith("F") ? value.substring(0, value.length() - 1) : value;
                return Float.valueOf(value);
            }
        });
        primitiveDefaults.put(Boolean.class, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Boolean(false);
            }

            @Override
            public Object onCreate(String value) {
                return Boolean.valueOf(value);
            }
        });
        primitiveDefaults.put(Byte.class, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Byte(0);
            }

            @Override
            public Object onCreate(String value) {
                return Byte.valueOf(value);
            }
        });
        primitiveDefaults.put(Character.class, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Character('\u0000');
            }

            @Override
            public Object onCreate(String value) {
                if (value.length() > 0) {
                    return Character.valueOf(value.charAt(0));
                }
                return this.create();
            }
        });
        primitiveDefaults.put(Integer.class, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Integer(0);
            }

            @Override
            public Object onCreate(String value) {
                return Integer.valueOf(value);
            }
        });
        primitiveDefaults.put(Short.class, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Short(0);
            }

            @Override
            public Object onCreate(String value) {
                return Short.valueOf(value);
            }
        });
        primitiveDefaults.put(Long.class, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Long(0L);
            }

            @Override
            public Object onCreate(String value) {
                value = value.endsWith("l") || value.endsWith("L") ? value.substring(0, value.length() - 1) : value;
                return Long.valueOf(value);
            }
        });
        primitiveDefaults.put(Double.class, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Double(0.0);
            }

            @Override
            public Object onCreate(String value) {
                value = value.endsWith("d") || value.endsWith("D") ? value.substring(0, value.length() - 1) : value;
                return Double.valueOf(value);
            }
        });
        primitiveDefaults.put(Float.class, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Float(0.0f);
            }

            @Override
            public Object onCreate(String value) {
                value = value.endsWith("f") || value.endsWith("F") ? value.substring(0, value.length() - 1) : value;
                return Float.valueOf(value);
            }
        });
        primitiveDefaults.put(BigDecimal.class, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new BigDecimal(0);
            }

            @Override
            public Object onCreate(String value) {
                return BigDecimal.valueOf(Long.valueOf(value));
            }
        });
        primitiveDefaults.put(BigInteger.class, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return BigInteger.valueOf(0L);
            }

            @Override
            public Object onCreate(String value) {
                return BigInteger.valueOf(Long.valueOf(value));
            }
        });
        primitiveDefaults.put(String.class, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new String("");
            }

            @Override
            public Object onCreate(String value) {
                return value;
            }
        });
        primitiveDefaults.put(java.util.Date.class, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new java.util.Date(0L);
            }

            @Override
            public Object onCreate(String value) {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(value);
                }
                catch (Exception e) {
                    return this.create();
                }
            }
        });
        primitiveDefaults.put(Date.class, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Date(0L);
            }

            @Override
            public Object onCreate(String value) {
                return Date.valueOf(value);
            }
        });
        primitiveDefaults.put(Timestamp.class, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Timestamp(0L);
            }

            @Override
            public Object onCreate(String value) {
                return Timestamp.valueOf(value);
            }
        });
        primitiveDefaults.put(Time.class, new DefaultPrimitiveCreator(){

            @Override
            public Object create() {
                return new Time(0L);
            }

            @Override
            public Object onCreate(String value) {
                return Time.valueOf(value);
            }
        });
    }

    static abstract class DefaultPrimitiveCreator {
        DefaultPrimitiveCreator() {
        }

        abstract Object create();

        abstract Object onCreate(String var1);

        Object create(String value) {
            try {
                if (value != null) {
                    return this.onCreate(value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.create();
        }
    }
}

