/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.reflection;

import com.streamscape.lib.reflection.ClassFieldCache;
import com.streamscape.lib.reflection.ImmutableFieldSorter;
import com.streamscape.lib.reflection.ObjectAccessException;
import com.streamscape.lib.reflection.ReflectionProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GenericReflectionProvider
extends ReflectionProvider {
    private transient Map serializedDataCache = Collections.synchronizedMap(new HashMap());
    protected ClassFieldCache fieldDictionary;

    private static float getMajorJavaVersion() {
        try {
            return Float.parseFloat(System.getProperty("java.specification.version"));
        }
        catch (NumberFormatException e) {
            return 1.4f;
        }
    }

    private static boolean isJDK15() {
        return GenericReflectionProvider.getMajorJavaVersion() >= 1.5f;
    }

    private static boolean isJDK16() {
        return GenericReflectionProvider.getMajorJavaVersion() >= 1.6f;
    }

    public GenericReflectionProvider() {
        this(new ClassFieldCache(new ImmutableFieldSorter()));
    }

    public GenericReflectionProvider(ClassFieldCache fieldDictionary) {
        this.fieldDictionary = fieldDictionary;
    }

    @Override
    public Object newInstance(Class type) throws ObjectAccessException {
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = type.getDeclaredConstructors()) {
                if (constructor.getParameterTypes().length != 0) continue;
                if (!Modifier.isPublic(constructor.getModifiers())) {
                    constructor.setAccessible(true);
                }
                return constructor.newInstance(new Object[0]);
            }
            if (Serializable.class.isAssignableFrom(type)) {
                return this.instantiateUsingSerialization(type);
            }
            throw new ObjectAccessException("Cannot construct " + type.getName() + " as it does not have a no-args constructor");
        }
        catch (InstantiationException e) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new ObjectAccessException("Constructor for " + type.getName() + " threw an exception", e.getTargetException());
        }
    }

    private Object instantiateUsingSerialization(Class type) throws ObjectAccessException {
        try {
            byte[] data;
            if (this.serializedDataCache.containsKey(type)) {
                data = (byte[])this.serializedDataCache.get(type);
            } else {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                DataOutputStream stream = new DataOutputStream(bytes);
                stream.writeShort(-21267);
                stream.writeShort(5);
                stream.writeByte(115);
                stream.writeByte(114);
                stream.writeUTF(type.getName());
                stream.writeLong(ObjectStreamClass.lookup(type).getSerialVersionUID());
                stream.writeByte(2);
                stream.writeShort(0);
                stream.writeByte(120);
                stream.writeByte(112);
                data = bytes.toByteArray();
                this.serializedDataCache.put(type, data);
            }
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
            return in.readObject();
        }
        catch (IOException e) {
            throw new ObjectAccessException("Cannot create " + type.getName() + " by JDK serialization", e);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectAccessException("Cannot find class " + e.getMessage());
        }
    }

    @Override
    public void visitSerializableFields(Class type, ReflectionProvider.FieldVisitor visitor) throws ObjectAccessException {
        Iterator iterator = this.fieldDictionary.fieldsFor(type);
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!this.fieldModifiersSupported(field)) continue;
            this.validateFieldAccess(field);
            try {
                visitor.visit(field.getName(), field.getType());
            }
            catch (IllegalArgumentException exception) {
                throw new ObjectAccessException("Could not get field " + String.valueOf(field.getClass()) + "." + field.getName(), exception);
            }
        }
    }

    @Override
    public void visitSerializableFields(Object object, ReflectionProvider.FieldVisitor visitor) throws ObjectAccessException {
        Iterator iterator = this.fieldDictionary.fieldsFor(object.getClass());
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!this.fieldModifiersSupported(field)) continue;
            this.validateFieldAccess(field);
            try {
                Object value = field.get(object);
                visitor.visit(field.getName(), field.getType(), value, field.getDeclaringClass());
            }
            catch (IllegalArgumentException exception) {
                throw new ObjectAccessException("Could not get field " + String.valueOf(field.getClass()) + "." + field.getName(), exception);
            }
            catch (IllegalAccessException exception) {
                throw new ObjectAccessException("Could not get field " + String.valueOf(field.getClass()) + "." + field.getName(), exception);
            }
        }
    }

    @Override
    public void writeField(Object object, String fieldName, Object value, Class definedIn) throws ObjectAccessException {
        Field field = this.fieldDictionary.field(object.getClass(), fieldName, definedIn);
        this.validateFieldAccess(field);
        try {
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectAccessException("Could not set field " + String.valueOf(object.getClass()) + "." + field.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectAccessException("Could not set field " + String.valueOf(object.getClass()) + "." + field.getName(), e);
        }
    }

    @Override
    public Class getFieldType(Object object, String fieldName, Class definedIn) throws ObjectAccessException {
        return this.fieldDictionary.field(object.getClass(), fieldName, definedIn).getType();
    }

    @Override
    public boolean fieldDefinedInClass(String fieldName, Class type) throws ObjectAccessException {
        try {
            Field field = this.fieldDictionary.field(type, fieldName, null);
            return this.fieldModifiersSupported(field) || Modifier.isTransient(field.getModifiers());
        }
        catch (ObjectAccessException e) {
            return false;
        }
    }

    protected boolean fieldModifiersSupported(Field field) {
        return !Modifier.isStatic(field.getModifiers()) && !Modifier.isTransient(field.getModifiers());
    }

    protected void validateFieldAccess(Field field) throws ObjectAccessException {
        if (Modifier.isFinal(field.getModifiers())) {
            if (GenericReflectionProvider.isJDK15()) {
                field.setAccessible(true);
            } else {
                throw new ObjectAccessException("Invalid final field " + field.getDeclaringClass().getName() + "." + field.getName());
            }
        }
    }

    @Override
    public Field getField(Class definedIn, String fieldName) throws ObjectAccessException {
        return this.fieldDictionary.field(definedIn, fieldName, null);
    }

    public void setFieldDictionary(ClassFieldCache dictionary) {
        this.fieldDictionary = dictionary;
    }

    protected Object readResolve() {
        this.serializedDataCache = Collections.synchronizedMap(new HashMap());
        return this;
    }
}

