/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.numalloc;

import com.streamscape.lib.numalloc.NumberAllocatorException;
import com.streamscape.sdo.CloneableDataObject;
import java.util.TreeSet;

public abstract class NumberAllocator
extends CloneableDataObject {
    private Long currentNumber = 1L;
    private TreeSet<Long> freeNumbers = new TreeSet();
    private Long maxNumber;

    public NumberAllocator(long maxNumber) {
        this.maxNumber = maxNumber;
    }

    public NumberAllocator(Long startNumber, int maxValue) {
        this(maxValue);
        this.currentNumber = startNumber;
    }

    public void clear() {
        this.currentNumber = 1L;
        this.freeNumbers.clear();
    }

    @Override
    public NumberAllocator clone() {
        NumberAllocator result = (NumberAllocator)super.clone();
        result.freeNumbers = this.freeNumbers != null ? (TreeSet)this.freeNumbers.clone() : null;
        return result;
    }

    protected synchronized long doGetNumber() throws NumberAllocatorException {
        long result = this.currentNumber;
        if (!this.freeNumbers.isEmpty()) {
            result = this.freeNumbers.iterator().next();
            this.freeNumbers.remove(result);
        } else {
            if (this.currentNumber > this.maxNumber) {
                throw new NumberAllocatorException("Pool has no available numbers.");
            }
            this.currentNumber = this.currentNumber + 1L;
        }
        return result;
    }

    protected synchronized void doReleaseNumber(long number) {
        if (number > 0L && number < this.currentNumber) {
            if (number == this.currentNumber - 1L) {
                this.currentNumber = this.currentNumber - 1L;
            } else {
                this.freeNumbers.add(number);
            }
        }
    }
}

