/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.loader.net.tfcache;

import com.streamscape.Trace;
import com.streamscape.lib.loader.Helper;
import com.streamscape.lib.loader.TFCacheJarStorage;
import com.streamscape.lib.loader.net.AbstractURLHandler;
import com.streamscape.lib.loader.net.tfcache.RandomAccessFileURLConnection;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.repository.cache.IllegalStateException;
import com.streamscape.repository.cache.TFCache;
import com.streamscape.repository.cache.TFCacheException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import sun.net.www.ParseUtil;

public class TFCacheURLHandler
extends AbstractURLHandler {
    public static final String PROTOCOL_NAME = "tfcache";

    @Override
    public String getProtocol() {
        return PROTOCOL_NAME;
    }

    @Override
    public synchronized URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        String host = url.getHost();
        if (host == null || host.isEmpty() || host.equalsIgnoreCase("localhost") || host.equals("~")) {
            return this.createConnection(url, ParseUtil.decode(url.getFile()).replace('/', File.separatorChar));
        }
        throw new IOException("TFCache URLs do not support remote hosts.");
    }

    protected URLConnection createConnection(URL url, String pathInCache) throws IOException {
        RandomAccessFile raf;
        File file;
        boolean useGetJar;
        boolean bl = useGetJar = (pathInCache = StringUtils.trimSlashes(pathInCache)).startsWith("ext" + File.separator) || pathInCache.startsWith("lib" + File.separator);
        if (useGetJar) {
            TFCacheJarStorage.JarInfo info = TFCacheJarStorage.getInstance().getJarFileInfo(url);
            file = info.getFile();
            raf = info.getRandomAccessFile();
        } else {
            TFCache cache = Helper.getTfCache();
            file = new File(cache.getCacheLocation() + File.separator + pathInCache);
            try {
                raf = cache.getEntityAsFile(pathInCache);
            }
            catch (TFCacheException ex) {
                Trace.logException(TFCacheURLHandler.class, ex, true);
                throw new IOException(ex.getMessage());
            }
            catch (IllegalStateException ex) {
                Trace.logException(TFCacheURLHandler.class, ex, true);
                throw new IOException(ex.getMessage());
            }
        }
        return new RandomAccessFileURLConnection(url, file, raf, true);
    }
}

