/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.loader.net.tfcache;

import com.streamscape.lib.utils.NonCloseableInputStream;
import com.streamscape.lib.utils.RandomAccessFileInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import sun.net.www.MessageHeader;
import sun.net.www.ParseUtil;

class RandomAccessFileURLConnection
extends sun.net.www.URLConnection {
    String contentType;
    InputStream is;
    private File file;
    private RandomAccessFile raf;
    private String filename;
    private boolean suppressClose;
    long length = -1L;
    long lastModified = 0L;
    static final String CONTENT_LENGTH = "content-length";
    static final String CONTENT_TYPE = "content-type";
    static final String LAST_MODIFIED = "last-modified";
    private boolean initializedHeaders = false;
    private Permission permission;

    public RandomAccessFileURLConnection(URL url, File file, RandomAccessFile raf, boolean suppressClose) {
        super(url);
        this.file = file;
        this.raf = raf;
        this.suppressClose = suppressClose;
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.filename = this.file.toString();
            this.is = new BufferedInputStream(new RandomAccessFileInputStream(this.raf));
            if (this.suppressClose) {
                this.is = new NonCloseableInputStream(this.is);
            }
            this.connected = true;
        }
    }

    private void initializeHeaders() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.initializedHeaders) {
            this.length = this.file.length();
            this.lastModified = this.file.lastModified();
            FileNameMap map = URLConnection.getFileNameMap();
            this.contentType = map.getContentTypeFor(this.filename);
            if (this.contentType != null) {
                this.properties.add(CONTENT_TYPE, this.contentType);
            }
            this.properties.add(CONTENT_LENGTH, String.valueOf(this.length));
            if (this.lastModified != 0L) {
                Date date = new Date(this.lastModified);
                SimpleDateFormat fo = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                fo.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.properties.add(LAST_MODIFIED, fo.format(date));
            }
            this.initializedHeaders = true;
        }
    }

    @Override
    public String getHeaderField(String name) {
        this.initializeHeaders();
        return super.getHeaderField(name);
    }

    @Override
    public String getHeaderField(int n) {
        this.initializeHeaders();
        return super.getHeaderField(n);
    }

    @Override
    public int getContentLength() {
        this.initializeHeaders();
        return (int)this.length;
    }

    @Override
    public String getHeaderFieldKey(int n) {
        this.initializeHeaders();
        return super.getHeaderFieldKey(n);
    }

    @Override
    public MessageHeader getProperties() {
        this.initializeHeaders();
        return super.getProperties();
    }

    @Override
    public long getLastModified() {
        this.initializeHeaders();
        return this.lastModified;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        this.connect();
        if (this.is == null) {
            throw new FileNotFoundException(this.filename);
        }
        return this.is;
    }

    @Override
    public Permission getPermission() throws IOException {
        if (this.permission == null) {
            String decodedPath = ParseUtil.decode(this.url.getPath());
            this.permission = File.separatorChar == '/' ? new FilePermission(decodedPath, "read") : new FilePermission(decodedPath.replace('/', File.separatorChar), "read");
        }
        return this.permission;
    }
}

