/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.loader.net.memory;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.security.SecurityPermission;
import java.util.Map;
import sun.net.www.MessageHeader;
import sun.net.www.URLConnection;

abstract class AbstractMemoryURLConnection
extends URLConnection {
    Map<String, byte[]> byteCodes;
    String entityName;
    byte[] content;
    InputStream stream;
    private boolean isHeadersInitialized = false;
    private Permission permission;

    public AbstractMemoryURLConnection(URL url, Map<String, byte[]> byteCodes) {
        super(url);
        this.byteCodes = byteCodes;
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.content = this.byteCodes.get(this.entityName);
            if (this.content == null) {
                throw new FileNotFoundException(this.entityName);
            }
            this.stream = new ByteArrayInputStream(this.content);
            this.connected = true;
        }
    }

    private void initializeHeaders() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.isHeadersInitialized) {
            this.properties.add("content-type", this.doGetContentType());
            this.properties.add("content-length", String.valueOf(this.content.length));
            this.isHeadersInitialized = true;
        }
    }

    abstract String doGetContentType();

    @Override
    public String getHeaderField(String name) {
        this.initializeHeaders();
        return super.getHeaderField(name);
    }

    @Override
    public String getHeaderField(int n) {
        this.initializeHeaders();
        return super.getHeaderField(n);
    }

    @Override
    public int getContentLength() {
        this.initializeHeaders();
        return this.content.length;
    }

    @Override
    public String getHeaderFieldKey(int n) {
        this.initializeHeaders();
        return super.getHeaderFieldKey(n);
    }

    @Override
    public MessageHeader getProperties() {
        this.initializeHeaders();
        return super.getProperties();
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        this.connect();
        if (this.stream == null) {
            throw new FileNotFoundException(this.entityName);
        }
        return this.stream;
    }

    @Override
    public Permission getPermission() throws IOException {
        if (this.permission == null) {
            this.permission = new SecurityPermission(this.entityName, "read");
        }
        return this.permission;
    }
}

