/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.loader.net.jar;

import com.streamscape.lib.jar.JarArchiveEntry;
import com.streamscape.lib.jar.JarFile;
import com.streamscape.lib.loader.net.URLHandler;
import com.streamscape.lib.loader.net.jar.JarEntryURLConnection;
import com.streamscape.lib.loader.net.jar.JarTFCacheURLConnection;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import sun.net.www.protocol.jar.Handler;

public class JarURLHandler
extends Handler
implements URLHandler {
    public static final String PROTOCOL_NAME = "jar";
    private JarFile jarFile;
    private JarArchiveEntry entry;

    public JarURLHandler() {
    }

    public JarURLHandler(JarFile jarFile, JarArchiveEntry entry) {
        this.jarFile = jarFile;
        this.entry = entry;
    }

    @Override
    public String getProtocol() {
        return PROTOCOL_NAME;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        if (url.getFile().startsWith("tfcache:")) {
            if (this.jarFile == null || this.entry == null) {
                return new JarTFCacheURLConnection(url, this);
            }
            return new JarEntryURLConnection(url, this.jarFile, this.entry);
        }
        return super.openConnection(url);
    }
}

