/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.loader.net.jar;

import com.streamscape.lib.jar.JarArchiveEntry;
import com.streamscape.lib.jar.JarFile;
import com.streamscape.lib.loader.TFCacheJarStorage;
import com.streamscape.lib.loader.net.jar.JarURLHandler;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.net.www.ParseUtil;

class JarTFCacheURLConnection
extends URLConnection {
    private URL jarFileURL;
    private String entryName;
    private URLConnection jarFileURLConnection;
    private Permission permission;
    private JarArchiveEntry jarEntry;
    private JarFile jarFile;
    private String contentType;

    protected JarTFCacheURLConnection(URL url, JarURLHandler handler) throws IOException {
        super(url);
        this.parseSpecs(url);
        this.jarFileURLConnection = this.jarFileURL.openConnection();
    }

    private void parseSpecs(URL url) throws MalformedURLException {
        String spec = url.getFile();
        int separator = spec.indexOf(33);
        if (separator == -1) {
            throw new MalformedURLException("no ! found in url spec:" + spec);
        }
        this.jarFileURL = new URL(spec.substring(0, separator++));
        this.entryName = null;
        if (++separator != spec.length()) {
            this.entryName = spec.substring(separator, spec.length());
            this.entryName = ParseUtil.decode(this.entryName);
        }
    }

    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public Manifest getManifest() throws IOException {
        return this.getJarFile().getManifest();
    }

    public Attributes getAttributes() throws IOException {
        JarArchiveEntry e = this.getJarEntry();
        return e != null ? e.getAttributes() : null;
    }

    public Attributes getMainAttributes() throws IOException {
        Manifest man = this.getManifest();
        return man != null ? man.getMainAttributes() : null;
    }

    public Certificate[] getCertificates() throws IOException {
        JarArchiveEntry e = this.getJarEntry();
        return e != null ? e.getCertificates() : null;
    }

    public JarFile getJarFile() throws IOException {
        this.connect();
        return this.jarFile;
    }

    public JarArchiveEntry getJarEntry() throws IOException {
        this.connect();
        return this.jarEntry;
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.jarFileURLConnection.getPermission();
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.jarFile = new JarFile(TFCacheJarStorage.getInstance().getJarFile(this.getJarFileURL()));
            if (this.entryName != null) {
                this.jarEntry = this.jarFile.getJarEntry(this.entryName);
                if (this.jarEntry == null) {
                    throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + String.valueOf(this.getJarFileURL()) + ".");
                }
            }
            this.connected = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        if (this.entryName == null) {
            throw new IOException("No entry name specified.");
        }
        if (this.jarEntry == null) {
            throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + String.valueOf(this.getJarFileURL()) + ".");
        }
        InputStream result = this.jarFile.getInputStream(this.jarEntry);
        return result;
    }

    @Override
    public int getContentLength() {
        int result = -1;
        try {
            this.connect();
            result = this.jarEntry == null ? this.jarFileURLConnection.getContentLength() : (int)this.getJarEntry().getSize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Object getContent() throws IOException {
        this.connect();
        Object result = this.entryName == null ? this.jarFile : super.getContent();
        return result;
    }

    @Override
    public String getContentType() {
        if (this.contentType == null) {
            if (this.entryName == null) {
                this.contentType = "x-java/jar";
            } else {
                try {
                    this.connect();
                    InputStream in = this.jarFile.getInputStream(this.jarEntry);
                    this.contentType = JarTFCacheURLConnection.guessContentTypeFromStream(new BufferedInputStream(in));
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.contentType == null) {
                this.contentType = JarTFCacheURLConnection.guessContentTypeFromName(this.entryName);
            }
            if (this.contentType == null) {
                this.contentType = "content/unknown";
            }
        }
        return this.contentType;
    }

    @Override
    public String getHeaderField(String name) {
        return this.jarFileURLConnection.getHeaderField(name);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.jarFileURLConnection.setRequestProperty(key, value);
    }

    @Override
    public String getRequestProperty(String key) {
        return this.jarFileURLConnection.getRequestProperty(key);
    }

    @Override
    public void setAllowUserInteraction(boolean allowuserinteraction) {
        this.jarFileURLConnection.setAllowUserInteraction(allowuserinteraction);
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.jarFileURLConnection.getAllowUserInteraction();
    }

    @Override
    public void setUseCaches(boolean usecaches) {
        this.jarFileURLConnection.setUseCaches(usecaches);
    }

    @Override
    public boolean getUseCaches() {
        return this.jarFileURLConnection.getUseCaches();
    }

    @Override
    public void setIfModifiedSince(long ifmodifiedsince) {
        this.jarFileURLConnection.setIfModifiedSince(ifmodifiedsince);
    }

    @Override
    public void setDefaultUseCaches(boolean defaultusecaches) {
        this.jarFileURLConnection.setDefaultUseCaches(defaultusecaches);
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.jarFileURLConnection.getDefaultUseCaches();
    }
}

