/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.loader.net.jar;

import com.streamscape.lib.jar.JarArchiveEntry;
import com.streamscape.lib.jar.JarFile;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;

public class JarEntryURLConnection
extends URLConnection {
    private JarFile jarFile;
    private JarArchiveEntry entry;
    private URLConnection jarFileURLConnection;
    private String contentType;

    public JarEntryURLConnection(URL url, JarFile jarFile, JarArchiveEntry entry) throws IOException {
        super(url);
        this.jarFile = jarFile;
        this.entry = entry;
        this.initJarFileURLConnection();
    }

    private void initJarFileURLConnection() throws IOException {
        String spec = this.url.getFile();
        int separator = spec.indexOf(33);
        if (separator == -1) {
            throw new MalformedURLException("no ! found in url spec:" + spec);
        }
        this.jarFileURLConnection = new URL(spec.substring(0, separator++)).openConnection();
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.jarFileURLConnection.getPermission();
    }

    @Override
    public void connect() throws IOException {
        this.connected = true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.jarFile.getInputStream(this.entry);
    }

    @Override
    public int getContentLength() {
        int result = -1;
        try {
            this.connect();
            result = (int)this.entry.getSize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Object getContent() throws IOException {
        byte[] byArray;
        block8: {
            this.connect();
            InputStream input = this.getInputStream();
            try {
                byArray = FileIOUtils.getStreamContent(input, this.entry.getSize());
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UtilitiesException e) {
                    throw new IOException(e);
                }
            }
            input.close();
        }
        return byArray;
    }

    @Override
    public String getContentType() {
        if (this.contentType == null) {
            InputStream input = null;
            try {
                this.connect();
                input = this.getInputStream();
                this.contentType = JarEntryURLConnection.guessContentTypeFromStream(new BufferedInputStream(input));
            }
            catch (IOException iOException) {
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (this.contentType == null) {
                this.contentType = JarEntryURLConnection.guessContentTypeFromName(this.entry.getName());
            }
            if (this.contentType == null) {
                this.contentType = "content/unknown";
            }
        }
        return this.contentType;
    }

    @Override
    public String getHeaderField(String name) {
        return this.jarFileURLConnection.getHeaderField(name);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.jarFileURLConnection.setRequestProperty(key, value);
    }

    @Override
    public String getRequestProperty(String key) {
        return this.jarFileURLConnection.getRequestProperty(key);
    }

    @Override
    public void setAllowUserInteraction(boolean allowuserinteraction) {
        this.jarFileURLConnection.setAllowUserInteraction(allowuserinteraction);
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.jarFileURLConnection.getAllowUserInteraction();
    }

    @Override
    public void setUseCaches(boolean usecaches) {
        this.jarFileURLConnection.setUseCaches(usecaches);
    }

    @Override
    public boolean getUseCaches() {
        return this.jarFileURLConnection.getUseCaches();
    }

    @Override
    public void setIfModifiedSince(long ifmodifiedsince) {
        this.jarFileURLConnection.setIfModifiedSince(ifmodifiedsince);
    }

    @Override
    public void setDefaultUseCaches(boolean defaultusecaches) {
        this.jarFileURLConnection.setDefaultUseCaches(defaultusecaches);
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.jarFileURLConnection.getDefaultUseCaches();
    }
}

