/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.loader.net;

import com.streamscape.Trace;
import com.streamscape.lib.loader.net.URLHandler;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.List;
import java.util.Map;

public abstract class AbstractURLHandler
extends URLStreamHandler
implements URLHandler {
    private static final String PROTOCOL_HANDLER_PACKAGE = "com.streamscape.lib.loader.net";
    private static final String PROTOCOL_PACKAGES = "java.protocol.handler.pkgs";

    public static void initHandlers(List<URLHandler> handlers) {
        Object packages = System.getProperty(PROTOCOL_PACKAGES);
        if (packages == null) {
            packages = PROTOCOL_HANDLER_PACKAGE;
        } else if (!((String)packages).contains(PROTOCOL_HANDLER_PACKAGE)) {
            packages = (String)packages + "|com.streamscape.lib.loader.net";
        }
        System.setProperty(PROTOCOL_PACKAGES, (String)packages);
        try {
            Field handlersField = URL.class.getDeclaredField("handlers");
            handlersField.setAccessible(true);
            Map handlersMap = (Map)handlersField.get(null);
            if (handlers != null) {
                for (URLHandler handler : handlers) {
                    handlersMap.put(handler.getProtocol(), handler);
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(URLHandler.class, exception, true);
            Trace.logError(URLHandler.class, "Unable to set custom protocol handlers to URL.");
        }
    }

    @Override
    protected void parseURL(URL url, String spec, int start, int limit) {
        super.parseURL(url, spec.replace(File.separatorChar, '/'), start, limit);
    }

    @Override
    public synchronized URLConnection openConnection(URL url) throws IOException {
        return this.openConnection(url, null);
    }
}

