/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.loader;

import com.streamscape.lib.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import sun.net.www.ParseUtil;

public class TFCacheJarStorage {
    private static volatile TFCacheJarStorage instance;
    private final Map<String, JarInfo> jars = new HashMap<String, JarInfo>();
    private static final String LIB_PREFIX;
    private static final String EXT_PREFIX;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TFCacheJarStorage getInstance() {
        if (instance != null) return instance;
        Class<TFCacheJarStorage> clazz = TFCacheJarStorage.class;
        synchronized (TFCacheJarStorage.class) {
            if (instance != null) return instance;
            instance = new TFCacheJarStorage();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public JarInfo getJarFileInfo(URL url) throws IOException {
        String path = ParseUtil.decode(url.getFile());
        path = path.replace('/', File.separatorChar);
        return this.getJar(path);
    }

    public RandomAccessFile getJarFile(URL url) throws IOException {
        return this.getJarFileInfo(url).getRandomAccessFile();
    }

    private String normalizePathInCache(String pathInCache) {
        return StringUtils.trimSlashes(pathInCache).replace(File.separator + File.separator, File.separator);
    }

    private JarInfo getJar(String pathInCache) throws IOException {
        Map<String, JarInfo> map = this.jars;
        synchronized (map) {
            pathInCache = this.normalizePathInCache(pathInCache);
            if (pathInCache.startsWith(LIB_PREFIX) || pathInCache.startsWith(EXT_PREFIX)) {
                JarInfo info = this.jars.get(pathInCache);
                if (info == null) {
                    throw new IOException(pathInCache + " is not in cache.");
                }
                return info;
            }
            throw new IOException(pathInCache + " is not in 'jar' or 'ext' location.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putJar(String pathInCache, File file, RandomAccessFile raf) {
        Map<String, JarInfo> map = this.jars;
        synchronized (map) {
            pathInCache = this.normalizePathInCache(pathInCache);
            this.jars.put(pathInCache, new JarInfo(file, raf));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJar(String pathInCache) {
        Map<String, JarInfo> map = this.jars;
        synchronized (map) {
            pathInCache = this.normalizePathInCache(pathInCache);
            this.jars.remove(pathInCache);
        }
    }

    static {
        LIB_PREFIX = "lib" + File.separator;
        EXT_PREFIX = "ext" + File.separator;
    }

    public static class JarInfo {
        private File file;
        private RandomAccessFile raf;

        private JarInfo(File file, RandomAccessFile raf) {
            this.file = file;
            this.raf = raf;
        }

        public File getFile() {
            return this.file;
        }

        public RandomAccessFile getRandomAccessFile() {
            return this.raf;
        }
    }
}

