/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.loader;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;

public class MemoryJarFile {
    private byte[] jarBytes = null;
    private Map<String, byte[]> entries = new HashMap<String, byte[]>();
    private List<String> removedEntries = new ArrayList<String>();
    private Manifest manifest = null;

    public MemoryJarFile() {
    }

    public MemoryJarFile(String fileName) throws UtilitiesException {
        this(FileIOUtils.getFileContent(new File(fileName)));
    }

    public MemoryJarFile(byte[] jarBytes) {
        this.jarBytes = jarBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsEntry(String entryName) throws IOException {
        if (this.removedEntries.contains(entryName)) {
            return false;
        }
        if (this.jarBytes != null) {
            try (ZipInputStream jarInputStream = null;){
                JarEntry entry;
                jarInputStream = new JarInputStream(new ByteArrayInputStream(this.jarBytes));
                while ((entry = ((JarInputStream)jarInputStream).getNextJarEntry()) != null) {
                    if (!entry.getName().equals(entryName)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return this.entries.containsKey(entryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listEntries() throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        if (this.jarBytes != null) {
            try (ZipInputStream jarInputStream = null;){
                JarEntry entry;
                jarInputStream = new JarInputStream(new ByteArrayInputStream(this.jarBytes));
                while ((entry = ((JarInputStream)jarInputStream).getNextJarEntry()) != null) {
                    names.add(entry.getName());
                }
            }
        }
        names.addAll(this.entries.keySet());
        names.removeAll(this.removedEntries);
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getEntry(String name) throws IOException {
        if (this.removedEntries.contains(name)) {
            return null;
        }
        if (this.entries.containsKey(name)) {
            return this.entries.get(name);
        }
        if (this.jarBytes != null) {
            try (ZipInputStream jarInputStream = null;){
                JarEntry entry;
                jarInputStream = new JarInputStream(new ByteArrayInputStream(this.jarBytes));
                while ((entry = ((JarInputStream)jarInputStream).getNextJarEntry()) != null) {
                    int count;
                    if (!name.equals(entry.getName())) continue;
                    byte[] buffer = new byte[1024];
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    while ((count = jarInputStream.read(buffer)) != -1) {
                        bos.write(buffer, 0, count);
                    }
                    byte[] byArray = bos.toByteArray();
                    return byArray;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, byte[]> getClasses() throws IOException {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        if (this.jarBytes != null) {
            try (ZipInputStream jarInputStream = null;){
                JarEntry entry;
                jarInputStream = new JarInputStream(new ByteArrayInputStream(this.jarBytes));
                while ((entry = ((JarInputStream)jarInputStream).getNextJarEntry()) != null) {
                    int count;
                    if (!entry.getName().endsWith(".class")) continue;
                    byte[] buffer = new byte[1024];
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    while ((count = jarInputStream.read(buffer)) != -1) {
                        bos.write(buffer, 0, count);
                    }
                    classes.put(MemoryJarFile.convertPathInJarToClassName(entry.getName()), bos.toByteArray());
                }
            }
        }
        return classes;
    }

    public void updateEntry(String name, byte[] data) {
        this.entries.put(name, data);
        this.removedEntries.remove(name);
    }

    public void updateEntries(Map<String, byte[]> entries) {
        for (Map.Entry<String, byte[]> entry : entries.entrySet()) {
            this.entries.put(entry.getKey(), entry.getValue());
            this.removedEntries.remove(entry.getKey());
        }
    }

    public void addEntry(String name, byte[] data) {
        this.entries.put(name, data);
        this.removedEntries.remove(name);
    }

    public void addEntries(Map<String, byte[]> entries) {
        for (Map.Entry<String, byte[]> entry : entries.entrySet()) {
            this.entries.put(entry.getKey(), entry.getValue());
            this.removedEntries.remove(entry.getKey());
        }
    }

    public void removeEntry(String name) {
        this.removedEntries.add(name);
        this.entries.remove(name);
    }

    public Manifest getManifest() throws IOException {
        if (this.manifest == null) {
            this.manifest = new JarInputStream(new ByteArrayInputStream(this.jarBytes)).getManifest();
        }
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public byte[] getJarBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.writeJarTo(bos);
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJarToFile(String jarName) throws IOException {
        File jarFile = new File(jarName);
        try (FileOutputStream jarOutputStream = null;){
            jarOutputStream = new FileOutputStream(jarFile);
            this.writeJarTo(jarOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJarTo(OutputStream output) throws IOException {
        if (this.jarBytes != null) {
            try (ZipInputStream jarInputStream = null;){
                JarEntry jarEntry;
                jarInputStream = new JarInputStream(new ByteArrayInputStream(this.jarBytes));
                byte[] buffer = new byte[1024];
                while ((jarEntry = ((JarInputStream)jarInputStream).getNextJarEntry()) != null) {
                    int count;
                    if (jarEntry.isDirectory() || this.entries.containsKey(jarEntry.getName()) || this.removedEntries.contains(jarEntry.getName())) continue;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    while ((count = jarInputStream.read(buffer)) != -1) {
                        bos.write(buffer, 0, count);
                    }
                    this.entries.put(jarEntry.getName(), bos.toByteArray());
                }
                if (this.manifest == null) {
                    this.manifest = ((JarInputStream)jarInputStream).getManifest();
                }
            }
        }
        if (this.manifest != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.manifest.write(bos);
            if (!this.entries.containsKey("META-INF/MANIFEST.MF")) {
                this.entries.put("META-INF/MANIFEST.MF", bos.toByteArray());
            }
        }
        try (JarOutputStream jarOutputStream = null;){
            jarOutputStream = new JarOutputStream(output);
            for (Map.Entry<String, byte[]> entry : this.entries.entrySet()) {
                JarEntry jarEntry = new JarEntry(entry.getKey());
                jarEntry.setSize(entry.getValue().length);
                jarOutputStream.putNextEntry(jarEntry);
                jarOutputStream.write(entry.getValue(), 0, entry.getValue().length);
                jarOutputStream.closeEntry();
            }
            jarOutputStream.flush();
            jarOutputStream.finish();
        }
    }

    public static String convertClassNameToPathInJar(String className) {
        return className.replaceAll("\\.", "/");
    }

    public static String convertClassNameToEntryInJar(String className) {
        return MemoryJarFile.convertClassNameToPathInJar(className) + ".class";
    }

    public static String convertPathInJarToClassName(String path) {
        if (path.endsWith(".class")) {
            path = path.substring(0, path.length() - 6);
        }
        return path.replaceAll("/", ".");
    }

    public static String convertClassNameToPathInJar(String packageName, String className) {
        ((String)packageName).toLowerCase();
        packageName = ((String)packageName).replaceAll("\\.", "/");
        if (((String)packageName).length() != 0) {
            packageName = (String)packageName + "/";
        }
        return (String)packageName + className;
    }
}

