/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.loader;

import com.streamscape.lib.jar.JarArchiveEntry;
import com.streamscape.lib.jar.JarFile;
import com.streamscape.lib.loader.TFCacheJarStorage;
import com.streamscape.lib.loader.URLClassPath;
import com.streamscape.lib.loader.net.jar.JarURLHandler;
import com.streamscape.lib.utils.JavaInternal;
import com.streamscape.lib.zip.ZipArchiveEntry;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.net.www.ParseUtil;

public class FabricURLClassPath
extends URLClassPath {
    public FabricURLClassPath(URL[] urls, URLStreamHandlerFactory factory) {
        super(urls, factory);
    }

    public FabricURLClassPath(URL[] urls) {
        super(urls);
    }

    @Override
    protected URLClassPath.Loader getLoader(URL url) throws IOException {
        String protocol = url.getProtocol();
        if ("tfcache".equals(protocol)) {
            return new TFCacheJarLoader(url, this.jarHandler, this.lmap);
        }
        if ("nvfs".equals(protocol)) {
            throw new IOException("nvfs:// URLs are not yet supported in URL Class Path");
        }
        return super.getLoader(url);
    }

    private static class TFCacheJarLoader
    extends URLClassPath.Loader {
        private JarFile jar;
        private URL csu;
        private URLStreamHandler handler;
        private JavaInternal.JarIndex index;
        private HashMap lmap;

        TFCacheJarLoader(URL url, URLStreamHandler jarHandler, HashMap loaderMap) throws IOException {
            super(new URL("jar", "", -1, String.valueOf(url) + "!/", jarHandler));
            this.jar = new JarFile(TFCacheJarStorage.getInstance().getJarFile(url));
            this.index = this.jar.getJarIndex();
            this.csu = url;
            this.handler = jarHandler;
            this.lmap = loaderMap;
            if (this.index != null) {
                String[] jarFiles;
                for (String jarFile : jarFiles = this.index.getJarFiles()) {
                    try {
                        URL jarURL = new URL(this.csu, jarFile);
                        if (this.lmap.containsKey(jarURL)) continue;
                        this.lmap.put(jarURL, null);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        }

        JavaInternal.JarIndex getIndex() {
            return this.index;
        }

        JavaInternal.Resource checkResource(final String name, boolean check, final JarArchiveEntry entry) {
            URL url;
            try {
                url = new URL(this.getBaseURL(), ParseUtil.encodePath(name, false), new JarURLHandler(this.jar, entry));
                if (check) {
                    URLClassPath.check(url);
                }
            }
            catch (Exception exception) {
                return null;
            }
            return new JavaInternal.Resource(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public URL getURL() {
                    return url;
                }

                @Override
                public URL getCodeSourceURL() {
                    return csu;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return jar.getInputStream(entry);
                }

                @Override
                public int getContentLength() {
                    return (int)entry.getSize();
                }

                @Override
                public Manifest getManifest() throws IOException {
                    return jar.getManifest();
                }

                @Override
                public Certificate[] getCertificates() {
                    return entry.getCertificates();
                }

                @Override
                public CodeSigner[] getCodeSigners() {
                    return entry.getCodeSigners();
                }
            };
        }

        boolean validIndex(String name) {
            String packageName = name;
            int pos = name.lastIndexOf("/");
            if (pos != -1) {
                packageName = name.substring(0, pos);
            }
            Enumeration<JarArchiveEntry> enum_ = this.jar.entries();
            while (enum_.hasMoreElements()) {
                ZipArchiveEntry entry = enum_.nextElement();
                String entryName = entry.getName();
                pos = entryName.lastIndexOf("/");
                if (pos != -1) {
                    entryName = entryName.substring(0, pos);
                }
                if (!entryName.equals(packageName)) continue;
                return true;
            }
            return false;
        }

        @Override
        URL findResource(String name, boolean check) {
            JavaInternal.Resource rsc = this.getResource(name, check);
            if (rsc != null) {
                return rsc.getURL();
            }
            return null;
        }

        @Override
        JavaInternal.Resource getResource(String name, boolean check) {
            JarArchiveEntry entry = this.jar.getJarEntry(name);
            if (entry != null) {
                return this.checkResource(name, check, entry);
            }
            if (this.index == null) {
                return null;
            }
            HashSet visited = new HashSet();
            return this.getResource(name, check, visited);
        }

        JavaInternal.Resource getResource(String name, boolean check, Set visited) {
            boolean done = false;
            int count = 0;
            LinkedList<String> jarFilesList = null;
            jarFilesList = this.index.get(name);
            if (jarFilesList == null) {
                return null;
            }
            do {
                Object[] jarFiles = jarFilesList.toArray();
                int size = jarFilesList.size();
                while (count < size) {
                    JavaInternal.Resource res;
                    boolean visitedURL;
                    TFCacheJarLoader newLoader;
                    URL url;
                    block9: {
                        String jarName = (String)jarFiles[count++];
                        try {
                            url = new URL(this.csu, jarName);
                            newLoader = (TFCacheJarLoader)this.lmap.get(url);
                            if (newLoader != null) break block9;
                            newLoader = (TFCacheJarLoader)AccessController.doPrivileged(() -> new TFCacheJarLoader(url, this.handler, this.lmap));
                            JavaInternal.JarIndex newIndex = newLoader.getIndex();
                            if (newIndex != null) {
                                int pos = jarName.lastIndexOf("/");
                                newIndex.merge(this.index, pos == -1 ? null : jarName.substring(0, pos + 1));
                            }
                            this.lmap.put(url, newLoader);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    boolean bl = visitedURL = !visited.add(url);
                    if (!visitedURL) {
                        JarArchiveEntry entry = newLoader.jar.getJarEntry(name);
                        if (entry != null) {
                            return newLoader.checkResource(name, check, entry);
                        }
                        if (!newLoader.validIndex(name)) {
                            throw new RuntimeException("Invalid index");
                        }
                    }
                    if (visitedURL || newLoader == this || newLoader.getIndex() == null || (res = newLoader.getResource(name, check, visited)) == null) continue;
                    return res;
                }
            } while (count < (jarFilesList = this.index.get(name)).size());
            return null;
        }

        @Override
        URL[] getClassPath() throws IOException {
            String value;
            Attributes attr;
            Manifest man;
            if (this.index != null) {
                return null;
            }
            this.parseExtensionsDependencies();
            if (this.jar.hasClassPathAttribute() && (man = this.jar.getManifest()) != null && (attr = man.getMainAttributes()) != null && (value = attr.getValue(Attributes.Name.CLASS_PATH)) != null) {
                return this.parseClassPath(this.csu, value);
            }
            return null;
        }

        private void parseExtensionsDependencies() throws IOException {
        }

        private URL[] parseClassPath(URL base, String value) throws MalformedURLException {
            StringTokenizer st = new StringTokenizer(value);
            URL[] urls = new URL[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String path = st.nextToken();
                urls[i] = new URL(base, path);
                ++i;
            }
            return urls;
        }
    }
}

