/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.loader;

import com.streamscape.lib.loader.FabricURLClassPath;
import com.streamscape.lib.loader.FactoryURLClassLoader;
import com.streamscape.lib.utils.JavaInternal;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.net.www.ParseUtil;

public class FabricURLClassLoader
extends SecureClassLoader {
    private FabricURLClassPath ucp;
    private AccessControlContext acc;

    public FabricURLClassLoader(URL[] urls, ClassLoader parent) {
        super(parent);
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.ucp = new FabricURLClassPath(urls);
        this.acc = AccessController.getContext();
    }

    public FabricURLClassLoader(URL[] urls) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.ucp = new FabricURLClassPath(urls);
        this.acc = AccessController.getContext();
    }

    public FabricURLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(parent);
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.ucp = new FabricURLClassPath(urls, factory);
        this.acc = AccessController.getContext();
    }

    public void addURL(URL url) {
        this.ucp.addURL(url);
    }

    public URL[] getURLs() {
        return this.ucp.getURLs();
    }

    @Override
    protected Class<?> findClass(final String name) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    String path = name.replace('.', '/').concat(".class");
                    JavaInternal.Resource res = FabricURLClassLoader.this.ucp.getResource(path, false);
                    if (res != null) {
                        try {
                            return FabricURLClassLoader.this.defineClass(name, res);
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException(name, e);
                        }
                    }
                    throw new ClassNotFoundException(name);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    private Class defineClass(String name, JavaInternal.Resource res) throws IOException {
        ByteBuffer bb;
        int i = name.lastIndexOf(46);
        URL url = res.getCodeSourceURL();
        if (i != -1) {
            String pkgname = name.substring(0, i);
            Package pkg = this.getPackage(pkgname);
            Manifest man = res.getManifest();
            if (pkg != null) {
                if (pkg.isSealed()) {
                    if (!pkg.isSealed(url)) {
                        throw new SecurityException("sealing violation: package " + pkgname + " is sealed");
                    }
                } else if (man != null && this.isSealed(pkgname, man)) {
                    throw new SecurityException("sealing violation: can't seal package " + pkgname + ": already loaded");
                }
            } else if (man != null) {
                this.definePackage(pkgname, man, url);
            } else {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
        }
        if ((bb = res.getByteBuffer()) != null) {
            CodeSigner[] signers = res.getCodeSigners();
            CodeSource cs = new CodeSource(url, signers);
            return this.defineClass(name, bb, cs);
        }
        byte[] b = res.getBytes();
        CodeSigner[] signers = res.getCodeSigners();
        CodeSource cs = new CodeSource(url, signers);
        return this.defineClass(name, b, 0, b.length, cs);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        String path = name.replace('.', '/').concat("/");
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(sealed)) {
            sealBase = url;
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    @Override
    public URL findResource(final String name) {
        URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return FabricURLClassLoader.this.ucp.findResource(name, true);
            }
        }, this.acc);
        return url != null ? this.ucp.checkURL(url) : null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        final Enumeration e = this.ucp.findResources(name, true);
        return new Enumeration<URL>(){
            private URL url = null;

            private boolean next() {
                URL u;
                if (this.url != null) {
                    return true;
                }
                while ((u = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (!e.hasMoreElements()) {
                            return null;
                        }
                        return e.nextElement();
                    }
                }, FabricURLClassLoader.this.acc)) != null) {
                    this.url = FabricURLClassLoader.this.ucp.checkURL(u);
                    if (this.url == null) continue;
                }
                return this.url != null;
            }

            @Override
            public URL nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL u = this.url;
                this.url = null;
                return u;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }
        };
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        Permission p;
        URLConnection urlConnection;
        PermissionCollection perms = super.getPermissions(codesource);
        URL url = codesource.getLocation();
        try {
            urlConnection = url.openConnection();
            p = urlConnection.getPermission();
        }
        catch (IOException ioe) {
            p = null;
            urlConnection = null;
        }
        if (p instanceof FilePermission) {
            path = p.getName();
            if (((String)path).endsWith(File.separator)) {
                path = (String)path + "-";
                p = new FilePermission((String)path, "read");
            }
        } else if (p == null && url.getProtocol().equals("file")) {
            path = url.getFile().replace('/', File.separatorChar);
            if (((String)(path = ParseUtil.decode((String)path))).endsWith(File.separator)) {
                path = (String)path + "-";
            }
            p = new FilePermission((String)path, "read");
        } else {
            String host;
            URL locUrl = url;
            if (urlConnection instanceof JarURLConnection) {
                locUrl = ((JarURLConnection)urlConnection).getJarFileURL();
            }
            if ((host = locUrl.getHost()) != null && host.length() > 0) {
                p = new SocketPermission(host, "connect,accept");
            }
        }
        if (p != null) {
            final SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                final Permission fp = p;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() throws SecurityException {
                        sm.checkPermission(fp);
                        return null;
                    }
                }, this.acc);
            }
            perms.add(p);
        }
        return perms;
    }

    public static FabricURLClassLoader newInstance(final URL[] urls, final ClassLoader parent) {
        AccessControlContext acc = AccessController.getContext();
        FabricURLClassLoader ucl = (FabricURLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FactoryURLClassLoader(urls, parent);
            }
        });
        ucl.acc = acc;
        return ucl;
    }

    public static FabricURLClassLoader newInstance(final URL[] urls) {
        AccessControlContext acc = AccessController.getContext();
        FabricURLClassLoader ucl = (FabricURLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FactoryURLClassLoader(urls);
            }
        });
        ucl.acc = acc;
        return ucl;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

