/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.loader;

import com.streamscape.lib.loader.MemoryJarFile;
import com.streamscape.lib.loader.net.AbstractURLHandler;
import com.streamscape.lib.loader.net.memory.MemoryClassURLHandler;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FabricClassLoaderInMemory
extends ClassLoader {
    private static final Map<String, byte[]> byteCodes = new ConcurrentHashMap<String, byte[]>();

    public FabricClassLoaderInMemory() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
    }

    public FabricClassLoaderInMemory(ClassLoader parent) {
        super(parent);
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        byte[] data;
        Class<?> cls = this.findLoadedClass(name);
        if (cls == null && (data = byteCodes.get(name)) != null) {
            try {
                cls = this.defineClass(name, data, 0, data.length);
            }
            catch (ClassFormatError exception) {
                throw new ClassNotFoundException(name);
            }
        }
        if (cls == null) {
            try {
                cls = this.getParent().loadClass(name);
            }
            catch (Exception exception) {
                throw new ClassNotFoundException(name);
            }
        }
        if (cls == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(cls);
        }
        return cls;
    }

    @Override
    public URL getResource(String name) {
        try {
            if (name.length() > 0) {
                String actualClassName = name.substring(0, name.length() - ".class".length()).replaceAll("/", ".");
                if (byteCodes.get(actualClassName) != null) {
                    return new URL("memclass://localhost/" + name);
                }
                return super.getResource(name);
            }
            return super.getResource(name);
        }
        catch (MalformedURLException error) {
            return super.getResource(name);
        }
    }

    public void addClasses(Map<String, byte[]> classes) {
        for (Map.Entry<String, byte[]> entry : classes.entrySet()) {
            this.addClass(entry.getKey(), entry.getValue());
        }
    }

    public void addClass(String className, byte[] byteCode) {
        byteCodes.put(className, byteCode);
    }

    public void removeClass(String className) {
        byteCodes.remove(className);
    }

    public void removeClasses(Set<String> classNames) {
        classNames.forEach(this::removeClass);
    }

    public void clear() {
        byteCodes.clear();
    }

    public void addJar(byte[] jarBytes) throws IOException {
        this.addClasses(new MemoryJarFile(jarBytes).getClasses());
    }

    static {
        AbstractURLHandler.initHandlers(Collections.singletonList(new MemoryClassURLHandler(byteCodes)));
    }
}

