/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.loader;

import com.streamscape.Trace;
import com.streamscape.lib.loader.FabricURLClassLoader;
import com.streamscape.sef.pkg.PackageDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public class FabricClassLoader
extends FabricURLClassLoader {
    private String name;
    private PackageDescriptor pkgDescriptor;
    private com.streamscape.repository.pkg.Package pkg;
    private volatile boolean isLoaded = true;
    private volatile boolean isWorking = true;
    private final Object stateMutex = new Object();

    public FabricClassLoader(String name, URL[] urls, ClassLoader parent) throws Exception {
        super(FabricClassLoader.checkUrls(urls), parent);
        this.name = name;
    }

    public FabricClassLoader(FabricClassLoader other, ClassLoader parent) throws Exception {
        this(other.name, other.getURLs(), parent);
        this.pkgDescriptor = other.pkgDescriptor;
        this.pkg = other.pkg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    protected Package getPackage(String name) {
        return super.getPackage(name);
    }

    @Override
    protected Package[] getPackages() {
        return super.getPackages();
    }

    @Override
    public URL getResource(String name) {
        return this.checkLoaded() ? super.getResource(name) : this.getParent().getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.checkLoaded() ? super.getResourceAsStream(name) : this.getParent().getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.checkLoaded() ? super.getResources(name) : this.getParent().getResources(name);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.checkLoaded() ? super.loadClass(name) : this.getParent().loadClass(name);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.checkLoaded() ? super.loadClass(name, resolve) : this.getParent().loadClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkLoaded() {
        Object object = this.stateMutex;
        synchronized (object) {
            if (!this.isLoaded && !this.isWorking) {
                Trace.logError(this, "Fabric Class Loader '" + this.name + "' has been unloaded. Using parent loader...");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() throws Exception {
        Object object = this.stateMutex;
        synchronized (object) {
            if (this.isLoaded) {
                this.isLoaded = false;
                this.isWorking = false;
            }
        }
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorking(boolean isWorking) {
        Object object = this.stateMutex;
        synchronized (object) {
            this.isWorking = isWorking;
        }
    }

    private static URL[] checkUrls(URL[] urls) throws IllegalStateException {
        for (URL url : urls) {
            String protocol = url.getProtocol();
            if (protocol.equals("tfcache")) {
                String file = url.getFile();
                if (file.startsWith("/lib/") || file.startsWith("/ext/")) continue;
                throw new IllegalStateException("Fabric Class Loader supports only lib and ext tfcache URLs");
            }
            if (protocol.equals("file") || protocol.equals("nvfs") || protocol.equals("memjar") || protocol.equals("httpmemjar")) continue;
            throw new IllegalStateException("URL protocol '" + protocol + "' is not supported by Fabric Class Loader");
        }
        return urls;
    }

    public PackageDescriptor getPackageDescriptor() {
        return this.pkgDescriptor;
    }

    public com.streamscape.repository.pkg.Package getPackage() {
        return this.pkg;
    }

    public void setPackage(PackageDescriptor pkgDescriptor, com.streamscape.repository.pkg.Package pkg) {
        this.pkgDescriptor = pkgDescriptor;
        this.pkg = pkg;
    }

    public String toString() {
        return this.name;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

