/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.loader;

import com.streamscape.lib.loader.FabricClassLoader;
import com.streamscape.omf.xml.xstream.core.util.CompositeClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public class ClassLoaderReference
extends ClassLoader {
    private transient ClassLoader reference;

    public static ClassLoader getRealClassLoader(ClassLoader classLoader) {
        while (classLoader instanceof ClassLoaderReference) {
            classLoader = ((ClassLoaderReference)classLoader).getReference();
        }
        return classLoader;
    }

    public ClassLoaderReference(ClassLoader reference) {
        this.reference = reference == null ? Thread.currentThread().getContextClassLoader() : reference;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.reference.loadClass(name);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.reference instanceof FabricClassLoader) {
            return ((FabricClassLoader)this.reference).loadClass(name, resolve);
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        return this.reference.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.reference.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.reference.getResources(name);
    }

    public ClassLoader getReference() {
        return this.reference;
    }

    public void setReference(ClassLoader reference) {
        this.reference = reference;
    }

    private Object writeReplace() {
        return new Replacement();
    }

    static class Replacement {
        Replacement() {
        }

        private Object readResolve() {
            return new ClassLoaderReference(new CompositeClassLoader());
        }
    }
}

