/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.job;

import com.streamscape.lib.job.JobId;

public class JobStatus {
    private JobId jobId;
    private String name;
    private float progress;
    private State state;
    private long startTime;
    private long finishTime;
    private String failureInfo;
    private String user;

    public JobStatus() {
        this(null);
    }

    public JobStatus(JobId jobId) {
        this.jobId = jobId;
        this.progress = -1.0f;
        this.state = State.NOT_RUNNING;
        this.startTime = 0L;
        this.failureInfo = null;
    }

    public boolean isRunning() {
        return this.state == State.RUNNING || this.state == State.PREP;
    }

    public boolean isCompleted() {
        return this.state == State.FAILED || this.state == State.SUCCEEDED || this.state == State.KILLED;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public String getFailureInfo() {
        return this.failureInfo;
    }

    public void setFailureInfo(String failureInfo) {
        this.failureInfo = failureInfo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public static enum State {
        NOT_RUNNING,
        RUNNING,
        SUCCEEDED,
        FAILED,
        PREP,
        KILLED;


        public String getStateName() {
            return this.toString();
        }
    }
}

