/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.jar;

import com.streamscape.lib.jar.JarArchiveEntry;
import com.streamscape.lib.jar.JarVerifier;
import com.streamscape.lib.jar.ManifestEntryVerifier;
import com.streamscape.lib.utils.JavaInternal;
import com.streamscape.lib.zip.ZipArchiveEntry;
import com.streamscape.lib.zip.ZipFile;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class JarFile
extends ZipFile {
    private SoftReference<Manifest> manRef;
    private JarArchiveEntry manEntry;
    private JarVerifier jv;
    private boolean jvInitialized;
    private boolean verify;
    private boolean computedHasClassPathAttribute;
    private boolean hasClassPathAttribute;
    private String[] metaInfEntryNames;
    private boolean isMetaInfEntryNamesInitialized = false;
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    public static final String META_INF_DIR = "META-INF/";
    private static int[] lastOcc;
    private static int[] optoSft;
    private static char[] src;

    public JarFile(String name) throws IOException {
        this(new File(name), true);
    }

    public JarFile(String name, boolean verify) throws IOException {
        this(new File(name), verify);
    }

    public JarFile(File file) throws IOException {
        this(file, true);
    }

    public JarFile(File file, boolean verify) throws IOException {
        super(file);
        this.verify = verify;
    }

    public JarFile(RandomAccessFile file) throws IOException {
        this(file, true);
    }

    public JarFile(RandomAccessFile file, boolean verify) throws IOException {
        super(file, true);
        this.verify = verify;
    }

    public Manifest getManifest() throws IOException {
        return this.getManifestFromReference();
    }

    private Manifest getManifestFromReference() throws IOException {
        JarArchiveEntry manEntry;
        Manifest man;
        Manifest manifest = man = this.manRef != null ? this.manRef.get() : null;
        if (man == null && (manEntry = this.getManEntry()) != null) {
            if (this.verify) {
                byte[] b = this.getBytes(manEntry);
                man = new Manifest(new ByteArrayInputStream(b));
                if (!this.jvInitialized) {
                    this.jv = new JarVerifier(b);
                }
            } else {
                man = new Manifest(this.getSuperInputStream(manEntry));
            }
            this.manRef = new SoftReference<Manifest>(man);
        }
        return man;
    }

    private String[] getMetaInfEntryNames() {
        if (!this.isMetaInfEntryNamesInitialized) {
            ArrayList<String> list = new ArrayList<String>(8);
            Enumeration<JarArchiveEntry> allEntries = this.entries();
            while (allEntries.hasMoreElements()) {
                ZipArchiveEntry ze = allEntries.nextElement();
                if (!ze.getName().startsWith(META_INF_DIR) || ze.getName().length() <= META_INF_DIR.length()) continue;
                list.add(ze.getName());
            }
            this.metaInfEntryNames = list.size() == 0 ? null : list.toArray(new String[list.size()]);
            this.isMetaInfEntryNamesInitialized = true;
        }
        return this.metaInfEntryNames;
    }

    public JarArchiveEntry getJarEntry(String name) {
        return (JarArchiveEntry)this.getEntry(name);
    }

    @Override
    public ZipArchiveEntry getEntry(String name) {
        ZipArchiveEntry ze = super.getEntry(name);
        if (ze != null) {
            return new JarFileEntry(ze);
        }
        return null;
    }

    public Enumeration<JarArchiveEntry> entries() {
        final Enumeration enum_ = super.getEntries();
        return new Enumeration<JarArchiveEntry>(){

            @Override
            public boolean hasMoreElements() {
                return enum_.hasMoreElements();
            }

            @Override
            public JarFileEntry nextElement() {
                ZipArchiveEntry ze = (ZipArchiveEntry)enum_.nextElement();
                return new JarFileEntry(ze);
            }
        };
    }

    public List<String> listEntries() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration enum_ = super.getEntries();
        while (enum_.hasMoreElements()) {
            result.add(((ZipArchiveEntry)enum_.nextElement()).getName());
        }
        return result;
    }

    private void maybeInstantiateVerifier() throws IOException {
        if (this.jv != null) {
            return;
        }
        if (this.verify) {
            String[] names = this.getMetaInfEntryNames();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i].toUpperCase(Locale.ENGLISH);
                    if (!name.endsWith(".DSA") && !name.endsWith(".RSA") && !name.endsWith(".SF")) continue;
                    this.getManifest();
                    return;
                }
            }
            this.verify = false;
        }
    }

    private void initializeVerifier() {
        ManifestEntryVerifier mev = null;
        try {
            String[] names = this.getMetaInfEntryNames();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    byte[] b;
                    JarArchiveEntry e = this.getJarEntry(names[i]);
                    if (e.isDirectory()) continue;
                    if (mev == null) {
                        mev = new ManifestEntryVerifier(this.getManifestFromReference());
                    }
                    if ((b = this.getBytes(e)) == null || b.length <= 0) continue;
                    this.jv.beginEntry(e, mev);
                    this.jv.update(b.length, b, 0, b.length, mev);
                    this.jv.update(-1, null, 0, 0, mev);
                }
            }
        }
        catch (IOException ex) {
            this.jv = null;
            this.verify = false;
        }
        if (this.jv != null) {
            this.jv.doneWithMeta();
            if (JarVerifier.debug != null) {
                JarVerifier.debug.println("done with meta!");
            }
            if (this.jv.nothingToVerify()) {
                if (JarVerifier.debug != null) {
                    JarVerifier.debug.println("nothing to verify!");
                }
                this.jv = null;
                this.verify = false;
            }
        }
    }

    private byte[] getBytes(ZipArchiveEntry ze) throws IOException {
        byte[] b = new byte[(int)ze.getSize()];
        DataInputStream is = new DataInputStream(this.getSuperInputStream(ze));
        is.readFully(b, 0, b.length);
        is.close();
        return b;
    }

    private InputStream getSuperInputStream(ZipArchiveEntry ze) throws IOException {
        return super.getInputStream(super.getEntry(ze.getName()));
    }

    @Override
    public synchronized InputStream getInputStream(ZipArchiveEntry ze) throws IOException {
        this.maybeInstantiateVerifier();
        InputStream superIs = this.getSuperInputStream(ze);
        if (this.jv == null) {
            return superIs;
        }
        if (!this.jvInitialized) {
            this.initializeVerifier();
            this.jvInitialized = true;
            if (this.jv == null) {
                return superIs;
            }
        }
        return new JarVerifier.VerifierStream(this.getManifestFromReference(), ze instanceof JarFileEntry ? (JarArchiveEntry)ze : this.getJarEntry(ze.getName()), superIs, this.jv);
    }

    public synchronized byte[] getEntryBytes(String entryName) throws IOException {
        ZipArchiveEntry entry = this.getEntry(entryName);
        byte[] result = new byte[(int)entry.getSize()];
        try (DataInputStream is = new DataInputStream(this.getInputStream(entry));){
            is.readFully(result, 0, result.length);
        }
        return result;
    }

    private JarArchiveEntry getManEntry() {
        if (this.manEntry == null) {
            String[] names;
            this.manEntry = this.getJarEntry(MANIFEST_NAME);
            if (this.manEntry == null && (names = this.getMetaInfEntryNames()) != null) {
                for (int i = 0; i < names.length; ++i) {
                    if (!MANIFEST_NAME.equals(names[i].toUpperCase(Locale.ENGLISH))) continue;
                    this.manEntry = this.getJarEntry(names[i]);
                    break;
                }
            }
        }
        return this.manEntry;
    }

    public boolean hasClassPathAttribute() throws IOException {
        JarArchiveEntry manEntry;
        if (this.computedHasClassPathAttribute) {
            return this.hasClassPathAttribute;
        }
        this.hasClassPathAttribute = false;
        if (!this.isKnownToNotHaveClassPathAttribute() && (manEntry = this.getManEntry()) != null) {
            char c;
            int j;
            byte[] b = new byte[(int)manEntry.getSize()];
            DataInputStream dis = new DataInputStream(this.getSuperInputStream(manEntry));
            dis.readFully(b, 0, b.length);
            dis.close();
            int last = b.length - src.length;
            block0: for (int i = 0; i <= last; i += Math.max(j + 1 - lastOcc[c & 0x7F], optoSft[j])) {
                for (j = 9; j >= 0; --j) {
                    c = (char)b[i + j];
                    char c2 = c = (c - 65 | 90 - c) >= 0 ? (char)(c + 32) : c;
                    if (c == src[j]) continue;
                    continue block0;
                }
                this.hasClassPathAttribute = true;
                break;
            }
        }
        this.computedHasClassPathAttribute = true;
        return this.hasClassPathAttribute;
    }

    private boolean isKnownToNotHaveClassPathAttribute() {
        return false;
    }

    public JavaInternal.JarIndex getJarIndex() throws IOException {
        JarArchiveEntry entry = this.getJarEntry("META-INF/INDEX.LIST");
        if (entry != null) {
            return new JavaInternal.JarIndex(this.getInputStream(entry));
        }
        return null;
    }

    public boolean existsEntry(String entryName) throws IOException {
        return this.getEntry(entryName) != null;
    }

    static {
        src = new char[]{'c', 'l', 'a', 's', 's', '-', 'p', 'a', 't', 'h'};
        lastOcc = new int[128];
        optoSft = new int[10];
        JarFile.lastOcc[99] = 1;
        JarFile.lastOcc[108] = 2;
        JarFile.lastOcc[115] = 5;
        JarFile.lastOcc[45] = 6;
        JarFile.lastOcc[112] = 7;
        JarFile.lastOcc[97] = 8;
        JarFile.lastOcc[116] = 9;
        JarFile.lastOcc[104] = 10;
        for (int i = 0; i < 9; ++i) {
            JarFile.optoSft[i] = 10;
        }
        JarFile.optoSft[9] = 1;
    }

    private class JarFileEntry
    extends JarArchiveEntry {
        JarFileEntry(ZipArchiveEntry ze) {
            super(ze);
        }

        @Override
        public Attributes getAttributes() throws IOException {
            Manifest man = JarFile.this.getManifest();
            if (man != null) {
                return man.getAttributes(this.getName());
            }
            return null;
        }

        @Override
        public Certificate[] getCertificates() {
            Certificate[] cs;
            try {
                JarFile.this.maybeInstantiateVerifier();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.certs == null && JarFile.this.jv != null && (cs = JarFile.this.jv.getCerts(this.getName())) != null) {
                this.certs = (Certificate[])cs.clone();
            }
            return this.certs;
        }

        @Override
        public CodeSigner[] getCodeSigners() {
            CodeSigner[] csg;
            try {
                JarFile.this.maybeInstantiateVerifier();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.signers == null && JarFile.this.jv != null && (csg = JarFile.this.jv.getCodeSigners(this.getName())) != null) {
                this.signers = (CodeSigner[])csg.clone();
            }
            return this.signers;
        }
    }
}

