/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.http.client;

import com.streamscape.Trace;
import com.streamscape.lib.http.client.HTTPConnection;
import com.streamscape.lib.utils.Base64Encoder;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.clients.ClientFactoryConfigurationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HTTPConnectionFactoryHelper {
    public static final String PROPERTY_NAME = "Name";
    public static final String PROPERTY_REALMS = "Realms";
    public static final String PROPERTY_ENABLE_OAUTH = "EnableOAuth";
    public static final String PROPERTY_DEFAULT_AUTH = "DefaultAuth";
    public static final String PROPERTY_PROXY_USER = "ProxyUser";
    public static final String PROPERTY_PROXY_PASSWORD = "ProxyPassword";
    public static final String PROPERTY_PROXY_HOST = "ProxyHost";
    public static final String PROPERTY_PROXY_PORT = "ProxyPort";
    public static final String PROPERTY_TRUST_STORE_FILE = "TrustStore.file";
    public static final String PROPERTY_TRUST_CERTIFICATE = "TrustCertificate";
    public static final String PROPERTY_TRUST_ALL_CERTIFICATES = "TrustAllCertificates";
    public static final String PROPERTY_KEY_STORE_FILE = "KeyStore.file";
    public static final String PROPERTY_KEY_STORE_PASSWORD = "KeyStore.password";
    public static final String PROPERTY_HEADER_PREFIX = "HTTPHeader.";
    private ClientFactory factory;

    public HTTPConnectionFactoryHelper(ClientFactory factory) {
        this.factory = factory;
    }

    public void setName(String name) {
        this.setProperty(PROPERTY_NAME, name);
    }

    public String getName() {
        return this.factory.getProperty(PROPERTY_NAME);
    }

    public void setRealms(List<String> realms) {
        if (realms == null) {
            this.factory.getProperties().remove(PROPERTY_REALMS);
        } else {
            this.setProperty(PROPERTY_REALMS, realms.stream().collect(Collectors.joining(",")));
        }
    }

    public List<String> getRealms() {
        String realms = this.factory.getProperty(PROPERTY_REALMS);
        if (realms != null) {
            return StringUtils.split(realms, ',').stream().map(s -> s.trim()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public String getDefaultAuth() {
        String defaultAuth = this.factory.getProperty(PROPERTY_DEFAULT_AUTH);
        if (defaultAuth != null) {
            defaultAuth = defaultAuth.trim();
        }
        if (defaultAuth != null && defaultAuth.length() == 0) {
            defaultAuth = null;
        }
        return defaultAuth;
    }

    public void setEnableOAuth(boolean enableOAuth) {
        this.setProperty(PROPERTY_ENABLE_OAUTH, String.valueOf(enableOAuth));
    }

    public boolean getEnableOAuth() {
        String enableOAuth = this.factory.getProperty(PROPERTY_ENABLE_OAUTH);
        if (enableOAuth != null) {
            return Boolean.valueOf(enableOAuth);
        }
        return false;
    }

    public void setProxyUser(String proxyUser) {
        this.setProperty(PROPERTY_PROXY_USER, proxyUser);
    }

    public String getProxyUser() {
        return this.factory.getProperty(PROPERTY_PROXY_USER);
    }

    public void setProxyPasswordEncoded(String proxyPasswordEncoded) {
        this.setProperty(PROPERTY_PROXY_PASSWORD, proxyPasswordEncoded);
    }

    public String getProxyPasswordEncoded() {
        return this.factory.getProperty(PROPERTY_PROXY_PASSWORD);
    }

    public void setProxyPassword(String proxyPassword) {
        this.setProxyPasswordEncoded(proxyPassword != null ? new Base64Encoder().encode(proxyPassword.getBytes()) : "");
    }

    public String getProxyPassword() {
        String password = this.getProxyPasswordEncoded();
        if (password != null && password.length() > 0) {
            password = new String(new Base64Encoder().decode(password));
        }
        return password;
    }

    public void setProxyHost(String proxyHost) {
        this.setProperty(PROPERTY_PROXY_HOST, proxyHost);
    }

    public String getProxyHost() {
        return this.factory.getProperty(PROPERTY_PROXY_HOST);
    }

    public void setProxyPort(int proxyPort) {
        this.setProperty(PROPERTY_PROXY_PORT, String.valueOf(proxyPort));
    }

    public Integer getProxyPort() {
        String port = this.factory.getProperty(PROPERTY_PROXY_PORT);
        if (port != null && port.length() > 0) {
            return Integer.valueOf(port);
        }
        return null;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.setProperty(PROPERTY_TRUST_STORE_FILE, trustStoreFile);
    }

    public String getTrustStoreFile() {
        return this.factory.getProperty(PROPERTY_TRUST_STORE_FILE);
    }

    public void setTrustCertificate(String trustCertificate) {
        this.setProperty(PROPERTY_TRUST_CERTIFICATE, trustCertificate);
    }

    public String getTrustCertificate() {
        return this.factory.getProperty(PROPERTY_TRUST_CERTIFICATE);
    }

    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.setProperty(PROPERTY_TRUST_ALL_CERTIFICATES, String.valueOf(trustAllCertificates));
    }

    public Boolean getTrustAllCertificates() {
        String value = this.factory.getProperty(PROPERTY_TRUST_ALL_CERTIFICATES);
        if (value != null && value.length() > 0) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.setProperty(PROPERTY_KEY_STORE_FILE, keyStoreFile);
    }

    public String getKeyStoreFile() {
        return this.factory.getProperty(PROPERTY_KEY_STORE_FILE);
    }

    public void setKeyStorePasswordEncoded(String keyStorePasswordEncoded) {
        this.setProperty(PROPERTY_KEY_STORE_PASSWORD, keyStorePasswordEncoded);
    }

    public String getKeyStorePasswordEncoded() {
        return this.factory.getProperty(PROPERTY_KEY_STORE_PASSWORD);
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.setKeyStorePasswordEncoded(keyStorePassword != null ? new Base64Encoder().encode(keyStorePassword.getBytes()) : "");
    }

    public String getKeyStorePassword() {
        String password = this.getKeyStorePasswordEncoded();
        if (password != null && password.length() > 0) {
            password = new String(new Base64Encoder().decode(password));
        }
        return password;
    }

    public void setHttpHeaders(Map<String, String> headers) {
        ArrayList propertiesToDelete = new ArrayList();
        this.factory.getProperties().keySet().forEach(key -> {
            if (((String)key).startsWith(PROPERTY_HEADER_PREFIX)) {
                propertiesToDelete.add((String)key);
            }
        });
        propertiesToDelete.forEach(p -> this.factory.getProperties().remove(p));
        if (headers != null) {
            headers.entrySet().forEach(entry -> this.setProperty(PROPERTY_HEADER_PREFIX + (String)entry.getKey(), (String)entry.getValue()));
        }
    }

    public Map<String, String> getHttpHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.factory.getProperties().entrySet().forEach(entry -> {
            if (((String)entry.getKey()).startsWith(PROPERTY_HEADER_PREFIX)) {
                headers.put(((String)entry.getKey()).substring(PROPERTY_HEADER_PREFIX.length()), (String)entry.getValue());
            }
        });
        return headers;
    }

    private void setProperty(String name, String value) {
        try {
            this.factory.setProperty(name, value);
        }
        catch (ClientFactoryConfigurationException exception) {
            Trace.logException(this, exception, true);
        }
    }

    public static boolean isHttpFactory(ClientFactory factory) {
        return HTTPConnection.class.getName().equals(factory.getConnectionClassName());
    }
}

