/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.http.client;

import com.streamscape.lib.concurrent.worker.SingleTaskWorker;
import com.streamscape.lib.http.HTTPClient;
import com.streamscape.lib.http.HTTPRequestExecutor;
import com.streamscape.lib.http.NVPair;
import com.streamscape.lib.http.SSLContextFactory;
import com.streamscape.lib.http.client.HTTPConnectionFactoryConnectionService;
import com.streamscape.lib.http.client.HTTPConnectionFactoryHelper;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sdo.http.HTTPResponse;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.factory.connection.FactoryConnectionService;
import com.streamscape.sef.factory.connection.UsableClientConnection;
import com.streamscape.service.osf.clients.AbstractClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class HTTPConnection
extends AbstractClientConnection
implements UsableClientConnection {
    protected String user = null;
    protected String password = null;
    protected String host;
    protected int port = 80;
    protected int timeout = 30;
    protected List<String> realms = new ArrayList<String>();
    protected String defaultAuth = null;
    protected boolean enableOAuth = false;
    protected String proxyUser = null;
    protected String proxyPassword = null;
    protected String proxyHost = null;
    protected Integer proxyPort;
    protected boolean useHttps = false;
    protected String keyStoreFilename = null;
    protected String keyStorePassword = null;
    protected String trustStoreFilename = null;
    protected String trustCertificate = null;
    protected boolean trustAllCertificates = false;
    protected Map<String, String> headers = null;
    protected HTTPRequest pingRequest = null;
    protected HTTPClient httpClient = null;
    protected HTTPClient httpClientPing = null;
    private final ReentrantLock stateLock = new ReentrantLock();
    private final ReentrantLock pingLock = new ReentrantLock();
    private final ReentrantLock executeLock = new ReentrantLock();

    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getSchema() {
        return this.useHttps ? "https" : "http";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int ping() throws ClientException {
        if (this.getState() == ConnectionState.CLOSED) {
            return -2;
        }
        int result = -2;
        ConnectionState newState = null;
        ClientException clientException = null;
        this.pingLock.lock();
        try {
            this.httpClientPing = this.openHTTClient(this.httpClientPing);
            HTTPRequest request = this.pingRequest;
            if (request == null) {
                request = new HTTPRequest();
                request.setMethod("GET");
                request.setUri("/");
            }
            HTTPResponse response = new HTTPRequestExecutor(this.httpClientPing).execute(request);
            this.logDebug("Ping response: " + String.valueOf(response.toString()));
            if (response.getStatusCode() == 200 || this.pingRequest == null) {
                result = 0;
                newState = ConnectionState.CONNECTED;
            } else {
                result = -1;
                newState = ConnectionState.RECONNECTING;
                clientException = new ClientException(1026, "Ping HTTP connection returned status '" + response.getStatusCode() + "'.");
                this.httpClientPing = this.closeHTTClient(this.httpClientPing);
            }
        }
        catch (Exception exception) {
            result = -1;
            newState = ConnectionState.RECONNECTING;
            clientException = new ClientException(1026, "Ping HTTP connection error: " + exception.toString(), exception);
            this.httpClientPing = this.closeHTTClient(this.httpClientPing);
        }
        finally {
            this.stateLock.lock();
            try {
                if (this.getState() != ConnectionState.CLOSED && newState != null) {
                    this.setState(newState);
                    if (clientException != null) {
                        this.raiseException(clientException);
                    }
                }
                if (this.getState() == ConnectionState.CLOSED) {
                    result = -2;
                }
            }
            finally {
                this.stateLock.unlock();
            }
            this.pingLock.unlock();
        }
        return result;
    }

    @Override
    public void connect() throws ClientException {
        this.stateLock.lock();
        try {
            if (this.getState() != ConnectionState.CLOSED) {
                return;
            }
            this.logInfo("Connecting to " + this.getUrl() + "...");
            this.setState(ConnectionState.CONNECTING);
            this.httpClient = this.openHTTClient(this.httpClient);
            if (this.factory.isReliable()) {
                new SingleTaskWorker("SVC:HTTPConnection.Worker", "Pings http connection first time after connect in background."){

                    @Override
                    protected void doExecute() throws FabricException, InterruptedException {
                        try {
                            HTTPConnection.this.ping();
                        }
                        catch (Throwable exception) {
                            HTTPConnection.this.logError("Ping connection failed. Error: " + exception.getMessage());
                        }
                    }
                }.start();
            }
        }
        catch (Exception exception) {
            this.httpClient = this.closeHTTClient(this.httpClient);
            this.setState(ConnectionState.CLOSED);
            this.raiseException(exception);
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public void disconnect() throws ClientException {
        this.stateLock.lock();
        try {
            if (this.getState() == ConnectionState.CLOSED) {
                return;
            }
            this.logInfo("Closing HTTP connection...");
            this.setState(ConnectionState.CLOSING);
            this.httpClient = this.closeHTTClient(this.httpClient);
            this.setState(ConnectionState.CLOSED);
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public void raiseException(Exception exception) {
        if (this.getExceptionEventListener() != null) {
            this.getExceptionEventListener().onEvent(new ClientException(1026, (Throwable)exception));
        }
    }

    private boolean isSet(String property) {
        return property != null && property.trim().length() > 0;
    }

    @Override
    public void init(ClientFactory factory) throws ClientException {
        this.factory = factory;
        this.setUrl(factory.getUrl());
        this.user = factory.getDefaultUser();
        this.password = factory.getDefaultPassword();
        this.timeout = factory.getConnectionTimeout();
        HTTPConnectionFactoryHelper helper = new HTTPConnectionFactoryHelper(factory);
        if (helper.getName() == null || helper.getName().length() == 0) {
            this.setName(factory.getFactoryType() + "." + factory.getFactoryName());
        } else {
            this.setName(helper.getName());
        }
        this.timeout = factory.getConnectionTimeout();
        if (this.timeout <= 0) {
            this.logError("WARNING: connection timeout is less then or equals then 0. Set timeout to 30 seconds.");
            this.timeout = 30;
        }
        this.enableOAuth = helper.getEnableOAuth();
        this.proxyHost = helper.getProxyHost();
        this.proxyPort = helper.getProxyPort();
        this.proxyUser = helper.getProxyUser();
        this.proxyPassword = helper.getProxyPassword();
        if (this.useHttps) {
            this.trustStoreFilename = helper.getTrustStoreFile();
            this.keyStoreFilename = helper.getKeyStoreFile();
            this.keyStorePassword = helper.getKeyStorePasswordEncoded();
            this.trustCertificate = helper.getTrustCertificate();
            this.trustAllCertificates = helper.getTrustAllCertificates();
        }
        this.defaultAuth = helper.getDefaultAuth();
        if (this.defaultAuth != null && this.defaultAuth.length() > 0 && !"basic".equalsIgnoreCase(this.defaultAuth)) {
            this.logError("Invalid value is set for defaultAuth property. Only allowed values: basic, but " + this.defaultAuth + ".");
        }
        this.realms = helper.getRealms();
        if (this.realms.size() == 0 && (this.isSet(this.user) || this.isSet(this.proxyUser)) && this.defaultAuth == null) {
            this.logError("Realms not set for HTTP connection '" + this.getName() + "'.");
        }
        this.headers = helper.getHttpHeaders();
    }

    protected HTTPClient openHTTClient(HTTPClient client) throws ClientException {
        if (client != null) {
            return client;
        }
        try {
            client = new HTTPClient(this.getSchema(), this.host, this.port);
            client.setTimeout(this.timeout * 1000);
            client.setAllowUserInteraction(false);
            client.setContext(new Object());
            if (this.isSet(this.user) && this.password != null) {
                if (this.realms.size() > 0) {
                    for (String realm : this.realms) {
                        client.addDigestAuthorization(realm, this.user, this.password);
                        client.addBasicAuthorization(realm, this.user, this.password);
                    }
                } else if ("basic".equalsIgnoreCase(this.defaultAuth)) {
                    client.addBasicAuthorizationDefault(this.user, this.password);
                }
            }
            if (this.enableOAuth) {
                client.enableOAuthAuthentication();
            }
            if (this.headers != null && this.headers.size() > 0) {
                NVPair[] nvheaders = new NVPair[this.headers.size()];
                int count = 0;
                for (Map.Entry<String, String> header : this.headers.entrySet()) {
                    nvheaders[count++] = new NVPair(header.getKey(), header.getValue());
                }
                client.setDefaultHeaders(nvheaders);
            }
            if (this.isSet(this.proxyHost)) {
                client.setCurrentProxy(this.proxyHost, this.proxyPort);
                if (this.isSet(this.proxyUser) && this.proxyPassword != null) {
                    for (String realm : this.realms) {
                        client.addDigestAuthorization(realm, this.proxyUser, this.proxyPassword);
                        client.addBasicAuthorization(realm, this.proxyUser, this.proxyPassword);
                    }
                }
            }
            if (this.useHttps) {
                SSLContextFactory sslContextFactory = new SSLContextFactory();
                if (this.isSet(this.keyStoreFilename)) {
                    sslContextFactory.setKeyStore(this.keyStoreFilename, this.keyStorePassword);
                }
                if (this.isSet(this.trustStoreFilename)) {
                    sslContextFactory.addTrustStore(this.trustStoreFilename, null);
                }
                if (this.isSet(this.trustCertificate)) {
                    sslContextFactory.addTrustCertificate("trust.certificate.alias", this.trustCertificate);
                }
                if (this.trustAllCertificates) {
                    sslContextFactory.trustAllCertificates();
                }
                client.setSSLContextFactory(sslContextFactory);
            }
            return client;
        }
        catch (Exception e) {
            client = this.closeHTTClient(client);
            throw new ClientException(1026, "Open HTTP connection error: " + e.toString(), e);
        }
    }

    protected HTTPClient closeHTTClient(HTTPClient client) {
        if (client != null) {
            client.stop();
            client.destory();
            client = null;
        }
        return client;
    }

    public HTTPResponse execute(HTTPRequest request) throws ClientException {
        this.executeLock.lock();
        try {
            HTTPClient client = null;
            this.stateLock.lock();
            try {
                if (this.getState() == ConnectionState.CLOSED || this.getState() == ConnectionState.CLOSING) {
                    throw new ClientException(1026, "Connection is not opened.");
                }
                client = this.httpClient = this.openHTTClient(this.httpClient);
            }
            finally {
                this.stateLock.unlock();
            }
            try {
                HTTPResponse hTTPResponse = new HTTPRequestExecutor(client).execute(request);
                return hTTPResponse;
            }
            catch (Exception e) {
                this.httpClient = this.closeHTTClient(this.httpClient);
                throw new ClientException(1026, "HTTP connection error: " + e.toString(), e);
            }
        }
        finally {
            this.executeLock.unlock();
        }
    }

    private void setUrl(String url) throws ClientException {
        String proto = this.getUrlProtocol(url, "http");
        if (proto.equalsIgnoreCase("http")) {
            this.useHttps = false;
            this.port = 80;
        } else if (proto.equalsIgnoreCase("https")) {
            this.useHttps = true;
            this.port = 443;
        } else {
            throw new ClientException(1006, "Invalid HTTP proto '" + proto + "' in url '" + url + "'.");
        }
        this.host = this.getUrlHost(url);
        this.port = this.getUrlPort(url, this.port);
    }

    @Override
    public String getUrl() {
        return this.getSchema() + "://" + this.host + ":" + this.port;
    }

    public String toString() {
        return "HTTPConnection(" + this.getUrl() + ")";
    }

    @Override
    public FactoryConnectionService createConnectionService() {
        return new HTTPConnectionFactoryConnectionService(this);
    }
}

