/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.http;

import com.streamscape.Trace;
import com.streamscape.lib.http.Codecs;
import com.streamscape.lib.http.HashVerifier;
import com.streamscape.lib.http.RoResponse;
import java.io.IOException;

class VerifyMD5
implements HashVerifier {
    RoResponse resp;

    public VerifyMD5(RoResponse resp) {
        this.resp = resp;
    }

    @Override
    public void verifyHash(byte[] hash, long len) throws IOException {
        String hdr;
        try {
            hdr = this.resp.getHeader("Content-MD5");
            if (hdr == null) {
                hdr = this.resp.getTrailer("Content-MD5");
            }
        }
        catch (IOException ioe) {
            return;
        }
        if (hdr == null) {
            return;
        }
        byte[] ContMD5 = Codecs.base64Decode(hdr.trim().getBytes("8859_1"));
        for (int idx = 0; idx < hash.length; ++idx) {
            if (hash[idx] == ContMD5[idx]) continue;
            throw new IOException("MD5-Digest mismatch: expected " + VerifyMD5.hex(ContMD5) + " but calculated " + VerifyMD5.hex(hash));
        }
        Trace.logDebug(this, "Hash successfully verified");
    }

    private static String hex(byte[] buf) {
        StringBuffer str = new StringBuffer(buf.length * 3);
        for (int idx = 0; idx < buf.length; ++idx) {
            str.append(Character.forDigit(buf[idx] >>> 4 & 0xF, 16));
            str.append(Character.forDigit(buf[idx] & 0xF, 16));
            str.append(':');
        }
        str.setLength(str.length() - 1);
        return str.toString();
    }
}

