/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.http;

import com.streamscape.Trace;
import com.streamscape.lib.http.ChunkedInputStream;
import com.streamscape.lib.http.HTTPClientModule;
import com.streamscape.lib.http.HttpHeaderElement;
import com.streamscape.lib.http.ModuleException;
import com.streamscape.lib.http.NVPair;
import com.streamscape.lib.http.ParseException;
import com.streamscape.lib.http.Request;
import com.streamscape.lib.http.Response;
import com.streamscape.lib.http.RoRequest;
import com.streamscape.lib.http.UncompressInputStream;
import com.streamscape.lib.http.Util;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

class TransferEncodingModule
implements HTTPClientModule {
    TransferEncodingModule() {
    }

    @Override
    public int requestHandler(Request req, Response[] resp) throws ModuleException {
        Vector<HttpHeaderElement> pte;
        int idx;
        NVPair[] hdrs = req.getHeaders();
        for (idx = 0; idx < hdrs.length && !hdrs[idx].getName().equalsIgnoreCase("TE"); ++idx) {
        }
        if (idx == hdrs.length) {
            hdrs = Util.resizeArray(hdrs, idx + 1);
            req.setHeaders(hdrs);
            pte = new Vector<HttpHeaderElement>();
        } else {
            try {
                pte = Util.parseHeader(hdrs[idx].getValue());
            }
            catch (ParseException pe) {
                throw new ModuleException(pe.toString());
            }
        }
        HttpHeaderElement all = Util.getElement(pte, "*");
        if (all != null) {
            NVPair[] params = all.getParams();
            for (idx = 0; idx < params.length && !params[idx].getName().equalsIgnoreCase("q"); ++idx) {
            }
            if (idx == params.length) {
                return 0;
            }
            if (params[idx].getValue() == null || params[idx].getValue().length() == 0) {
                throw new ModuleException("Invalid q value for \"*\" in TE header: ");
            }
            try {
                if ((double)Float.valueOf(params[idx].getValue()).floatValue() > 0.0) {
                    return 0;
                }
            }
            catch (NumberFormatException nfe) {
                throw new ModuleException("Invalid q value for \"*\" in TE header: " + nfe.getMessage());
            }
        }
        if (!pte.contains(new HttpHeaderElement("deflate"))) {
            pte.addElement(new HttpHeaderElement("deflate"));
        }
        if (!pte.contains(new HttpHeaderElement("gzip"))) {
            pte.addElement(new HttpHeaderElement("gzip"));
        }
        if (!pte.contains(new HttpHeaderElement("compress"))) {
            pte.addElement(new HttpHeaderElement("compress"));
        }
        hdrs[idx] = new NVPair("TE", Util.assembleHeader(pte));
        return 0;
    }

    @Override
    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    @Override
    public int responsePhase2Handler(Response resp, Request req) {
        return 10;
    }

    @Override
    public void responsePhase3Handler(Response resp, RoRequest req) throws IOException, ModuleException {
        Vector pte;
        String te = resp.getHeader("Transfer-Encoding");
        if (te == null || req.getMethod().equals("HEAD")) {
            return;
        }
        try {
            pte = Util.parseHeader(te);
        }
        catch (ParseException pe) {
            throw new ModuleException(pe.toString());
        }
        while (pte.size() > 0) {
            String encoding = ((HttpHeaderElement)pte.lastElement()).getName();
            if (encoding.equalsIgnoreCase("gzip")) {
                Trace.logDebug(this, "Pushing gzip-input-stream");
                resp.inp_stream = new GZIPInputStream(resp.inp_stream);
            } else if (encoding.equalsIgnoreCase("deflate")) {
                Trace.logDebug(this, "Pushing inflater-input-stream");
                resp.inp_stream = new InflaterInputStream(resp.inp_stream);
            } else if (encoding.equalsIgnoreCase("compress")) {
                Trace.logDebug(this, "Pushing uncompress-input-stream");
                resp.inp_stream = new UncompressInputStream(resp.inp_stream);
            } else if (encoding.equalsIgnoreCase("chunked")) {
                Trace.logDebug(this, "Pushing chunked-input-stream");
                resp.inp_stream = new ChunkedInputStream(resp.inp_stream);
            } else if (encoding.equalsIgnoreCase("identity")) {
                Trace.logDebug(this, "Ignoring 'identity' token");
            } else {
                Trace.logDebug(this, "Unknown transfer encoding '" + encoding + "'");
                break;
            }
            pte.removeElementAt(pte.size() - 1);
        }
        if (pte.size() > 0) {
            resp.setHeader("Transfer-Encoding", Util.assembleHeader(pte));
        } else {
            resp.deleteHeader("Transfer-Encoding");
        }
    }

    @Override
    public void trailerHandler(Response resp, RoRequest req) {
    }
}

